/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.util.List;
import java.util.Stack;
import org.netbeans.modules.xml.xdm.nodes.Attribute;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Element;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Text;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;
import org.netbeans.modules.xml.xdm.visitor.XMLNodeVisitor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class NodeByPositionVisitor
implements XMLNodeVisitor {
    private int currentPos = 0;
    private Node rootNode;
    private boolean found;
    private int position;
    private Node foundNode;
    private Stack<Element> stack = new Stack();

    public NodeByPositionVisitor(Node rootNode) {
        this.rootNode = rootNode;
    }

    public Element getContainingElement(int position) {
        Node node = this.getContainingNode(position);
        if (node instanceof Attribute || node instanceof Text) {
            if (this.stack.isEmpty()) {
                return null;
            }
            return this.stack.peek();
        }
        return (Element)node;
    }

    public Node getContainingNode(int position) {
        this.reset();
        this.position = position;
        this.rootNode.accept(this);
        return this.foundNode;
    }

    public void reset() {
        this.currentPos = 0;
        this.found = false;
        this.foundNode = null;
    }

    @Override
    public void visit(Document doc) {
        this.currentPos += this.getLengthOfTokens(doc);
        NodeList nodes = doc.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = (Node)nodes.item(i);
            n.accept(this);
            if (!this.found) continue;
            return;
        }
    }

    @Override
    public void visit(Element e) {
        this.stack.push(e);
        int openStartElemPos = this.currentPos;
        this.currentPos += this.getTokenLength(e, TokenType.TOKEN_WHITESPACE);
        this.currentPos += this.getElementStartTokenLength(e, true);
        NamedNodeMap attrs = e.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = (Node)attrs.item(i);
            attr.accept(this);
            if (!this.found) continue;
            return;
        }
        ++this.currentPos;
        int closeStartElemPos = this.currentPos;
        if (this.position >= openStartElemPos && this.position < closeStartElemPos) {
            this.foundNode = e;
            this.found = true;
        }
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = (Node)children.item(i);
            n.accept(this);
            if (!this.found) continue;
            return;
        }
        this.stack.pop();
        int openEndElemPos = this.currentPos;
        this.currentPos += this.getElementStartTokenLength(e, false);
        ++this.currentPos;
        int closeEndElemPos = this.currentPos;
        if (this.position >= openEndElemPos && this.position < closeEndElemPos) {
            this.foundNode = e;
            this.found = true;
        }
    }

    @Override
    public void visit(Text txt) {
        int beginTextPos = this.currentPos;
        this.currentPos += this.getLengthOfTokens(txt);
        int endTextPos = this.currentPos;
        if (this.position >= beginTextPos && this.position < endTextPos) {
            this.foundNode = txt;
            this.found = true;
        }
    }

    @Override
    public void visit(Attribute attr) {
        int beginAttrPos = this.currentPos;
        this.currentPos += this.getLengthOfTokens(attr);
        int endAttrPos = this.currentPos;
        if (this.position >= beginAttrPos && this.position < endAttrPos) {
            this.foundNode = attr;
            this.found = true;
        }
    }

    private int getElementStartTokenLength(Element element, boolean beginTag) {
        String value = "";
        List<Token> tokens = element.getTokens();
        for (Token token : tokens) {
            if (token.getType() != TokenType.TOKEN_ELEMENT_START_TAG) continue;
            String tokenValue = token.getValue();
            if (beginTag) {
                if (tokenValue.startsWith("</")) continue;
                value = tokenValue;
                continue;
            }
            if (!tokenValue.startsWith("</")) continue;
            value = tokenValue;
        }
        return value.length();
    }

    private int getTokenLength(NodeImpl node, TokenType type) {
        StringBuffer buf = new StringBuffer("");
        List<Token> tokens = node.getTokens();
        for (Token token : tokens) {
            if (token.getType() != type) continue;
            buf.append(token.getValue());
        }
        return buf.toString().length();
    }

    private int getLeadingWhiteSpaces(Attribute attr) {
        Token firstToken = attr.getTokens().get(0);
        if (firstToken.getType() == TokenType.TOKEN_WHITESPACE) {
            return firstToken.getValue().length();
        }
        return 0;
    }

    private int getLengthOfTokens(NodeImpl node) {
        StringBuffer buf = new StringBuffer();
        List<Token> tokens = node.getTokens();
        for (Token token : tokens) {
            buf.append(token.getValue());
        }
        return buf.length();
    }
}

