/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.beans.FxProperty;
import org.netbeans.modules.javafx2.editor.completion.impl.Completer;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.impl.ValueItem;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.spi.editor.completion.CompletionItem;

public class IdReferenceCompleter
implements Completer,
Completer.Factory {
    private static final String ICON_RESOURCE = "org/netbeans/modules/javafx2/editor/resources/variable_ref.png";
    private CompletionContext ctx;

    public IdReferenceCompleter() {
    }

    IdReferenceCompleter(CompletionContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public List<? extends CompletionItem> complete() {
        Set<String> names = this.ctx.getModel().getInstanceNames();
        String prefix = this.ctx.getPrefix();
        if (prefix.startsWith("$")) {
            prefix = prefix.substring(1);
        }
        FxProperty prop = this.ctx.getEnclosingProperty();
        TypeMirror el = prop.getType().resolve(this.ctx.getCompilationInfo());
        ArrayList<ValueItem> items = new ArrayList<ValueItem>();
        for (String s : names) {
            TypeElement clazz;
            if (!prefix.isEmpty() && !s.startsWith(prefix)) continue;
            FxInstance inst = this.ctx.getModel().getInstance(s);
            if (inst == null) {
                throw new IllegalStateException();
            }
            FxBean def = inst.getDefinition();
            if (def == null || def.getJavaType() != null && (clazz = (TypeElement)def.getJavaType().resolve(this.ctx.getCompilationInfo())) != null && !this.ctx.getCompilationInfo().getTypes().isAssignable(el, clazz.asType())) continue;
            items.add(new ValueItem(this.ctx, s, "$", ICON_RESOURCE));
        }
        return items;
    }

    @Override
    public boolean hasMoreItems() {
        return false;
    }

    @Override
    public Completer createCompleter(CompletionContext ctx) {
        switch (ctx.getType()) {
            case VARIABLE: 
            case PROPERTY_VALUE: 
            case PROPERTY_VALUE_CONTENT: {
                break;
            }
            default: {
                return null;
            }
        }
        FxProperty prop = ctx.getEnclosingProperty();
        if (prop == null) {
            return null;
        }
        return new IdReferenceCompleter(ctx);
    }
}

