/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.access.JSHasPropertyNode;
import com.oracle.truffle.js.nodes.array.JSArrayElementIndexNode;
import com.oracle.truffle.js.nodes.array.JSArrayLastElementIndexNodeGen;
import com.oracle.truffle.js.nodes.array.JSArrayPreviousElementIndexNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;

public abstract class JSArrayLastElementIndexNode
extends JSArrayElementIndexNode {
    protected JSArrayLastElementIndexNode(JSContext context) {
        super(context);
    }

    public static JSArrayLastElementIndexNode create(JSContext context) {
        return JSArrayLastElementIndexNodeGen.create(context);
    }

    public final long executeLong(TruffleObject object, long length) {
        return this.executeLong(object, length, this.isArray(object));
    }

    public abstract long executeLong(TruffleObject var1, long var2, boolean var4);

    @Specialization(guards={"isArray", "!hasPrototypeElements(object)", "getArrayType(object, isArray) == cachedArrayType", "!cachedArrayType.hasHoles(object, isArray)"}, limit="MAX_CACHED_ARRAY_TYPES")
    public long doWithoutHolesCached(DynamicObject object, long length, boolean isArray, @Cached(value="getArrayTypeIfArray(object, isArray)") ScriptArray cachedArrayType) {
        assert (JSArrayLastElementIndexNode.isSupportedArray(object) && cachedArrayType == JSArrayLastElementIndexNode.getArrayType(object, isArray));
        return cachedArrayType.lastElementIndex(object, isArray);
    }

    @Specialization(guards={"isArray", "!hasPrototypeElements(object)", "!hasHoles(object, isArray)"}, replaces={"doWithoutHolesCached"})
    public long doWithoutHolesUncached(DynamicObject object, long length, boolean isArray) {
        assert (JSArrayLastElementIndexNode.isSupportedArray(object));
        return JSArrayLastElementIndexNode.getArrayType(object, isArray).lastElementIndex(object, isArray);
    }

    @Specialization(guards={"isArray", "!hasPrototypeElements(object)", "getArrayType(object, isArray) == cachedArrayType", "cachedArrayType.hasHoles(object, isArray)"}, limit="MAX_CACHED_ARRAY_TYPES")
    public long doWithHolesCached(DynamicObject object, long length, boolean isArray, @Cached(value="getArrayTypeIfArray(object, isArray)") ScriptArray cachedArrayType, @Cached(value="create(context)") JSArrayPreviousElementIndexNode previousElementIndexNode, @Cached(value="createBinaryProfile()") ConditionProfile isLengthMinusOne) {
        assert (JSArrayLastElementIndexNode.isSupportedArray(object) && cachedArrayType == JSArrayLastElementIndexNode.getArrayType(object, isArray));
        return this.holesArrayImpl(object, length, cachedArrayType, previousElementIndexNode, isLengthMinusOne, isArray);
    }

    @Specialization(guards={"isArray", "hasPrototypeElements(object) || hasHoles(object, isArray)"}, replaces={"doWithHolesCached"})
    public long doWithHolesUncached(DynamicObject object, long length, boolean isArray, @Cached(value="create(context)") JSArrayPreviousElementIndexNode previousElementIndexNode, @Cached(value="createBinaryProfile()") ConditionProfile isLengthMinusOne, @Cached(value="createClassProfile()") ValueProfile arrayTypeProfile) {
        assert (JSArrayLastElementIndexNode.isSupportedArray(object));
        ScriptArray arrayType = (ScriptArray)arrayTypeProfile.profile((Object)JSArrayLastElementIndexNode.getArrayType(object, isArray));
        return this.holesArrayImpl(object, length, arrayType, previousElementIndexNode, isLengthMinusOne, isArray);
    }

    private long holesArrayImpl(DynamicObject object, long length, ScriptArray array, JSArrayPreviousElementIndexNode previousElementIndexNode, ConditionProfile isLengthMinusOne, boolean isArray) {
        long lastIndex = array.lastElementIndex(object, isArray);
        if (isLengthMinusOne.profile(lastIndex == length - 1L)) {
            return lastIndex;
        }
        DynamicObject prototype = object;
        while (prototype != Null.instance) {
            long candidate = previousElementIndexNode.executeLong(prototype, length);
            if ((lastIndex = Math.max(lastIndex, candidate)) >= length - 1L) {
                return length - 1L;
            }
            if (this.context.getArrayPrototypeNoElementsAssumption().isValid()) break;
            prototype = JSObject.getPrototype(prototype);
        }
        return lastIndex;
    }

    @Specialization(guards={"!isArray", "!isArraySuitableForEnumBasedProcessing(object, length)"})
    public long doObject(TruffleObject object, long length, boolean isArray, @Cached(value="create()") JSHasPropertyNode hasPropertyNode) {
        long index;
        for (index = length - 1L; !hasPropertyNode.executeBoolean((Object)object, index) && index > 0L; --index) {
        }
        return index;
    }

    @Specialization(guards={"!isArray", "isArraySuitableForEnumBasedProcessing(object, length)"})
    public long doObjectViaEnumeration(DynamicObject object, long length, boolean isArray, @Cached(value="create()") JSHasPropertyNode hasPropertyNode) {
        long lengthMinusOne = length - 1L;
        if (hasPropertyNode.executeBoolean((Object)object, lengthMinusOne)) {
            return lengthMinusOne;
        }
        return JSArrayLastElementIndexNode.doObjectViaEnumerationIntl(object, lengthMinusOne);
    }

    @CompilerDirectives.TruffleBoundary
    private static long doObjectViaEnumerationIntl(DynamicObject object, long lengthMinusOne) {
        long result = -1L;
        for (Object key : JSObject.ownPropertyKeys(object)) {
            long candidate;
            if (key == null || !(key instanceof String) || (candidate = JSRuntime.propertyNameToIntegerIndex((String)key)) >= lengthMinusOne || candidate <= result) continue;
            result = candidate;
        }
        return result;
    }
}

