/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorRejectNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorResolveNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorResumeNextNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import com.oracle.truffle.js.nodes.function.SpecializedNewObjectNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayDeque;

public final class AsyncGeneratorBodyNode
extends JavaScriptNode {
    @Node.Child
    private SpecializedNewObjectNode createAsyncGeneratorObject;
    @Node.Child
    private PropertySetNode setGeneratorState;
    @Node.Child
    private PropertySetNode setGeneratorContext;
    @Node.Child
    private PropertySetNode setGeneratorTarget;
    @Node.Child
    private PropertySetNode setGeneratorQueue;
    @CompilerDirectives.CompilationFinal
    RootCallTarget resumeTarget;
    private final JSContext context;
    @Node.Child
    private JavaScriptNode functionBody;
    @Node.Child
    private JSWriteFrameSlotNode writeYieldValueNode;
    @Node.Child
    private JSReadFrameSlotNode readYieldResultNode;
    @Node.Child
    private JSWriteFrameSlotNode writeAsyncContext;

    public AsyncGeneratorBodyNode(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode writeYieldValueNode, JSReadFrameSlotNode readYieldResultNode, JSWriteFrameSlotNode writeAsyncContext) {
        this.writeAsyncContext = writeAsyncContext;
        this.createAsyncGeneratorObject = SpecializedNewObjectNode.create(context, false, true, true, true);
        this.setGeneratorState = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_STATE_ID, context);
        this.setGeneratorContext = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_CONTEXT_ID, context);
        this.setGeneratorTarget = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_TARGET_ID, context);
        this.setGeneratorQueue = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_QUEUE_ID, context);
        this.context = context;
        this.functionBody = body;
        this.writeYieldValueNode = writeYieldValueNode;
        this.readYieldResultNode = readYieldResultNode;
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode body, JSWriteFrameSlotNode writeYieldValueNode, JSReadFrameSlotNode readYieldResultNode, JSWriteFrameSlotNode writeAsyncContext) {
        return new AsyncGeneratorBodyNode(context, body, writeYieldValueNode, readYieldResultNode, writeAsyncContext);
    }

    private void initializeCallTarget() {
        CompilerAsserts.neverPartOfCompilation();
        this.atomic(() -> {
            AsyncGeneratorRootNode asyncGeneratorRootNode = new AsyncGeneratorRootNode(this.context, this.functionBody, this.writeYieldValueNode, this.readYieldResultNode, this.getRootNode().getSourceSection());
            this.resumeTarget = Truffle.getRuntime().createCallTarget((RootNode)asyncGeneratorRootNode);
            this.functionBody = null;
            this.writeYieldValueNode = null;
            this.readYieldResultNode = null;
        });
    }

    private void ensureCallTargetInitialized() {
        if (this.resumeTarget == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.initializeCallTarget();
        }
    }

    private void asyncGeneratorStart(VirtualFrame frame, DynamicObject generatorObject) {
        MaterializedFrame materializedFrame = frame.materialize();
        this.setGeneratorState.setValue(generatorObject, (Object)JSFunction.AsyncGeneratorState.SuspendedStart);
        this.setGeneratorContext.setValue(generatorObject, materializedFrame);
        this.setGeneratorTarget.setValue(generatorObject, this.resumeTarget);
        this.setGeneratorQueue.setValue(generatorObject, new ArrayDeque(4));
        this.writeAsyncContext.executeWrite(frame, new Object[]{this.resumeTarget, generatorObject, materializedFrame});
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.ensureCallTargetInitialized();
        DynamicObject generatorObject = this.createAsyncGeneratorObject.execute(frame, JSFrameUtil.getFunctionObject((Frame)frame));
        this.asyncGeneratorStart(frame, generatorObject);
        return generatorObject;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        if (this.resumeTarget == null) {
            return AsyncGeneratorBodyNode.create(this.context, AsyncGeneratorBodyNode.cloneUninitialized(this.functionBody), AsyncGeneratorBodyNode.cloneUninitialized(this.writeYieldValueNode), AsyncGeneratorBodyNode.cloneUninitialized(this.readYieldResultNode), AsyncGeneratorBodyNode.cloneUninitialized(this.writeAsyncContext));
        }
        AsyncGeneratorRootNode generatorRoot = (AsyncGeneratorRootNode)this.resumeTarget.getRootNode();
        return AsyncGeneratorBodyNode.create(this.context, AsyncGeneratorBodyNode.cloneUninitialized(generatorRoot.functionBody), AsyncGeneratorBodyNode.cloneUninitialized(generatorRoot.writeYieldValue), AsyncGeneratorBodyNode.cloneUninitialized(generatorRoot.readYieldResult), AsyncGeneratorBodyNode.cloneUninitialized(this.writeAsyncContext));
    }

    @NodeInfo(cost=NodeCost.NONE, language="JavaScript", description="The root node of async generator functions in JavaScript.")
    private static final class AsyncGeneratorRootNode
    extends JavaScriptRootNode {
        @Node.Child
        private PropertySetNode setGeneratorState;
        @Node.Child
        private JavaScriptNode functionBody;
        @Node.Child
        private JSWriteFrameSlotNode writeYieldValue;
        @Node.Child
        private JSReadFrameSlotNode readYieldResult;
        @Node.Child
        private AsyncGeneratorResolveNode asyncGeneratorResolveNode;
        @Node.Child
        private AsyncGeneratorRejectNode asyncGeneratorRejectNode;
        @Node.Child
        private AsyncGeneratorResumeNextNode asyncGeneratorResumeNextNode;
        @Node.Child
        private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
        private final ValueProfile typeProfile = ValueProfile.createClassProfile();
        private final JSContext context;

        AsyncGeneratorRootNode(JSContext context, JavaScriptNode functionBody, JSWriteFrameSlotNode writeYieldValueNode, JSReadFrameSlotNode readYieldResultNode, SourceSection functionSourceSection) {
            super(context.getLanguage(), functionSourceSection, null);
            this.setGeneratorState = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_STATE_ID, context);
            this.functionBody = functionBody;
            this.writeYieldValue = writeYieldValueNode;
            this.readYieldResult = readYieldResultNode;
            this.context = context;
            this.asyncGeneratorResolveNode = AsyncGeneratorResolveNode.create(context);
            this.asyncGeneratorResumeNextNode = AsyncGeneratorResumeNextNode.createTailCall(context);
        }

        public Object execute(VirtualFrame frame) {
            Object[] arguments = frame.getArguments();
            MaterializedFrame generatorFrame = JSFrameUtil.castMaterializedFrame(arguments[0]);
            DynamicObject generatorObject = (DynamicObject)arguments[1];
            Completion completion = (Completion)arguments[2];
            while (true) {
                assert (generatorObject.get((Object)JSFunction.ASYNC_GENERATOR_STATE_ID) == JSFunction.AsyncGeneratorState.Executing || generatorObject.get((Object)JSFunction.ASYNC_GENERATOR_STATE_ID) == JSFunction.AsyncGeneratorState.SuspendedYield);
                this.writeYieldValue.executeWrite((VirtualFrame)generatorFrame, completion);
                try {
                    Object result = this.functionBody.execute((VirtualFrame)generatorFrame);
                    this.setGeneratorState.setValue(generatorObject, (Object)JSFunction.AsyncGeneratorState.Completed);
                    this.asyncGeneratorResolveNode.performResolve(frame, generatorObject, result, true);
                }
                catch (YieldException e) {
                    if (e.isYield()) {
                        this.setGeneratorState.setValue(generatorObject, (Object)JSFunction.AsyncGeneratorState.SuspendedYield);
                        this.asyncGeneratorResolveNode.performResolve(frame, generatorObject, e.getResult(), false);
                    }
                    assert (e.isAwait());
                    return Undefined.instance;
                }
                catch (Throwable e) {
                    if (this.shouldCatch(e)) {
                        this.setGeneratorState.setValue(generatorObject, (Object)JSFunction.AsyncGeneratorState.Completed);
                        Object reason = this.getErrorObjectNode.execute(e);
                        this.asyncGeneratorRejectNode.performReject((VirtualFrame)generatorFrame, generatorObject, reason);
                    }
                    throw e;
                }
                Object nextCompletion = this.asyncGeneratorResumeNextNode.execute((VirtualFrame)generatorFrame, generatorObject);
                if (!(nextCompletion instanceof Completion)) break;
                completion = (Completion)nextCompletion;
            }
            return Undefined.instance;
        }

        private boolean shouldCatch(Throwable exception) {
            if (this.getErrorObjectNode == null || this.asyncGeneratorRejectNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
                this.asyncGeneratorRejectNode = (AsyncGeneratorRejectNode)this.insert(AsyncGeneratorRejectNode.create(this.context));
            }
            return TryCatchNode.shouldCatch(exception, this.typeProfile);
        }

        @Override
        public boolean isResumption() {
            return true;
        }
    }
}

