/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.wizard.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.groovy.support.wizard.JUnit;
import org.netbeans.modules.groovy.support.wizard.ProjectTypeStrategy;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public class MavenProjectTypeStrategy
extends ProjectTypeStrategy {
    private static final String JUNIT_GROUP_ID = "junit";
    private static final String JUNIT_ARTIFACT_ID = "junit";
    private final FileObject pom;

    public MavenProjectTypeStrategy(Project project) {
        super(project);
        this.pom = project.getProjectDirectory().getFileObject("pom.xml");
    }

    @Override
    public JUnit findJUnitVersion() {
        this.performOperation(new FindJUnitDependencyVersion());
        return this.jUnitVersion;
    }

    @Override
    public void addJUnitLibrary(JUnit jUnit) {
        this.performOperation(new AddJUnitDependency(jUnit));
    }

    private void performOperation(final ModelOperation<POMModel> operation) {
        try {
            this.pom.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    Utilities.performPOMModelOperations((FileObject)MavenProjectTypeStrategy.this.pom, Collections.singletonList(operation));
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public boolean existsGroovyTestFolder(List<SourceGroup> groups) {
        return this.existsFolder(groups, "/test/groovy");
    }

    @Override
    public boolean existsGroovySourceFolder(List<SourceGroup> groups) {
        return this.existsFolder(groups, "/main/groovy");
    }

    private boolean existsFolder(List<SourceGroup> groups, String suffix) {
        for (SourceGroup group : groups) {
            if (!group.getRootFolder().getPath().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createGroovyTestFolder() {
        FileObject childFolder = this.createFolder(this.project.getProjectDirectory(), "src");
        FileObject testFolder = this.createFolder(childFolder, "test");
        this.createFolder(testFolder, "groovy");
    }

    @Override
    public void createGroovySourceFolder() {
        FileObject childFolder = this.createFolder(this.project.getProjectDirectory(), "src");
        FileObject testFolder = this.createFolder(childFolder, "main");
        this.createFolder(testFolder, "groovy");
    }

    @Override
    public List<SourceGroup> moveTestFolderAsFirst(List<SourceGroup> groups) {
        return this.moveAsFirst(groups, "/test/groovy").subList(0, 1);
    }

    @Override
    public List<SourceGroup> moveSourceFolderAsFirst(List<SourceGroup> groups) {
        return this.moveAsFirst(groups, "/main/groovy");
    }

    private static class AddJUnitDependency
    implements ModelOperation<POMModel> {
        private JUnit jUnit;

        public AddJUnitDependency(JUnit jUnit) {
            this.jUnit = jUnit;
        }

        public void performOperation(POMModel model) {
            Dependency dependency = model.getFactory().createDependency();
            dependency.setArtifactId("junit");
            dependency.setGroupId("junit");
            dependency.setVersion(this.jUnit.getVersion());
            model.getProject().addDependency(dependency);
        }
    }

    private class FindJUnitDependencyVersion
    implements ModelOperation<POMModel> {
        private FindJUnitDependencyVersion() {
        }

        public void performOperation(POMModel model) {
            String declaredVersion;
            Dependency jUnitDependency = ModelUtils.checkModelDependency((POMModel)model, (String)"junit", (String)"junit", (boolean)false);
            if (jUnitDependency != null && (declaredVersion = jUnitDependency.getVersion()) != null) {
                String majorVersion;
                int indexOfFirstDot = declaredVersion.indexOf(".");
                if (indexOfFirstDot == -1) {
                    indexOfFirstDot = declaredVersion.length();
                }
                if (Integer.parseInt(majorVersion = declaredVersion.substring(0, indexOfFirstDot)) < 4) {
                    MavenProjectTypeStrategy.this.jUnitVersion = JUnit.JUNIT3;
                } else {
                    MavenProjectTypeStrategy.this.jUnitVersion = JUnit.JUNIT4;
                }
            }
            if (MavenProjectTypeStrategy.this.jUnitVersion == null) {
                MavenProjectTypeStrategy.this.jUnitVersion = JUnit.NOT_DECLARED;
            }
        }
    }
}

