/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.DataViewTableUIModel;
import org.openide.util.Mutex;

class DataViewPageContext {
    public static final String PROP_pageSize = "pageSize";
    public static final String PROP_currentPos = "currentPos";
    public static final String PROP_tableMetaData = "tableMetaData";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private int pageSize = 10;
    private int currentPos = 1;
    private DataViewDBTable tableMetaData = null;
    private final DataViewTableUIModel model = new DataViewTableUIModel(new DBColumn[0]);

    DataViewPageContext(int pageSize) {
        this.pageSize = pageSize;
    }

    public DataViewDBTable getTableMetaData() {
        return this.tableMetaData;
    }

    public void setTableMetaData(DataViewDBTable tableMetaData) {
        DataViewDBTable old = this.tableMetaData;
        this.tableMetaData = tableMetaData;
        this.firePropertyChange(PROP_tableMetaData, old, tableMetaData);
        this.resetEditableState();
    }

    void resetEditableState() {
        this.model.setEditable(this.tableMetaData == null ? false : this.tableMetaData.hasOneTable());
    }

    int getPageSize() {
        return this.pageSize;
    }

    synchronized void setPageSize(int pageSize) {
        int oldPageSize = this.pageSize;
        this.pageSize = pageSize;
        this.firePropertyChange(PROP_pageSize, oldPageSize, pageSize);
    }

    int getCurrentPos() {
        return this.currentPos;
    }

    private synchronized void setCurrentPos(int currentPos) {
        int oldPos = this.currentPos;
        this.currentPos = currentPos;
        this.firePropertyChange(PROP_currentPos, oldPos, currentPos);
    }

    synchronized void first() {
        this.setCurrentPos(1);
    }

    synchronized void previous() {
        this.setCurrentPos(this.getCurrentPos() - this.pageSize);
    }

    synchronized void next() {
        this.setCurrentPos(this.getCurrentPos() + this.pageSize);
    }

    DataViewTableUIModel getModel() {
        return this.model;
    }

    boolean hasRows() {
        return this.model.getRowCount() > 0;
    }

    boolean hasNext() {
        if (this.pageSize == 0) {
            return false;
        }
        return this.getModel().getRowCount() >= this.pageSize;
    }

    boolean hasOnePageOnly() {
        return this.pageSize == 0 || this.getModel().getRowCount() < this.pageSize;
    }

    boolean hasPrevious() {
        return this.pageSize != 0 && this.currentPos - this.pageSize > 0 && this.hasRows();
    }

    boolean isLastPage() {
        return this.pageSize == 0 || this.getModel().getRowCount() < this.pageSize;
    }

    boolean refreshRequiredOnInsert() {
        return this.pageSize == 0 || this.isLastPage() && this.model.getRowCount() <= this.pageSize;
    }

    protected void firePropertyChange(final String propertyName, final Object oldValue, final Object newValue) {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                DataViewPageContext.this.pcs.firePropertyChange(propertyName, oldValue, newValue);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }
}

