/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.client;

import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.wireprotocol.MonitoredNumbersResponse;

public class MonitoredData {
    private long[] gcFinishs;
    private long[] gcStarts;
    private long[] generalMNumbers;
    private String[] newThreadClassNames;
    private int[] newThreadIds;
    private String[] newThreadNames;
    private long[] stateTimestamps;
    private int[] threadIds;
    private byte[][] threadStates = new byte[20][20];
    private int[] exThreadIds;
    private long[] exStateTimestamps;
    private byte[] exThreadStates;
    private int mode = 0;
    private int nNewThreads;
    private int nThreadStates;
    private int nThreads;
    private int serverState;
    private int serverProgress;

    private MonitoredData(MonitoredNumbersResponse mresp) {
        long[] gn = mresp.getGeneralMonitoredNumbers();
        this.generalMNumbers = new long[gn.length];
        System.arraycopy(gn, 0, this.generalMNumbers, 0, gn.length);
        this.mode = mresp.getThreadsDataMode();
        if (this.mode == 1) {
            this.nThreads = mresp.getNThreads();
            this.nThreadStates = mresp.getNThreadStates();
            int[] ids = mresp.getThreadIds();
            this.threadIds = new int[this.nThreads];
            System.arraycopy(ids, 0, this.threadIds, 0, this.nThreads);
            long[] ts = mresp.getStateTimestamps();
            this.stateTimestamps = new long[this.nThreadStates];
            System.arraycopy(ts, 0, this.stateTimestamps, 0, this.nThreadStates);
            this.setThreadStates(mresp.getThreadStates());
        } else if (this.mode == 2) {
            int expLen = mresp.getExactThreadIds().length;
            this.exThreadIds = new int[expLen];
            System.arraycopy(mresp.getExactThreadIds(), 0, this.exThreadIds, 0, expLen);
            this.exThreadStates = new byte[expLen];
            System.arraycopy(mresp.getExactThreadStates(), 0, this.exThreadStates, 0, expLen);
            this.exStateTimestamps = new long[expLen];
            System.arraycopy(mresp.getExactStateTimestamps(), 0, this.exStateTimestamps, 0, expLen);
        }
        this.nNewThreads = mresp.getNNewThreads();
        if (this.nNewThreads > 0) {
            int[] newIds = mresp.getNewThreadIds();
            this.newThreadIds = new int[this.nNewThreads];
            System.arraycopy(newIds, 0, this.newThreadIds, 0, this.nNewThreads);
            this.newThreadNames = new String[this.nNewThreads];
            System.arraycopy(mresp.getNewThreadNames(), 0, this.newThreadNames, 0, this.nNewThreads);
            this.newThreadClassNames = new String[this.nNewThreads];
            System.arraycopy(mresp.getNewThreadClassNames(), 0, this.newThreadClassNames, 0, this.nNewThreads);
        }
        this.gcStarts = mresp.getGCStarts();
        MonitoredData.convertToTimeInMillis(this.gcStarts);
        this.gcFinishs = mresp.getGCFinishs();
        MonitoredData.convertToTimeInMillis(this.gcFinishs);
        this.serverState = mresp.getServerState();
        this.serverProgress = mresp.getServerProgress();
    }

    public int getServerState() {
        return this.serverState;
    }

    public int getServerProgress() {
        return this.serverProgress;
    }

    public long getFreeMemory() {
        return this.generalMNumbers[0];
    }

    public long[] getGCFinishs() {
        return this.gcFinishs;
    }

    public long[] getGCStarts() {
        return this.gcStarts;
    }

    public long getLastGCPauseInMS() {
        return this.generalMNumbers[6];
    }

    public long getLoadedClassesCount() {
        return this.generalMNumbers[7];
    }

    public long getProcessCpuTime() {
        return this.generalMNumbers[8];
    }

    public static MonitoredData getMonitoredData(MonitoredNumbersResponse mresp) {
        return new MonitoredData(mresp);
    }

    public int getNNewThreads() {
        return this.nNewThreads;
    }

    public long getNSurvivingGenerations() {
        return this.generalMNumbers[4];
    }

    public long getNSystemThreads() {
        return this.generalMNumbers[3];
    }

    public int getNThreadStates() {
        return this.nThreadStates;
    }

    public int getNThreads() {
        return this.nThreads;
    }

    public long getNUserThreads() {
        return this.generalMNumbers[2];
    }

    public String[] getNewThreadClassNames() {
        return this.newThreadClassNames;
    }

    public int[] getNewThreadIds() {
        return this.newThreadIds;
    }

    public String[] getNewThreadNames() {
        return this.newThreadNames;
    }

    public int getThreadsDataMode() {
        return this.mode;
    }

    public int[] getExplicitThreadIds() {
        return this.exThreadIds;
    }

    public long[] getExplicitStateTimestamps() {
        return this.exStateTimestamps;
    }

    public byte[] getExplicitThreadStates() {
        return this.exThreadStates;
    }

    public long getRelativeGCTimeInPerMil() {
        return this.generalMNumbers[5];
    }

    public long[] getStateTimestamps() {
        return this.stateTimestamps;
    }

    public int[] getThreadIds() {
        return this.threadIds;
    }

    public byte[][] getThreadStates() {
        return this.threadStates;
    }

    public long getTimestamp() {
        return this.generalMNumbers[9];
    }

    public long getTotalMemory() {
        return this.generalMNumbers[1];
    }

    private static void convertToTimeInMillis(long[] hiResTimeStamp) {
        if (hiResTimeStamp.length > 0) {
            ProfilingSessionStatus session = TargetAppRunner.getDefault().getProfilingSessionStatus();
            long statupInCounts = session.startupTimeInCounts;
            long startupMillis = session.startupTimeMillis;
            for (int i = 0; i < hiResTimeStamp.length; ++i) {
                hiResTimeStamp[i] = startupMillis + (hiResTimeStamp[i] - statupInCounts) / 1000000L;
            }
        }
    }

    private void setThreadStates(byte[] packedStates) {
        this.threadStates = new byte[this.nThreads][this.nThreadStates];
        int idx = 0;
        for (int i = 0; i < this.nThreads; ++i) {
            System.arraycopy(packedStates, idx, this.threadStates[i], 0, this.nThreadStates);
            idx += this.nThreadStates;
        }
    }

    private void print() {
        int i;
        for (i = 0; i < this.nThreads; ++i) {
            System.err.print("id = ");
            System.err.print(this.threadIds[i]);
            System.err.print(", states = ");
            for (int j = 0; j < this.nThreadStates; ++j) {
                System.err.print(this.threadStates[i][j]);
            }
            System.err.println();
        }
        if (this.nNewThreads > 0) {
            System.err.println("New threads added: " + this.nNewThreads);
            for (i = 0; i < this.nNewThreads; ++i) {
                System.err.println("  id = " + this.newThreadIds[i] + ", name = " + this.newThreadNames[i] + ", classname = " + this.newThreadClassNames[i]);
            }
        }
        System.err.println();
    }
}

