/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.jpda.ui.WatchPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ConditionsPanel
extends JPanel {
    private static final int MAX_SAVED_CONDITIONS = 10;
    private JTextField tfConditionFieldForUI;
    private JComboBox cbHitStyle;
    private JCheckBox cbWhenHitCount;
    private JCheckBox classExcludeFilterCheckBox;
    private JLabel classExcludeFilterLabel;
    private JTextField classExcludeFilterTextField;
    private JCheckBox classFilterCheckBox;
    private JLabel classIncludeFilterLabel;
    private JTextField classIncludeFilterTextField;
    private JCheckBox conditionCheckBox;
    private JComboBox conditionComboBox;
    private JPanel panelHitCountFilter;
    private JScrollPane spCondition;
    private JEditorPane tfCondition;
    private JTextField tfHitCountFilter;

    public ConditionsPanel(String helpId) {
        Border b;
        this.initComponents();
        HelpCtx.setHelpIDString((JComponent)this.tfCondition, (String)helpId);
        this.tfConditionFieldForUI = new JTextField();
        this.tfConditionFieldForUI.setEnabled(false);
        this.tfConditionFieldForUI.setToolTipText(this.tfCondition.getToolTipText());
        String lafID = UIManager.getLookAndFeel().getID();
        if (lafID.equals("Windows") || lafID.startsWith("FlatLaf")) {
            this.tfConditionFieldForUI.setBorder(BorderFactory.createEmptyBorder());
            this.spCondition.setBorder(BorderFactory.createEmptyBorder());
        }
        this.classFilterCheckBoxActionPerformed(null);
        this.conditionCheckBoxActionPerformed(null);
        this.cbWhenHitCountActionPerformed(null);
        int preferredHeight = this.tfConditionFieldForUI.getPreferredSize().height;
        Dimension spDim = this.spCondition.getPreferredSize();
        if (spDim.height > preferredHeight) {
            preferredHeight = spDim.height;
            this.tfConditionFieldForUI.setPreferredSize(new Dimension(this.tfConditionFieldForUI.getPreferredSize().width, preferredHeight));
        }
        if ((b = this.spCondition.getBorder()) instanceof WatchPanel.DelegatingBorder) {
            Insets insets = ((WatchPanel.DelegatingBorder)b).getInsets();
            insets.right = 1;
            ((WatchPanel.DelegatingBorder)b).setInsets(insets);
        }
        this.spCondition.setPreferredSize(spDim);
        this.tfHitCountFilter.setPreferredSize(new Dimension(8 * this.tfHitCountFilter.getFontMetrics(this.tfHitCountFilter.getFont()).charWidth('8'), this.tfHitCountFilter.getPreferredSize().height));
        this.cbHitStyle.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.cbWhenHitCount.equals"), NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.cbWhenHitCount.greater"), NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.cbWhenHitCount.multiple")}));
        this.conditionComboBox.setEditor(new ConditionComboBoxEditor());
        Object[] conditions = ConditionsPanel.getSavedConditions();
        this.conditionComboBox.setModel(new DefaultComboBoxModel<Object>(conditions));
    }

    private static Object[] getSavedConditions() {
        return Properties.getDefault().getProperties("debugger.jpda").getArray("BPConditions", new Object[0]);
    }

    public void showCondition(boolean show) {
        this.conditionCheckBox.setVisible(show);
        if (show) {
            this.conditionCheckBoxActionPerformed(null);
        } else {
            this.conditionComboBox.setVisible(show);
        }
    }

    public void showClassFilter(boolean show) {
        this.classFilterCheckBox.setVisible(show);
        this.classIncludeFilterLabel.setVisible(show);
        this.classIncludeFilterTextField.setVisible(show);
        this.classExcludeFilterLabel.setVisible(show);
        this.classExcludeFilterTextField.setVisible(show);
        this.classExcludeFilterCheckBox.setVisible(false);
    }

    public void showExclusionClassFilter(boolean show) {
        this.showClassFilter(false);
        if (show) {
            this.classExcludeFilterCheckBox.setVisible(show);
            this.classExcludeFilterTextField.setVisible(show);
        }
        this.classExcludeFilterCheckBoxActionPerformed(null);
    }

    public void setClassMatchFilter(String[] filter) {
        String filterStr = this.getFilterStr(filter);
        this.classIncludeFilterTextField.setText(filterStr);
        this.classFilterCheckBox.setSelected(filterStr.length() > 0 || this.classExcludeFilterTextField.getText().length() > 0);
        this.classFilterCheckBoxActionPerformed(null);
    }

    public void setClassExcludeFilter(String[] filter) {
        String filterStr = this.getFilterStr(filter);
        this.classExcludeFilterTextField.setText(filterStr);
        if (this.classFilterCheckBox.isVisible()) {
            this.classFilterCheckBox.setSelected(filterStr.length() > 0 || this.classIncludeFilterTextField.getText().length() > 0);
            this.classFilterCheckBoxActionPerformed(null);
        }
        if (this.classExcludeFilterCheckBox.isVisible()) {
            this.classExcludeFilterCheckBox.setSelected(filterStr.length() > 0);
            this.classExcludeFilterCheckBoxActionPerformed(null);
        }
    }

    public void setCondition(String condition) {
        this.conditionCheckBox.setSelected(condition.length() > 0);
        this.conditionCheckBoxActionPerformed(null);
        this.tfCondition.setText(condition);
    }

    public void setHitCountFilteringStyle(Breakpoint.HIT_COUNT_FILTERING_STYLE style) {
        this.cbHitStyle.setSelectedIndex(style != null ? style.ordinal() : 0);
    }

    public void setHitCount(int hitCount) {
        if (hitCount != 0) {
            this.cbWhenHitCount.setSelected(true);
            this.tfHitCountFilter.setText(Integer.toString(hitCount));
        } else {
            this.cbWhenHitCount.setSelected(false);
            this.tfHitCountFilter.setText("");
        }
        this.cbWhenHitCountActionPerformed(null);
    }

    public void setupConditionPaneContext(String url, int line) {
        WatchPanel.setupContext(this.tfCondition, url, line, 0);
    }

    public void setupConditionPaneContext() {
        WatchPanel.setupContext(this.tfCondition, null);
    }

    private String getFilterStr(String[] filter) {
        if (filter == null || filter.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filter.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(filter[i]);
        }
        return sb.toString();
    }

    static String[] getFilter(String filterStr) {
        if (filterStr == null || filterStr.length() == 0) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(filterStr, ", \t");
        ArrayList<String> strsList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken();
            if (str.length() <= 0) continue;
            strsList.add(str);
        }
        String[] result = new String[strsList.size()];
        strsList.toArray(result);
        return result;
    }

    public String[] getClassMatchFilter() {
        String filterStr = this.classFilterCheckBox.isSelected() ? this.classIncludeFilterTextField.getText().trim() : "";
        return ConditionsPanel.getFilter(filterStr);
    }

    public String[] getClassExcludeFilter() {
        String filterStr = this.classFilterCheckBox.isVisible() && this.classFilterCheckBox.isSelected() || this.classExcludeFilterCheckBox.isVisible() && this.classExcludeFilterCheckBox.isSelected() ? this.classExcludeFilterTextField.getText().trim() : "";
        return ConditionsPanel.getFilter(filterStr);
    }

    public String getCondition() {
        if (this.conditionCheckBox.isSelected()) {
            String condition = this.tfCondition.getText().trim();
            if (condition.length() > 0) {
                condition = ConditionsPanel.adjustCondition(condition);
                Object[] savedConditions = ConditionsPanel.getSavedConditions();
                Object[] conditions = null;
                boolean containsCondition = false;
                for (int i = 0; i < savedConditions.length; ++i) {
                    Object c = savedConditions[i];
                    if (!condition.equals(c)) continue;
                    containsCondition = true;
                    conditions = savedConditions;
                    if (i <= 0) break;
                    System.arraycopy(conditions, 0, conditions, 1, i);
                    conditions[0] = condition;
                    break;
                }
                if (!containsCondition) {
                    if (savedConditions.length < 10) {
                        conditions = new Object[savedConditions.length + 1];
                        conditions[0] = condition;
                        System.arraycopy(savedConditions, 0, conditions, 1, savedConditions.length);
                    } else {
                        conditions = savedConditions;
                        System.arraycopy(conditions, 0, conditions, 1, conditions.length - 1);
                        conditions[0] = condition;
                    }
                }
                Properties.getDefault().getProperties("debugger.jpda").setArray("BPConditions", conditions);
            }
            return condition;
        }
        return "";
    }

    private static String adjustCondition(String condition) {
        while (condition.endsWith(";")) {
            condition = condition.substring(0, condition.length() - 1).trim();
        }
        return condition;
    }

    public Breakpoint.HIT_COUNT_FILTERING_STYLE getHitCountFilteringStyle() {
        if (!this.cbWhenHitCount.isSelected()) {
            return null;
        }
        return Breakpoint.HIT_COUNT_FILTERING_STYLE.values()[this.cbHitStyle.getSelectedIndex()];
    }

    public int getHitCount() {
        if (!this.cbWhenHitCount.isSelected()) {
            return 0;
        }
        String hcfStr = this.tfHitCountFilter.getText().trim();
        try {
            int hitCount = Integer.parseInt(hcfStr);
            return hitCount;
        }
        catch (NumberFormatException nfex) {
            return 0;
        }
    }

    public String valiadateMsg() {
        String hcfStr = this.tfHitCountFilter.getText().trim();
        if (this.cbWhenHitCount.isSelected()) {
            if (hcfStr.length() > 0) {
                int hitCountFilter;
                try {
                    hitCountFilter = Integer.parseInt(hcfStr);
                }
                catch (NumberFormatException e) {
                    return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_Bad_Hit_Count_Filter_Spec", (Object)hcfStr);
                }
                if (hitCountFilter <= 0) {
                    return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_NonPositive_Hit_Count_Filter_Spec");
                }
            } else {
                return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_No_Hit_Count_Filter_Spec");
            }
        }
        if (this.conditionCheckBox.isSelected() && this.tfCondition.getText().trim().length() == 0) {
            return NbBundle.getMessage(ConditionsPanel.class, (String)"MSG_No_Condition_Spec");
        }
        return null;
    }

    static String createClassPatternTip(String filterInfo) {
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append(filterInfo);
        buf.append("<br>");
        buf.append(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_Class_Pattern_Help_1"));
        buf.append("<br>");
        buf.append(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_Class_Pattern_Help_2"));
        buf.append("<br>");
        buf.append(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_Class_Pattern_Help_3"));
        return buf.toString();
    }

    private void initComponents() {
        this.spCondition = new JScrollPane();
        this.tfCondition = new JEditorPane("text/x-java", "");
        this.classFilterCheckBox = new JCheckBox();
        this.classIncludeFilterLabel = new JLabel();
        this.classIncludeFilterTextField = new JTextField();
        this.classExcludeFilterLabel = new JLabel();
        this.classExcludeFilterCheckBox = new JCheckBox();
        this.classExcludeFilterTextField = new JTextField();
        this.conditionCheckBox = new JCheckBox();
        this.panelHitCountFilter = new JPanel();
        this.tfHitCountFilter = new JTextField();
        this.cbHitStyle = new JComboBox();
        this.cbWhenHitCount = new JCheckBox();
        this.conditionComboBox = new JComboBox();
        this.spCondition = this.createScrollableLineEditor();
        this.spCondition.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.spCondition.toolTipText"));
        this.tfCondition.setContentType("text/x-java");
        this.tfCondition.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.tfCondition.toolTipText"));
        this.spCondition.setViewportView(this.tfCondition);
        this.tfCondition.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSN_ConditionTF"));
        this.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ConditionsPanel.class, (String)"L_Conditions_Breakpoint_BorderTitle")));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.classFilterCheckBox, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.classFilterCheckBox.text"));
        this.classFilterCheckBox.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_CB_Classes_Filter_Throwing"));
        this.classFilterCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.classFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionsPanel.this.classFilterCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.classFilterCheckBox, gridBagConstraints);
        this.classIncludeFilterLabel.setLabelFor(this.classIncludeFilterTextField);
        Mnemonics.setLocalizedText((JLabel)this.classIncludeFilterLabel, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.classIncludeFilterLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 3);
        this.add((Component)this.classIncludeFilterLabel, gridBagConstraints);
        this.classIncludeFilterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSD_IncludeClasses_LBL"));
        this.classIncludeFilterTextField.setToolTipText(ConditionsPanel.createClassPatternTip(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_CB_Classes_Matched")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.classIncludeFilterTextField, gridBagConstraints);
        this.classExcludeFilterLabel.setLabelFor(this.classExcludeFilterTextField);
        Mnemonics.setLocalizedText((JLabel)this.classExcludeFilterLabel, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.classExcludeFilterLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 18, 3, 3);
        this.add((Component)this.classExcludeFilterLabel, gridBagConstraints);
        this.classExcludeFilterLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSD_ExcludeClasses_LBL"));
        Mnemonics.setLocalizedText((AbstractButton)this.classExcludeFilterCheckBox, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.classExcludeFilterLabel.text"));
        this.classExcludeFilterCheckBox.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_CB_Classes_Excluded"));
        this.classExcludeFilterCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.classExcludeFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionsPanel.this.classExcludeFilterCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.classExcludeFilterCheckBox, gridBagConstraints);
        this.classExcludeFilterTextField.setToolTipText(ConditionsPanel.createClassPatternTip(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_CB_Classes_Excluded")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.classExcludeFilterTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.conditionCheckBox, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.conditionCheckBox.text"));
        this.conditionCheckBox.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_TF_Line_Breakpoint_Condition"));
        this.conditionCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.conditionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionsPanel.this.conditionCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.conditionCheckBox, gridBagConstraints);
        this.panelHitCountFilter.setLayout(new GridBagLayout());
        this.tfHitCountFilter.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_TF_Hit_Count"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelHitCountFilter.add((Component)this.tfHitCountFilter, gridBagConstraints);
        this.tfHitCountFilter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSN_HitCountTF"));
        this.cbHitStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"equals to", "is greater then", "is multiple of"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        this.panelHitCountFilter.add((Component)this.cbHitStyle, gridBagConstraints);
        this.cbHitStyle.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSN_CB_HitCount"));
        this.cbHitStyle.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSD_CB_HitCount"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbWhenHitCount, (String)NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.cbWhenHitCount.text"));
        this.cbWhenHitCount.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"TTT_TF_Hit_Count"));
        this.cbWhenHitCount.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbWhenHitCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConditionsPanel.this.cbWhenHitCountActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.panelHitCountFilter.add((Component)this.cbWhenHitCount, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.panelHitCountFilter, gridBagConstraints);
        this.conditionComboBox.setEditable(true);
        this.conditionComboBox.setToolTipText(NbBundle.getMessage(ConditionsPanel.class, (String)"ConditionsPanel.spCondition.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 3, 3, 3);
        this.add((Component)this.conditionComboBox, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConditionsPanel.class, (String)"ACSD_Conditions"));
    }

    private void classExcludeFilterCheckBoxActionPerformed(ActionEvent evt) {
        this.classExcludeFilterTextField.setEnabled(this.classExcludeFilterCheckBox.isSelected());
    }

    private void cbWhenHitCountActionPerformed(ActionEvent evt) {
        boolean isSelected = this.cbWhenHitCount.isSelected();
        this.cbHitStyle.setEnabled(isSelected);
        this.tfHitCountFilter.setEnabled(isSelected);
        if (isSelected) {
            this.cbHitStyle.requestFocusInWindow();
        }
    }

    private void conditionCheckBoxActionPerformed(ActionEvent evt) {
        boolean isSelected = this.conditionCheckBox.isSelected();
        this.conditionComboBox.setEnabled(isSelected);
        this.conditionComboBox.setEditor(new ConditionComboBoxEditor());
        this.revalidate();
        this.repaint();
        if (isSelected) {
            this.tfCondition.requestFocusInWindow();
        }
    }

    private void classFilterCheckBoxActionPerformed(ActionEvent evt) {
        boolean classFilterEnabled = this.classFilterCheckBox.isSelected();
        this.classIncludeFilterTextField.setEnabled(classFilterEnabled);
        this.classExcludeFilterTextField.setEnabled(classFilterEnabled);
    }

    private JScrollPane createScrollableLineEditor() {
        JComponent[] editorComponents = Utilities.createSingleLineEditor((String)"text/x-java");
        JScrollPane sp = (JScrollPane)editorComponents[0];
        this.tfCondition = (JEditorPane)editorComponents[1];
        return sp;
    }

    private final class ConditionComboBoxEditor
    implements ComboBoxEditor {
        private ConditionComboBoxEditor() {
        }

        @Override
        public Component getEditorComponent() {
            if (!ConditionsPanel.this.conditionCheckBox.isSelected()) {
                return ConditionsPanel.this.tfConditionFieldForUI;
            }
            return ConditionsPanel.this.spCondition;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject != null) {
                ConditionsPanel.this.tfCondition.setText(anObject.toString());
            } else {
                ConditionsPanel.this.tfCondition.setText("");
            }
        }

        @Override
        public Object getItem() {
            return ConditionsPanel.this.tfCondition.getText();
        }

        @Override
        public void selectAll() {
            ConditionsPanel.this.tfCondition.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }
    }
}

