/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.quicksearch;

import java.awt.Component;
import java.awt.Container;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.WizardUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.quicksearch.NewQuickSearchIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class QuickSearchPanel
extends BasicWizardIterator.Panel {
    private NewQuickSearchIterator.DataModel data;
    private JLabel categoryNameLabel;
    private JTextField categoryNameTextField;
    private JTextField classNameTextField;
    private JLabel commandLabel;
    private JTextField commandPrefixTextField;
    private JLabel fileNameLabel;
    private JComboBox packageCombo;
    private JLabel packageLabel;
    private JLabel positionLabel;
    private JTextField positionTextField;

    QuickSearchPanel(WizardDescriptor settings, NewQuickSearchIterator.DataModel data) {
        super(settings);
        this.data = data;
        this.initComponents();
        this.putClientProperty("NewFileWizard_Title", this.getMessage("LBL_QuickSearchPanel_Title"));
        UIUtil.DocumentAdapter dListener = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                QuickSearchPanel.this.checkValidity();
            }
        };
        if (data.getPackageName() != null) {
            this.packageCombo.setSelectedItem(data.getPackageName());
        }
        this.classNameTextField.getDocument().addDocumentListener((DocumentListener)dListener);
        this.categoryNameTextField.getDocument().addDocumentListener((DocumentListener)dListener);
        this.commandPrefixTextField.getDocument().addDocumentListener((DocumentListener)dListener);
        this.positionTextField.getDocument().addDocumentListener((DocumentListener)dListener);
        Component editorComp = this.packageCombo.getEditor().getEditorComponent();
        if (editorComp instanceof JTextComponent) {
            ((JTextComponent)editorComp).getDocument().addDocumentListener((DocumentListener)dListener);
        }
    }

    @Override
    protected String getPanelName() {
        return this.getMessage("LBL_QuickSearchPanel_Title");
    }

    @Override
    protected void storeToDataModel() {
        this.data.setClassName(this.normalize(this.classNameTextField.getText().trim()));
        this.data.setCommandPrefix(this.commandPrefixTextField.getText().trim());
        this.data.setCategoryName(this.categoryNameTextField.getText().trim());
        this.data.setPosition(Integer.parseInt(this.positionTextField.getText()));
        this.data.setPackageName(this.packageCombo.getEditor().getItem().toString());
        NewQuickSearchIterator.generateFileChanges(this.data);
    }

    @Override
    protected void readFromDataModel() {
        this.classNameTextField.setText(this.data.getClassName());
        this.commandPrefixTextField.setText(this.data.getCommandPrefix());
        this.categoryNameTextField.setText(this.data.getCategoryName());
        this.positionTextField.setText(this.data.getPosition().toString());
        this.packageCombo.setSelectedItem(this.data.getPackageName());
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(QuickSearchPanel.class);
    }

    private boolean checkValidity() {
        String fileName = this.classNameTextField.getText().trim();
        if (fileName.length() == 0) {
            this.setWarning(this.getMessage("ERR_FN_EMPTY"), false);
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)this.normalize(fileName))) {
            this.setError(this.getMessage("ERR_FN_INVALID"));
            return false;
        }
        String packName = this.packageCombo.getEditor().getItem().toString();
        if (packName.equals("")) {
            this.setWarning(this.getMessage("EMPTY_PACKAGE"), false);
            return false;
        }
        if (this.categoryNameTextField.getText().equals("")) {
            this.setWarning(this.getMessage("EMPTY_CATEGORY"), false);
            return false;
        }
        if (this.commandPrefixTextField.getText().trim().equals("")) {
            this.setWarning(this.getMessage("ERR_EMPTY_PREFIX"), false);
        }
        if (!this.commandPrefixTextField.getText().trim().matches("\\w*")) {
            this.setError(this.getMessage("ERR_PREFIX_INVALID"));
            return false;
        }
        if (this.positionTextField.getText().equals("")) {
            this.setWarning(this.getMessage("ERR_POSITION_EMPTY"), false);
            return false;
        }
        if (!this.positionTextField.getText().trim().matches("\\d*")) {
            this.setError(this.getMessage("ERR_POSITION_INVALID"));
            return false;
        }
        this.markValid();
        return true;
    }

    private void initComponents() {
        this.fileNameLabel = new JLabel();
        this.classNameTextField = new JTextField();
        this.packageLabel = new JLabel();
        this.packageCombo = WizardUtils.createPackageComboBox(this.data.getSourceRootGroup());
        this.categoryNameLabel = new JLabel();
        this.categoryNameTextField = new JTextField();
        this.commandLabel = new JLabel();
        this.commandPrefixTextField = new JTextField();
        this.positionLabel = new JLabel();
        this.positionTextField = new JTextField();
        this.fileNameLabel.setLabelFor(this.classNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileNameLabel, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.fileNameLabel.text"));
        this.classNameTextField.setText(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.classNameTextField.text"));
        this.packageLabel.setLabelFor(this.packageCombo);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.packageLabel.text"));
        this.packageCombo.setEditable(true);
        this.categoryNameLabel.setLabelFor(this.categoryNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.categoryNameLabel, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.categoryNameLabel.text"));
        this.categoryNameTextField.setText(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.categoryNameTextField.text"));
        this.commandLabel.setLabelFor(this.commandPrefixTextField);
        Mnemonics.setLocalizedText((JLabel)this.commandLabel, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.commandLabel.text"));
        this.commandPrefixTextField.setText(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.commandPrefixTextField.text"));
        this.positionLabel.setLabelFor(this.positionTextField);
        Mnemonics.setLocalizedText((JLabel)this.positionLabel, (String)NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.positionLabel.text"));
        this.positionTextField.setText(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.positionTextField.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileNameLabel).addComponent(this.packageLabel).addComponent(this.categoryNameLabel).addComponent(this.commandLabel).addComponent(this.positionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classNameTextField, -1, 231, Short.MAX_VALUE).addComponent(this.packageCombo, 0, 231, Short.MAX_VALUE).addComponent(this.categoryNameTextField, -1, 231, Short.MAX_VALUE).addComponent(this.commandPrefixTextField, -1, 231, Short.MAX_VALUE).addComponent(this.positionTextField, -1, 231, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileNameLabel).addComponent(this.classNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageLabel).addComponent(this.packageCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.categoryNameLabel).addComponent(this.categoryNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.commandLabel).addComponent(this.commandPrefixTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.positionLabel).addComponent(this.positionTextField, -2, -1, -2)).addContainerGap(124, Short.MAX_VALUE)));
        this.fileNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.fileNameLabel.AccessibleContext.accessibleDescription"));
        this.classNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.classNameTextField.AccessibleContext.accessibleDescription"));
        this.packageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.packageLabel.AccessibleContext.accessibleDescription"));
        this.packageCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.packageCombo.AccessibleContext.accessibleName"));
        this.packageCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.packageCombo.AccessibleContext.accessibleDescription"));
        this.categoryNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.categoryNameLabel.AccessibleContext.accessibleDescription"));
        this.categoryNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.categoryNameTextField.AccessibleContext.accessibleDescription"));
        this.commandLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.commandLabel.AccessibleContext.accessibleDescription"));
        this.commandPrefixTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.commandPrefixTextField.AccessibleContext.accessibleName"));
        this.commandPrefixTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.commandPrefixTextField.AccessibleContext.accessibleDescription"));
        this.positionLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.positionLabel.AccessibleContext.accessibleDescription"));
        this.positionTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.positionTextField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickSearchPanel.class, (String)"QuickSearchPanel.AccessibleContext.accessibleDescription"));
    }

    private String getMessage(String key) {
        return NbBundle.getMessage(QuickSearchPanel.class, (String)key);
    }

    private String normalize(String trim) {
        if (trim.endsWith(".java")) {
            return trim.substring(0, trim.length() - 5);
        }
        return trim;
    }
}

