/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.action;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.action.DataModel;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.common.WizardUtils;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class NameIconLocationPanel
extends BasicWizardIterator.Panel {
    private static final String NONE_LABEL = NameIconLocationPanel.getMessage("CTL_None");
    private final DataModel data;
    private final DocumentListener updateListener;
    private File smallIconPath;
    private File largeIconPath;
    private JTextField className;
    private JLabel classNameTxt;
    private JTextArea createdFiles;
    private JLabel createdFilesTxt;
    private JTextField displayName;
    private JLabel displayNameTxt;
    private JTextField icon;
    private JButton iconButton;
    private JLabel iconTxt;
    private JTextArea modifiedFiles;
    private JLabel modifiedFilesTxt;
    private JComboBox packageName;
    private JLabel packageNameTxt;
    private JTextField project;
    private JLabel projectTxt;

    public NameIconLocationPanel(WizardDescriptor setting, DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        if (data.getPackageName() != null) {
            this.packageName.setSelectedItem(data.getPackageName());
        }
        this.putClientProperty("NewFileWizard_Title", NameIconLocationPanel.getMessage("LBL_ActionWizardTitle"));
        this.className.select(0, this.className.getText().length());
        this.updateListener = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                NameIconLocationPanel.this.updateData();
            }
        };
    }

    private void addListeners() {
        this.className.getDocument().addDocumentListener(this.updateListener);
        this.displayName.getDocument().addDocumentListener(this.updateListener);
        Component editorComp = this.packageName.getEditor().getEditorComponent();
        if (editorComp instanceof JTextComponent) {
            ((JTextComponent)editorComp).getDocument().addDocumentListener(this.updateListener);
        }
    }

    private void removeListeners() {
        this.className.getDocument().removeDocumentListener(this.updateListener);
        this.displayName.getDocument().removeDocumentListener(this.updateListener);
        Component editorComp = this.packageName.getEditor().getEditorComponent();
        if (editorComp instanceof JTextComponent) {
            ((JTextComponent)editorComp).getDocument().removeDocumentListener(this.updateListener);
        }
    }

    @Override
    protected String getPanelName() {
        return NameIconLocationPanel.getMessage("LBL_NameIconLocation_Title");
    }

    @Override
    protected void storeToDataModel() {
        this.removeListeners();
        this.storeBaseData();
    }

    @Override
    protected void readFromDataModel() {
        this.updateData();
        this.addListeners();
    }

    private void updateData() {
        this.storeBaseData();
        if (this.checkValidity()) {
            CreatedModifiedFiles files = this.data.getCreatedModifiedFiles();
            this.createdFiles.setText(WizardUtils.generateTextAreaContent(files.getCreatedPaths()));
            this.modifiedFiles.setText(WizardUtils.generateTextAreaContent(files.getModifiedPaths()));
        }
    }

    private void storeBaseData() {
        this.data.setClassName(this.getClassName());
        this.data.setPackageName(this.packageName.getEditor().getItem().toString());
        this.data.setIconPath(this.smallIconPath);
        this.data.setLargeIconPath(this.largeIconPath);
        this.data.setDisplayName(this.displayName.getText());
    }

    private String getIconPath() {
        return this.icon.getText().equals(NONE_LABEL) ? null : this.icon.getText();
    }

    private boolean checkValidity() {
        String pName;
        String string = pName = this.packageName.getEditor().getItem() == null ? "" : this.packageName.getEditor().getItem().toString().trim();
        if (!Utilities.isJavaIdentifier((String)this.getClassName())) {
            this.setError(NameIconLocationPanel.getMessage("MSG_ClassNameMustBeValidJavaIdentifier"));
        } else if (this.getDisplayName().trim().length() == 0) {
            this.setInfo(NameIconLocationPanel.getMessage("MSG_DisplayNameMustBeEntered"), false);
        } else if (pName.length() == 0 || !WizardUtils.isValidPackageName(pName)) {
            this.setError(NameIconLocationPanel.getMessage("ERR_Package_Invalid"));
        } else if (this.classAlreadyExists()) {
            this.setError(NameIconLocationPanel.getMessage("MSG_ClassAlreadyExists"));
        } else if (this.data.isToolbarEnabled() && this.getIconPath() == null) {
            this.setError(NameIconLocationPanel.getMessage("MSG_IconRequiredForToolbar"));
        } else {
            String[] invalid = this.data.getCreatedModifiedFiles().getInvalidPaths();
            if (invalid.length > 0) {
                this.setWarning(WizardUtils.getIconAlreadyExistsWarning(invalid[0]));
            } else {
                this.markValid();
                this.checkIconValidity();
                return true;
            }
        }
        return false;
    }

    private void checkIconValidity() {
        if (this.smallIconPath == null) {
            this.setWarning(WizardUtils.getNoIconSelectedWarning(16, 16));
        } else if (!WizardUtils.isValidIcon(this.smallIconPath, 16, 16)) {
            this.setWarning(WizardUtils.getIconDimensionWarning(this.smallIconPath, 16, 16));
        } else if (this.data.isToolbarEnabled() && this.largeIconPath == null) {
            assert (this.smallIconPath.getParentFile() != null);
            String name = NameIconLocationPanel.getName(this.smallIconPath);
            String ext = NameIconLocationPanel.getExt(this.smallIconPath);
            StringBuffer sb = new StringBuffer();
            sb.append(name).append("24");
            if (ext != null) {
                sb.append('.').append(ext);
            }
            this.setWarning(NbBundle.getMessage(NameIconLocationPanel.class, (String)"MSG_NoLargeIconSelected", (Object)sb.toString(), (Object)this.smallIconPath.getParent()));
        }
    }

    private static String getName(File smallIconFile) {
        String name = smallIconFile.getName();
        int i = name.lastIndexOf(46);
        return i <= 0 ? name : name.substring(0, i);
    }

    private static String getExt(File smallIconFile) {
        String name = smallIconFile.getName();
        int i = name.lastIndexOf(46) + 1;
        return i <= 1 || i == name.length() ? "" : name.substring(i);
    }

    private static Set<File> getPossibleIcons(String iconPath) {
        File icon = new File(iconPath);
        String[] resultSuffixes = new String[]{"16", "24", ""};
        HashSet<File> results = new HashSet<File>();
        String iconName = icon.getName();
        int idx = iconName.lastIndexOf(46);
        String name = idx != -1 ? iconName.substring(0, idx) : iconName;
        String extension = idx != -1 ? iconName.substring(idx + 1) : null;
        boolean hasSuffix = name.endsWith("24") || name.endsWith("16");
        name = hasSuffix ? name.substring(0, name.length() - 2) : name;
        for (int i = 0; i < resultSuffixes.length; ++i) {
            File f;
            String resultSuffix = resultSuffixes[i];
            String resultName = name + resultSuffix;
            if (extension != null) {
                resultName = resultName + '.' + extension;
            }
            if (!(f = new File(icon.getParentFile(), resultName)).exists()) continue;
            results.add(FileUtil.normalizeFile((File)f));
        }
        return results;
    }

    private boolean classAlreadyExists() {
        return this.data.classExists();
    }

    private String getDisplayName() {
        return this.displayName.getText().trim();
    }

    private String getClassName() {
        return this.className.getText().trim();
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(NameIconLocationPanel.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(NameIconLocationPanel.class, (String)key);
    }

    private void initComponents() {
        this.classNameTxt = new JLabel();
        this.className = new JTextField();
        this.displayNameTxt = new JLabel();
        this.displayName = new JTextField();
        this.iconTxt = new JLabel();
        this.icon = new JTextField();
        this.iconButton = new JButton();
        this.projectTxt = new JLabel();
        this.project = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.packageNameTxt = new JLabel();
        this.packageName = WizardUtils.createPackageComboBox(this.data.getSourceRootGroup());
        this.createdFilesTxt = new JLabel();
        this.createdFiles = new JTextArea();
        this.modifiedFilesTxt = new JLabel();
        this.modifiedFiles = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.classNameTxt.setLabelFor(this.className);
        Mnemonics.setLocalizedText((JLabel)this.classNameTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_ClassName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        this.add(this.classNameTxt, gridBagConstraints);
        this.className.setText(NbBundle.getMessage(NameIconLocationPanel.class, (String)"CTL_SampleClassName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add(this.className, gridBagConstraints);
        this.displayNameTxt.setLabelFor(this.displayName);
        Mnemonics.setLocalizedText((JLabel)this.displayNameTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_DisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        this.add(this.displayNameTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add(this.displayName, gridBagConstraints);
        this.iconTxt.setLabelFor(this.icon);
        Mnemonics.setLocalizedText((JLabel)this.iconTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_Icon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 12);
        this.add(this.iconTxt, gridBagConstraints);
        this.icon.setEditable(false);
        this.icon.setText(NbBundle.getMessage(NameIconLocationPanel.class, (String)"CTL_None"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add(this.icon, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.iconButton, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_Icon_Browse"));
        this.iconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameIconLocationPanel.this.iconButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add(this.iconButton, gridBagConstraints);
        this.projectTxt.setLabelFor(this.project);
        Mnemonics.setLocalizedText((JLabel)this.projectTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add(this.projectTxt, gridBagConstraints);
        this.project.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add(this.project, gridBagConstraints);
        this.packageNameTxt.setLabelFor(this.packageName);
        Mnemonics.setLocalizedText((JLabel)this.packageNameTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_PackageName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.packageNameTxt, gridBagConstraints);
        this.packageName.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.packageName, gridBagConstraints);
        this.createdFilesTxt.setLabelFor(this.createdFiles);
        Mnemonics.setLocalizedText((JLabel)this.createdFilesTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add(this.createdFilesTxt, gridBagConstraints);
        this.createdFiles.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFiles.setColumns(20);
        this.createdFiles.setEditable(false);
        this.createdFiles.setRows(5);
        this.createdFiles.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add(this.createdFiles, gridBagConstraints);
        this.modifiedFilesTxt.setLabelFor(this.modifiedFiles);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFilesTxt, (String)NbBundle.getMessage(NameIconLocationPanel.class, (String)"LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.modifiedFilesTxt, gridBagConstraints);
        this.modifiedFiles.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFiles.setColumns(20);
        this.modifiedFiles.setEditable(false);
        this.modifiedFiles.setRows(5);
        this.modifiedFiles.setToolTipText("modifiedFilesValue");
        this.modifiedFiles.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add(this.modifiedFiles, gridBagConstraints);
    }

    private void iconButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = WizardUtils.getIconFileChooser(this.icon.getText());
        int ret = chooser.showDialog((Component)((Object)this), NameIconLocationPanel.getMessage("LBL_Select"));
        if (ret == 0) {
            File iconFile = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.icon.setText(iconFile.getAbsolutePath());
            Set<File> allFiles = NameIconLocationPanel.getPossibleIcons(this.getIconPath());
            if (!allFiles.remove(iconFile)) {
                return;
            }
            boolean isIconSmall = WizardUtils.isValidIcon(iconFile, 16, 16);
            File secondIcon = null;
            boolean isSecondIconSmall = false;
            Iterator<File> it = allFiles.iterator();
            while (it.hasNext() && !isSecondIconSmall) {
                File f = it.next();
                isSecondIconSmall = isIconSmall ? WizardUtils.isValidIcon(f, 24, 24) : WizardUtils.isValidIcon(f, 16, 16);
                if (!isSecondIconSmall) continue;
                secondIcon = f;
                break;
            }
            if (secondIcon != null) {
                this.smallIconPath = isIconSmall ? iconFile : secondIcon;
                this.largeIconPath = isIconSmall ? secondIcon : iconFile;
            } else {
                this.smallIconPath = iconFile;
                this.largeIconPath = null;
            }
            this.updateData();
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_NameAndLocationPanel"));
        this.className.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_ClassName"));
        this.createdFiles.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_CreatedFiles"));
        this.displayName.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_DisplayName"));
        this.icon.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_Icon"));
        this.iconButton.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_IconButton"));
        this.modifiedFiles.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_ModifiedFiles"));
        this.packageName.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_PackageName"));
        this.project.getAccessibleContext().setAccessibleDescription(NameIconLocationPanel.getMessage("ACS_CTL_Project"));
    }
}

