/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.CompletionTriggerKind;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceJavadocAttacher;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ReferencesCount;
import org.netbeans.api.java.source.ui.ElementJavadoc;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.java.completion.JavaCompletionTask;
import org.netbeans.modules.java.completion.JavaDocumentationTask;
import org.netbeans.modules.java.editor.base.fold.JavaElementFoldVisitor;
import org.netbeans.modules.java.editor.base.semantic.MarkOccurrencesHighlighterBase;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.options.MarkOccurencesSettings;
import org.netbeans.modules.java.hints.errors.CreateFixBase;
import org.netbeans.modules.java.hints.errors.ImportClass;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.introduce.IntroduceFixBase;
import org.netbeans.modules.java.hints.introduce.IntroduceHint;
import org.netbeans.modules.java.hints.introduce.IntroduceKind;
import org.netbeans.modules.java.hints.project.IncompleteClassPath;
import org.netbeans.modules.java.hints.spiimpl.JavaFixImpl;
import org.netbeans.modules.java.hints.spiimpl.Utilities;
import org.netbeans.modules.java.hints.spiimpl.hints.HintsInvoker;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.debugging.utils.ErrorUtilities;
import org.netbeans.modules.java.lsp.server.protocol.CodeGenerator;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.ui.ElementOpenAccessor;
import org.netbeans.modules.java.testrunner.ui.spi.ComputeTestMethods;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.indexing.implspi.ActiveDocumentProvider;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.api.impl.APIAccessor;
import org.netbeans.modules.refactoring.api.impl.SPIAccessor;
import org.netbeans.modules.refactoring.java.spi.hooks.JavaModificationResult;
import org.netbeans.modules.refactoring.plugins.FileRenamePlugin;
import org.netbeans.modules.refactoring.spi.ModificationResult;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.util.lookup.Lookups;

public class TextDocumentServiceImpl
implements TextDocumentService,
LanguageClientAware {
    private static final RequestProcessor BACKGROUND_TASKS = new RequestProcessor(TextDocumentServiceImpl.class.getName(), 1, false, false);
    private static final RequestProcessor WORKER = new RequestProcessor(TextDocumentServiceImpl.class.getName(), 1, false, false);
    private final Map<String, Document> openedDocuments = new HashMap<String, Document>();
    private final Map<String, RequestProcessor.Task> diagnosticTasks = new HashMap<String, RequestProcessor.Task>();
    private NbCodeLanguageClient client;
    private static final RequestProcessor JAVADOC_WORKER = new RequestProcessor(TextDocumentServiceImpl.class.getName() + ".javadoc", 1);
    private static final String DEFAULT_SORT_TEXT = "\uffff";
    private static final int DELAY = 500;
    private static final String[] ERROR_KEYS = new String[]{"errors", "hints"};
    static BiConsumer<String, Object> HOOK_NOTIFICATION = null;

    public TextDocumentServiceImpl() {
        ((RefreshDocument)Lookup.getDefault().lookup(RefreshDocument.class)).register(this);
    }

    private void reRunDiagnostics() {
        HashSet<String> documents = new HashSet<String>(this.openedDocuments.keySet());
        for (String doc : documents) {
            this.runDiagnoticTasks(doc);
        }
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(final CompletionParams params) {
        try {
            final String uri = params.getTextDocument().getUri();
            FileObject file = Utils.fromUri(uri);
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            final int caret = Utils.getOffset(doc, params.getPosition());
            final CompletionList completionList = new CompletionList();
            ParserManager.parse(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    TokenSequence ts = resultIterator.getSnapshot().getTokenHierarchy().tokenSequence(JavaTokenId.language());
                    if (!(ts.move(caret) != 0 && ts.moveNext() || ts.movePrevious())) {
                        ts.moveNext();
                    }
                    int len = caret - ts.offset();
                    boolean allCompletion = params.getContext() != null && params.getContext().getTriggerKind() == CompletionTriggerKind.TriggerForIncompleteCompletions || len > 0 && ts.token().length() >= len && ts.token().id() == JavaTokenId.IDENTIFIER;
                    CompilationController controller = CompilationController.get((Parser.Result)resultIterator.getParserResult(ts.offset()));
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    JavaCompletionTask task = JavaCompletionTask.create((int)caret, (JavaCompletionTask.ItemFactory)new ItemFactoryImpl(TextDocumentServiceImpl.this.client, (CompilationInfo)controller, uri, ts.offset()), allCompletion ? EnumSet.of(JavaCompletionTask.Options.ALL_COMPLETION) : EnumSet.noneOf(JavaCompletionTask.Options.class), () -> false);
                    task.run(resultIterator);
                    List results = task.getResults();
                    if (results != null) {
                        Iterator it = results.iterator();
                        while (it.hasNext()) {
                            CompletionItem item = (CompletionItem)it.next();
                            if (item != null) continue;
                            it.remove();
                        }
                        completionList.setItems(results);
                    }
                    completionList.setIsIncomplete(task.hasAdditionalClasses());
                }
            });
            return CompletableFuture.completedFuture(Either.forRight((Object)completionList));
        }
        catch (IOException | ParseException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void connect(LanguageClient client) {
        this.client = (NbCodeLanguageClient)client;
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(final CompletionItem ci) {
        JsonObject rawData = (JsonObject)ci.getData();
        if (rawData == null) {
            return CompletableFuture.completedFuture(ci);
        }
        final CompletionData data = (CompletionData)new Gson().fromJson((JsonElement)rawData, CompletionData.class);
        try {
            FileObject file = Utils.fromUri(data.uri);
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            final ElementHandle handle = ElementHandleAccessor.getInstance().create(ElementKind.valueOf(data.kind), data.elementHandle);
            final JavaDocumentationTask task = JavaDocumentationTask.create((int)-1, (ElementHandle)handle, (JavaDocumentationTask.DocumentationFactory)new JavaDocumentationTask.DocumentationFactory<Future<String>>(){

                public Future<String> create(CompilationInfo compilationInfo, Element element, Callable<Boolean> cancel) {
                    return ElementJavadoc.create((CompilationInfo)compilationInfo, (Element)element, cancel).getTextAsync();
                }
            }, () -> false);
            final LineMap[] lm = new LineMap[1];
            org.netbeans.api.java.source.ModificationResult mr = org.netbeans.api.java.source.ModificationResult.runModificationTask(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    task.run(resultIterator);
                    if (ci.getDetail() != null) {
                        WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult(data.offset));
                        copy.toPhase(JavaSource.Phase.RESOLVED);
                        Element e = handle.resolve((CompilationInfo)copy);
                        if (e != null) {
                            copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)GeneratorUtilities.get((WorkingCopy)copy).addImports(copy.getCompilationUnit(), Collections.singleton(e)));
                        }
                        lm[0] = copy.getCompilationUnit().getLineMap();
                    }
                }
            });
            List diffs = mr.getDifferences(file);
            if (diffs != null && !diffs.isEmpty()) {
                ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                for (ModificationResult.Difference diff : diffs) {
                    edits.add(new TextEdit(new Range(Utils.createPosition(lm[0], diff.getStartPosition().getOffset()), Utils.createPosition(lm[0], diff.getEndPosition().getOffset())), diff.getNewText()));
                }
                ci.setAdditionalTextEdits(edits);
            }
            final Future futureJavadoc = (Future)task.getDocumentation();
            CompletableFuture<CompletionItem> result = new CompletableFuture<CompletionItem>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return futureJavadoc.cancel(mayInterruptIfRunning) && super.cancel(mayInterruptIfRunning);
                }
            };
            JAVADOC_WORKER.post(() -> {
                try {
                    String javadoc = (String)futureJavadoc.get();
                    MarkupContent markup = new MarkupContent();
                    markup.setKind("markdown");
                    markup.setValue(TextDocumentServiceImpl.html2MD(javadoc));
                    ci.setDocumentation(markup);
                    result.complete(ci);
                }
                catch (InterruptedException | ExecutionException ex) {
                    result.completeExceptionally(ex);
                }
            });
            return result;
        }
        catch (IOException | ParseException ex) {
            CompletableFuture<CompletionItem> result = new CompletableFuture<CompletionItem>();
            result.completeExceptionally(ex);
            return result;
        }
    }

    public static String html2MD(String html) {
        int idx = html.indexOf("<p id=\"not-found\">");
        return FlexmarkHtmlConverter.builder().build().convert(idx >= 0 ? html.substring(0, idx) : html).replaceAll("<br />[ \n]*$", "");
    }

    public CompletableFuture<Hover> hover(HoverParams params) {
        try {
            String uri = params.getTextDocument().getUri();
            FileObject file = Utils.fromUri(uri);
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.openDocument();
            final JavaDocumentationTask task = JavaDocumentationTask.create((int)Utils.getOffset(doc, params.getPosition()), null, (JavaDocumentationTask.DocumentationFactory)new JavaDocumentationTask.DocumentationFactory<Future<String>>(){

                public Future<String> create(CompilationInfo compilationInfo, Element element, Callable<Boolean> cancel) {
                    return ElementJavadoc.create((CompilationInfo)compilationInfo, (Element)element, cancel).getTextAsync();
                }
            }, () -> false);
            ParserManager.parse(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    task.run(resultIterator);
                }
            });
            final Future futureJavadoc = (Future)task.getDocumentation();
            CompletableFuture<Hover> result = new CompletableFuture<Hover>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return futureJavadoc != null && futureJavadoc.cancel(mayInterruptIfRunning) && super.cancel(mayInterruptIfRunning);
                }
            };
            JAVADOC_WORKER.post(() -> {
                try {
                    String javadoc;
                    String string = javadoc = futureJavadoc != null ? (String)futureJavadoc.get() : null;
                    if (javadoc != null) {
                        MarkupContent markup = new MarkupContent();
                        markup.setKind("markdown");
                        markup.setValue(TextDocumentServiceImpl.html2MD(javadoc));
                        result.complete(new Hover(markup));
                    } else {
                        result.complete(null);
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    result.completeExceptionally(ex);
                }
            });
            return result;
        }
        catch (IOException | ParseException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams params) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        JavaSource js = this.getSource(params.getTextDocument().getUri());
        final GoToSupport.GoToTarget[] target = new GoToSupport.GoToTarget[1];
        LineMap[] thisFileLineMap = new LineMap[1];
        try {
            js.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = cc.getSnapshot().getSource().getDocument(true);
                int offset = Utils.getOffset(doc, params.getPosition());
                GoToSupport.Context context = GoToSupport.resolveContext((CompilationInfo)cc, (Document)doc, (int)offset, (boolean)false, (boolean)false);
                if (context == null) {
                    return;
                }
                target[0] = GoToSupport.computeGoToTarget((CompilationController)cc, (GoToSupport.Context)context, (int)offset);
                thisFileLineMap[0] = cc.getCompilationUnit().getLineMap();
            }, true);
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        ArrayList<Location> result = new ArrayList<Location>();
        if (target[0] != null && target[0].success) {
            if (target[0].offsetToOpen < 0) {
                FileObject root;
                ClassPath cp;
                FileObject resource;
                Object[] openInfo = ElementOpenAccessor.getInstance().getOpenInfo(target[0].cpInfo, target[0].elementToOpen, new AtomicBoolean());
                if (openInfo == null && target[0].resourceName != null && (resource = (cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{target[0].cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT), target[0].cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE), target[0].cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE)})).findResource(target[0].resourceName)) != null && (root = cp.findOwnerRoot(resource)) != null) {
                    final CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> future = new CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>>();
                    SourceJavadocAttacher.attachSources((URL)root.toURL(), (SourceJavadocAttacher.AttachmentListener)new SourceJavadocAttacher.AttachmentListener(){

                        public void attachmentSucceeded() {
                            Object[] openInfo = ElementOpenAccessor.getInstance().getOpenInfo(target[0].cpInfo, target[0].elementToOpen, new AtomicBoolean());
                            if (openInfo != null && (Integer)openInfo[1] != -1 && (Integer)openInfo[2] != -1 && openInfo[3] != null) {
                                FileObject file = (FileObject)openInfo[0];
                                int start = (Integer)openInfo[1];
                                int end = (Integer)openInfo[2];
                                LineMap lm = (LineMap)openInfo[3];
                                future.complete(Either.forLeft(Collections.singletonList(new Location(Utils.toUri(file), new Range(Utils.createPosition(lm, start), Utils.createPosition(lm, end))))));
                            }
                        }

                        public void attachmentFailed() {
                            block4: {
                                try {
                                    FileObject generated = org.netbeans.modules.java.classfile.CodeGenerator.generateCode((ClasspathInfo)target[0].cpInfo, (ElementHandle)target[0].elementToOpen);
                                    if (generated == null) break block4;
                                    final int[] pos = new int[]{-1};
                                    try {
                                        JavaSource.create((ClasspathInfo)target[0].cpInfo, (FileObject[])new FileObject[]{generated}).runUserActionTask((Task)new Task<CompilationController>(){

                                            public void run(CompilationController parameter) throws Exception {
                                                TreePath p;
                                                parameter.toPhase(JavaSource.Phase.RESOLVED);
                                                Element el = target[0].elementToOpen.resolve((CompilationInfo)parameter);
                                                if (el != null && (p = parameter.getTrees().getPath(el)) != null) {
                                                    pos[0] = (int)parameter.getTrees().getSourcePositions().getStartPosition(p.getCompilationUnit(), p.getLeaf());
                                                }
                                            }
                                        }, true);
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    int offset = pos[0] != -1 ? pos[0] : 0;
                                    future.complete(Either.forLeft(Collections.singletonList(new Location(Utils.toUri(generated), new Range(Utils.createPosition(generated, offset), Utils.createPosition(generated, offset))))));
                                    return;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            future.complete(Either.forLeft(Collections.emptyList()));
                        }
                    });
                    return future;
                }
                if (openInfo != null && (Integer)openInfo[1] != -1 && (Integer)openInfo[2] != -1 && openInfo[3] != null) {
                    FileObject file = (FileObject)openInfo[0];
                    int start = (Integer)openInfo[1];
                    int end = (Integer)openInfo[2];
                    LineMap lm = (LineMap)openInfo[3];
                    result.add(new Location(Utils.toUri(file), new Range(Utils.createPosition(lm, start), Utils.createPosition(lm, end))));
                }
            } else {
                int start = target[0].offsetToOpen;
                int end = target[0].endPos;
                result.add(new Location(params.getTextDocument().getUri(), new Range(Utils.createPosition(thisFileLineMap[0], start), Utils.createPosition(thisFileLineMap[0], end))));
            }
        }
        return CompletableFuture.completedFuture(Either.forLeft(result));
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        final AtomicBoolean cancel = new AtomicBoolean();
        final Runnable[] cancelCallback = new Runnable[1];
        CompletableFuture<List<? extends Location>> result = new CompletableFuture<List<? extends Location>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                cancel.set(mayInterruptIfRunning);
                if (cancelCallback[0] != null) {
                    cancelCallback[0].run();
                }
                return super.cancel(mayInterruptIfRunning);
            }
        };
        WORKER.post(() -> {
            JavaSource js = this.getSource(params.getTextDocument().getUri());
            try {
                WhereUsedQuery[] query = new WhereUsedQuery[1];
                ArrayList<Location> locations = new ArrayList<Location>();
                js.runUserActionTask(cc -> {
                    Element decl;
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    if (cancel.get()) {
                        return;
                    }
                    Document doc = cc.getSnapshot().getSource().getDocument(true);
                    TreePath path = cc.getTreeUtilities().pathFor(Utils.getOffset(doc, params.getPosition()));
                    if (params.getContext().isIncludeDeclaration() && (decl = cc.getTrees().getElement(path)) != null) {
                        TreePath declPath = cc.getTrees().getPath(decl);
                        if (declPath != null && cc.getCompilationUnit() == declPath.getCompilationUnit()) {
                            Range range = TextDocumentServiceImpl.declarationRange((CompilationInfo)cc, declPath);
                            if (range != null) {
                                locations.add(new Location(Utils.toUri(cc.getFileObject()), range));
                            }
                        } else {
                            JavaSource source;
                            ElementHandle declHandle = ElementHandle.create((Element)decl);
                            FileObject sourceFile = SourceUtils.getFile((ElementHandle)declHandle, (ClasspathInfo)cc.getClasspathInfo());
                            JavaSource javaSource = source = sourceFile != null ? JavaSource.forFileObject((FileObject)sourceFile) : null;
                            if (source != null) {
                                source.runUserActionTask(nestedCC -> {
                                    Range range;
                                    TreePath declPath2;
                                    nestedCC.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    Element declHandle2 = declHandle.resolve((CompilationInfo)nestedCC);
                                    TreePath treePath = declPath2 = declHandle2 != null ? nestedCC.getTrees().getPath(declHandle2) : null;
                                    if (declPath2 != null && (range = TextDocumentServiceImpl.declarationRange((CompilationInfo)nestedCC, declPath2)) != null) {
                                        locations.add(new Location(Utils.toUri(nestedCC.getFileObject()), range));
                                    }
                                }, true);
                            }
                        }
                    }
                    query[0] = new WhereUsedQuery(Lookups.singleton((Object)TreePathHandle.create((TreePath)path, (CompilationInfo)cc)));
                }, true);
                if (cancel.get()) {
                    return;
                }
                cancelCallback[0] = () -> query[0].cancelRequest();
                RefactoringSession refactoring = RefactoringSession.create((String)"FindUsages");
                Problem p = query[0].checkParameters();
                if (cancel.get()) {
                    return;
                }
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                p = query[0].preCheck();
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                if (cancel.get()) {
                    return;
                }
                p = query[0].prepare(refactoring);
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                for (RefactoringElement re : refactoring.getRefactoringElements()) {
                    if (cancel.get()) {
                        return;
                    }
                    locations.add(new Location(Utils.toUri(re.getParentFile()), TextDocumentServiceImpl.toRange(re.getPosition())));
                }
                refactoring.finished();
                result.complete(locations);
            }
            catch (Throwable ex) {
                result.completeExceptionally(ex);
            }
        });
        return result;
    }

    private static Range declarationRange(CompilationInfo info, TreePath tp) {
        int[] span;
        Tree t = tp.getLeaf();
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
            span = info.getTreeUtilities().findNameSpan((ClassTree)t);
        } else if (t.getKind() == Tree.Kind.VARIABLE) {
            span = info.getTreeUtilities().findNameSpan((VariableTree)t);
        } else if (t.getKind() == Tree.Kind.METHOD) {
            span = info.getTreeUtilities().findNameSpan((MethodTree)t);
            if (span == null) {
                span = info.getTreeUtilities().findNameSpan((ClassTree)tp.getParentPath().getLeaf());
            }
        } else {
            return null;
        }
        if (span == null) {
            return null;
        }
        return new Range(Utils.createPosition(info.getCompilationUnit().getLineMap(), span[0]), Utils.createPosition(info.getCompilationUnit().getLineMap(), span[1]));
    }

    private static Range toRange(PositionBounds bounds) throws IOException {
        return new Range(new Position(bounds.getBegin().getLine(), bounds.getBegin().getColumn()), new Position(bounds.getEnd().getLine(), bounds.getEnd().getColumn()));
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams params) {
        Preferences node = MarkOccurencesSettings.getCurrentNode();
        JavaSource js = this.getSource(params.getTextDocument().getUri());
        ArrayList result = new ArrayList();
        try {
            js.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = cc.getSnapshot().getSource().getDocument(true);
                int offset = Utils.getOffset(doc, params.getPosition());
                class MOHighligther
                extends MarkOccurrencesHighlighterBase {
                    MOHighligther() {
                    }

                    protected void process(CompilationInfo arg0, Document arg1, SchedulerEvent arg2) {
                        throw new UnsupportedOperationException("Should not be called.");
                    }

                    public List<int[]> processImpl(CompilationInfo info, Preferences node, Document doc, int caretPosition) {
                        return super.processImpl(info, node, doc, caretPosition);
                    }
                }
                List<int[]> spans = new MOHighligther().processImpl((CompilationInfo)cc, node, doc, offset);
                if (spans != null) {
                    for (int[] span : spans) {
                        result.add(new DocumentHighlight(new Range(Utils.createPosition(cc.getCompilationUnit(), span[0]), Utils.createPosition(cc.getCompilationUnit(), span[1]))));
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        return CompletableFuture.completedFuture(result);
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        JavaSource js = this.getSource(params.getTextDocument().getUri());
        ArrayList result = new ArrayList();
        try {
            js.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                for (Element tel : cc.getTopLevelElements()) {
                    DocumentSymbol ds = this.element2DocumentSymbol((CompilationInfo)cc, tel);
                    if (ds == null) continue;
                    result.add(Either.forRight((Object)ds));
                }
            }, true);
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        return CompletableFuture.completedFuture(result);
    }

    private DocumentSymbol element2DocumentSymbol(CompilationInfo info, Element el) throws BadLocationException {
        TreePath path = info.getTrees().getPath(el);
        if (path == null) {
            return null;
        }
        Range range = Utils.treeRange(info, path.getLeaf());
        if (range == null) {
            return null;
        }
        ArrayList<DocumentSymbol> children = new ArrayList<DocumentSymbol>();
        for (Element element : el.getEnclosedElements()) {
            DocumentSymbol ds = this.element2DocumentSymbol(info, element);
            if (ds == null) continue;
            children.add(ds);
        }
        String simpleName = el.getKind() == ElementKind.CONSTRUCTOR ? el.getEnclosingElement().getSimpleName().toString() : el.getSimpleName().toString();
        return new DocumentSymbol(simpleName, Utils.elementKind2SymbolKind(el.getKind()), range, range, null, children);
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        Document doc = this.openedDocuments.get(params.getTextDocument().getUri());
        JavaSource js = JavaSource.forDocument((Document)doc);
        if (doc == null || js == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        Map id2Errors = (Map)doc.getProperty("lsp-errors");
        ArrayList<Either> result = new ArrayList<Either>();
        if (id2Errors != null) {
            for (Diagnostic diag : params.getContext().getDiagnostics()) {
                ErrorDescription err = (ErrorDescription)id2Errors.get(diag.getCode().getLeft());
                if (err == null) {
                    this.client.logMessage(new MessageParams(MessageType.Log, "Cannot resolve error, code: " + (String)diag.getCode().getLeft()));
                    continue;
                }
                TreePathHandle[] topLevelHandle = new TreePathHandle[1];
                LazyFixList lfl = err.getFixes();
                if (lfl instanceof CreatorBasedLazyFixList) {
                    try {
                        js.runUserActionTask(cc -> {
                            cc.toPhase(JavaSource.Phase.RESOLVED);
                            ((CreatorBasedLazyFixList)lfl).compute((CompilationInfo)cc, new AtomicBoolean());
                            topLevelHandle[0] = TreePathHandle.create((TreePath)new TreePath(cc.getCompilationUnit()), (CompilationInfo)cc);
                        }, true);
                    }
                    catch (IOException ex) {
                        this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                    }
                }
                List<Fix> fixes = this.sortFixes(lfl.getFixes());
                for (Fix f : fixes) {
                    if (f instanceof IncompleteClassPath.ResolveFix) {
                        CodeAction action = new CodeAction(f.getText());
                        action.setDiagnostics(Collections.singletonList(diag));
                        action.setKind("quickfix");
                        action.setCommand(new Command(f.getText(), "java.build.workspace"));
                        result.add(Either.forRight((Object)action));
                    }
                    if (f instanceof ImportClass.FixImport) {
                        final String text = f.getText();
                        CharSequence sortText = ((ImportClass.FixImport)f).getSortText();
                        final ElementHandle toImport = ((ImportClass.FixImport)f).getToImport();
                        f = new JavaFix(topLevelHandle[0], sortText != null ? sortText.toString() : null){

                            protected String getText() {
                                return text;
                            }

                            protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
                                Element resolved = toImport.resolve((CompilationInfo)ctx.getWorkingCopy());
                                if (resolved == null) {
                                    return;
                                }
                                WorkingCopy copy = ctx.getWorkingCopy();
                                CompilationUnitTree cut = GeneratorUtilities.get((WorkingCopy)copy).addImports(copy.getCompilationUnit(), Collections.singleton(resolved));
                                copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)cut);
                            }
                        }.toEditorFix();
                    }
                    if (f instanceof JavaFixImpl) {
                        try {
                            JavaFix jf = ((JavaFixImpl)f).jf;
                            List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
                                wc.toPhase(JavaSource.Phase.RESOLVED);
                                HashMap resourceContentChanges = new HashMap();
                                JavaFixImpl.Accessor.INSTANCE.process(jf, wc, true, resourceContentChanges, new ArrayList());
                            }));
                            TextDocumentEdit te = new TextDocumentEdit(new VersionedTextDocumentIdentifier(params.getTextDocument().getUri(), Integer.valueOf(-1)), edits);
                            CodeAction action = new CodeAction(f.getText());
                            action.setDiagnostics(Collections.singletonList(diag));
                            action.setKind("quickfix");
                            action.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)te))));
                            result.add(Either.forRight((Object)action));
                        }
                        catch (IOException ex) {
                            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                        }
                    }
                    if (!(f instanceof CreateFixBase)) continue;
                    try {
                        CreateFixBase cf = (CreateFixBase)f;
                        org.netbeans.api.java.source.ModificationResult changes = cf.getModificationResult();
                        ArrayList<Either> documentChanges = new ArrayList<Either>();
                        Set newFiles = changes.getNewFiles();
                        if (newFiles.size() > 1) {
                            throw new IllegalStateException();
                        }
                        String newFilePath = null;
                        for (File newFile : newFiles) {
                            newFilePath = newFile.getPath();
                            documentChanges.add(Either.forRight((Object)new CreateFile(newFilePath)));
                        }
                        block11: for (FileObject fileObject : changes.getModifiedFileObjects()) {
                            List diffs = changes.getDifferences(fileObject);
                            if (diffs == null) continue;
                            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                            for (ModificationResult.Difference diff : diffs) {
                                String newText = diff.getNewText();
                                if (diff.getKind() == ModificationResult.Difference.Kind.CREATE) {
                                    if (newFilePath == null) continue block11;
                                    documentChanges.add(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(newFilePath, Integer.valueOf(-1)), Collections.singletonList(new TextEdit(new Range(Utils.createPosition(fileObject, 0), Utils.createPosition(fileObject, 0)), newText != null ? newText : "")))));
                                    continue block11;
                                }
                                edits.add(new TextEdit(new Range(Utils.createPosition(fileObject, diff.getStartPosition().getOffset()), Utils.createPosition(fileObject, diff.getEndPosition().getOffset())), newText != null ? newText : ""));
                            }
                            documentChanges.add(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(Utils.toUri(fileObject), Integer.valueOf(-1)), edits)));
                        }
                        CodeAction codeAction = new CodeAction(f.getText());
                        codeAction.setKind("quickfix");
                        codeAction.setEdit(new WorkspaceEdit(documentChanges));
                        result.add(Either.forRight((Object)codeAction));
                    }
                    catch (IOException ex) {
                        this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                    }
                }
            }
        }
        try {
            js.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                for (CodeGenerator codeGenerator : Lookup.getDefault().lookupAll(CodeGenerator.class)) {
                    for (CodeAction codeAction : codeGenerator.getCodeActions((CompilationInfo)cc, params)) {
                        result.add(Either.forRight((Object)codeAction));
                    }
                }
                Range range = params.getRange();
                if (!range.getStart().equals((Object)range.getEnd())) {
                    for (ErrorDescription err : IntroduceHint.computeError((CompilationInfo)cc, (int)Utils.getOffset(doc, range.getStart()), (int)Utils.getOffset(doc, range.getEnd()), new EnumMap(IntroduceKind.class), new EnumMap(IntroduceKind.class), (AtomicBoolean)new AtomicBoolean())) {
                        for (Fix fix : err.getFixes().getFixes()) {
                            if (!(fix instanceof IntroduceFixBase)) continue;
                            try {
                                org.netbeans.api.java.source.ModificationResult changes = ((IntroduceFixBase)fix).getModificationResult();
                                if (changes == null) continue;
                                ArrayList<Either> documentChanges = new ArrayList<Either>();
                                Set fos = changes.getModifiedFileObjects();
                                if (fos.size() != 1) continue;
                                FileObject fileObject = (FileObject)fos.iterator().next();
                                List diffs = changes.getDifferences(fileObject);
                                if (diffs != null) {
                                    ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                                    for (ModificationResult.Difference diff : diffs) {
                                        String newText = diff.getNewText();
                                        edits.add(new TextEdit(new Range(Utils.createPosition(fileObject, diff.getStartPosition().getOffset()), Utils.createPosition(fileObject, diff.getEndPosition().getOffset())), newText != null ? newText : ""));
                                    }
                                    documentChanges.add(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(Utils.toUri(fileObject), Integer.valueOf(-1)), edits)));
                                }
                                CodeAction codeAction = new CodeAction(fix.getText());
                                codeAction.setKind("refactor.extract");
                                codeAction.setEdit(new WorkspaceEdit(documentChanges));
                                int renameOffset = ((IntroduceFixBase)fix).getNameOffset(changes);
                                if (renameOffset >= 0) {
                                    codeAction.setCommand(new Command("Rename", "java.rename.element.at", Collections.singletonList(renameOffset)));
                                }
                                result.add(Either.forRight((Object)codeAction));
                            }
                            catch (GeneratorUtils.DuplicateMemberException duplicateMemberException) {}
                        }
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
        }
        return CompletableFuture.completedFuture(result);
    }

    private List<Fix> sortFixes(Collection<Fix> fixes) {
        ArrayList<Fix> result = new ArrayList<Fix>(fixes);
        Collections.sort(result, new FixComparator());
        return result;
    }

    private static CharSequence getSortText(Fix f) {
        if (f instanceof EnhancedFix) {
            return ((EnhancedFix)f).getSortText();
        }
        return DEFAULT_SORT_TEXT;
    }

    private static int compareText(CharSequence text1, CharSequence text2) {
        int len = Math.min(text1.length(), text2.length());
        for (int i = 0; i < len; ++i) {
            char ch2;
            char ch1 = text1.charAt(i);
            if (ch1 == (ch2 = text2.charAt(i))) continue;
            return ch1 - ch2;
        }
        return text1.length() - text2.length();
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(final CodeLensParams params) {
        JavaSource source = this.getSource(params.getTextDocument().getUri());
        if (source == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture<List<? extends CodeLens>> result = new CompletableFuture<List<? extends CodeLens>>();
        try {
            source.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                final ArrayList<CodeLens> lens = new ArrayList<CodeLens>();
                for (ComputeTestMethods.Factory methodsFactory : Lookup.getDefault().lookupAll(ComputeTestMethods.Factory.class)) {
                    List methods = methodsFactory.create().computeTestMethods((CompilationInfo)cc);
                    if (methods == null) continue;
                    for (TestMethodController.TestMethod method : methods) {
                        Range range = new Range(Utils.createPosition(cc.getCompilationUnit(), method.start().getOffset()), Utils.createPosition(cc.getCompilationUnit(), method.end().getOffset()));
                        List<Object> arguments = Arrays.asList(method.method().getFile().toURI(), method.method().getMethodName());
                        lens.add(new CodeLens(range, new Command("Run test", "java.run.codelens", arguments), null));
                        lens.add(new CodeLens(range, new Command("Debug test", "java.debug.codelens", arguments), null));
                    }
                }
                new TreePathScanner<Void, Void>(){

                    @Override
                    public Void visitMethod(MethodTree tree, Void p) {
                        Element el = cc.getTrees().getElement(this.getCurrentPath());
                        if (el != null && el.getKind() == ElementKind.METHOD && SourceUtils.isMainMethod((ExecutableElement)((ExecutableElement)el))) {
                            Range range = Utils.treeRange((CompilationInfo)cc, tree);
                            List<String> arguments = Collections.singletonList(params.getTextDocument().getUri());
                            lens.add(new CodeLens(range, new Command("Run main", "java.run.codelens", arguments), null));
                            lens.add(new CodeLens(range, new Command("Debug main", "java.debug.codelens", arguments), null));
                        }
                        return null;
                    }
                }.scan(cc.getCompilationUnit(), null);
                result.complete(lens);
            }, true);
        }
        catch (IOException ex) {
            result.completeExceptionally(ex);
        }
        return result;
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CompletableFuture<Either<Range, PrepareRenameResult>> prepareRename(PrepareRenameParams params) {
        JavaSource source = this.getSource(params.getTextDocument().getUri());
        if (source == null) {
            return CompletableFuture.completedFuture(Either.forLeft(null));
        }
        CompletableFuture<Either<Range, PrepareRenameResult>> result = new CompletableFuture<Either<Range, PrepareRenameResult>>();
        try {
            source.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = cc.getSnapshot().getSource().getDocument(true);
                int pos = Utils.getOffset(doc, params.getPosition());
                TreePath path = cc.getTreeUtilities().pathFor(pos);
                RenameRefactoring ref = new RenameRefactoring(Lookups.singleton((Object)TreePathHandle.create((TreePath)path, (CompilationInfo)cc)));
                ref.setNewName("any");
                boolean hasFatalProblem = false;
                for (Problem p = ref.fastCheckParameters(); p != null; p = p.getNext()) {
                    hasFatalProblem |= p.isFatal();
                }
                if (hasFatalProblem) {
                    result.complete(null);
                } else {
                    TokenSequence ts = cc.getTokenHierarchy().tokenSequence(JavaTokenId.language());
                    int d = ts.move(pos);
                    if (ts.moveNext()) {
                        if (d == 0 && ts.token().id() != JavaTokenId.IDENTIFIER) {
                            ts.movePrevious();
                        }
                        Range r = new Range(Utils.createPosition(cc.getCompilationUnit(), ts.offset()), Utils.createPosition(cc.getCompilationUnit(), ts.offset() + ts.token().length()));
                        result.complete(Either.forRight((Object)new PrepareRenameResult(r, ts.token().text().toString())));
                    } else {
                        result.complete(null);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            result.completeExceptionally(ex);
        }
        return result;
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        final AtomicBoolean cancel = new AtomicBoolean();
        final Runnable[] cancelCallback = new Runnable[1];
        CompletableFuture<WorkspaceEdit> result = new CompletableFuture<WorkspaceEdit>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                cancel.set(mayInterruptIfRunning);
                if (cancelCallback[0] != null) {
                    cancelCallback[0].run();
                }
                return super.cancel(mayInterruptIfRunning);
            }
        };
        WORKER.post(() -> {
            JavaSource js = this.getSource(params.getTextDocument().getUri());
            try {
                RenameRefactoring[] refactoring = new RenameRefactoring[1];
                js.runUserActionTask(cc -> {
                    ElementHandle handle;
                    FileObject f;
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    if (cancel.get()) {
                        return;
                    }
                    Document doc = cc.getSnapshot().getSource().getDocument(true);
                    TreePath path = cc.getTreeUtilities().pathFor(Utils.getOffset(doc, params.getPosition()));
                    ArrayList<Object> lookupContent = new ArrayList<Object>();
                    lookupContent.add(TreePathHandle.create((TreePath)path, (CompilationInfo)cc));
                    Element selected = cc.getTrees().getElement(path);
                    if (selected instanceof TypeElement && !((TypeElement)selected).getNestingKind().isNested() && (f = SourceUtils.getFile((ElementHandle)(handle = ElementHandle.create((Element)((TypeElement)selected))), (ClasspathInfo)cc.getClasspathInfo())) != null && selected.getSimpleName().toString().equals(f.getName())) {
                        lookupContent.add(f);
                    }
                    refactoring[0] = new RenameRefactoring(Lookups.fixed((Object[])lookupContent.toArray(new Object[0])));
                    refactoring[0].setNewName(params.getNewName());
                    refactoring[0].setSearchInComments(true);
                }, true);
                if (cancel.get()) {
                    return;
                }
                cancelCallback[0] = () -> refactoring[0].cancelRequest();
                RefactoringSession session = RefactoringSession.create((String)"Rename");
                Problem p = refactoring[0].checkParameters();
                if (cancel.get()) {
                    return;
                }
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                p = refactoring[0].preCheck();
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                if (cancel.get()) {
                    return;
                }
                p = refactoring[0].prepare(session);
                if (p != null && p.isFatal()) {
                    ErrorUtilities.completeExceptionally(result, p.getMessage(), ResponseErrorCode.UnknownErrorCode);
                    return;
                }
                ArrayList<Either> resultChanges = new ArrayList<Either>();
                List transactions = APIAccessor.DEFAULT.getCommits(session);
                ArrayList<org.netbeans.api.java.source.ModificationResult> results = new ArrayList<org.netbeans.api.java.source.ModificationResult>();
                for (Transaction t : transactions) {
                    if (t instanceof RefactoringCommit) {
                        RefactoringCommit c = (RefactoringCommit)t;
                        for (ModificationResult refResult : SPIAccessor.DEFAULT.getTransactions(c)) {
                            if (refResult instanceof JavaModificationResult) {
                                results.add(((JavaModificationResult)refResult).delegate);
                                continue;
                            }
                            throw new IllegalStateException(refResult.getClass().toString());
                        }
                        continue;
                    }
                    throw new IllegalStateException(t.getClass().toString());
                }
                for (org.netbeans.api.java.source.ModificationResult mr : results) {
                    for (FileObject modified : mr.getModifiedFileObjects()) {
                        resultChanges.add(Either.forLeft((Object)new TextDocumentEdit(new VersionedTextDocumentIdentifier(params.getTextDocument().getUri(), Integer.valueOf(-1)), TextDocumentServiceImpl.fileModifications(mr, modified, null))));
                    }
                }
                List fileChanges = APIAccessor.DEFAULT.getFileChanges(session);
                for (RefactoringElementImplementation rei : fileChanges) {
                    if (rei instanceof FileRenamePlugin.RenameFile) {
                        String oldURI = params.getTextDocument().getUri();
                        int dot = oldURI.lastIndexOf(46);
                        int slash = oldURI.lastIndexOf(47);
                        String newURI = oldURI.substring(0, slash + 1) + params.getNewName() + oldURI.substring(dot);
                        RenameFile op = new RenameFile(oldURI, newURI);
                        resultChanges.add(Either.forRight((Object)op));
                        continue;
                    }
                    throw new IllegalStateException(rei.getClass().toString());
                }
                for (RefactoringElement refactoringElement : session.getRefactoringElements()) {
                }
                session.finished();
                result.complete(new WorkspaceEdit(resultChanges));
            }
            catch (Throwable ex) {
                result.completeExceptionally(ex);
            }
        });
        return result;
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        JavaSource source = this.getSource(params.getTextDocument().getUri());
        if (source == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        CompletableFuture<List<FoldingRange>> result = new CompletableFuture<List<FoldingRange>>();
        try {
            source.runUserActionTask(cc -> {
                cc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = cc.getSnapshot().getSource().getDocument(true);
                JavaElementFoldVisitor v = new JavaElementFoldVisitor((CompilationInfo)cc, cc.getCompilationUnit(), cc.getTrees().getSourcePositions(), doc, (JavaElementFoldVisitor.FoldCreator)new JavaElementFoldVisitor.FoldCreator<FoldingRange>(){

                    public FoldingRange createImportsFold(int start, int end) {
                        return this.createFold(start, end, "imports");
                    }

                    public FoldingRange createInnerClassFold(int start, int end) {
                        return this.createFold(start, end, "region");
                    }

                    public FoldingRange createCodeBlockFold(int start, int end) {
                        return this.createFold(start, end, "region");
                    }

                    public FoldingRange createJavadocFold(int start, int end) {
                        return this.createFold(start, end, "comment");
                    }

                    public FoldingRange createInitialCommentFold(int start, int end) {
                        return this.createFold(start, end, "comment");
                    }

                    private FoldingRange createFold(int start, int end, String kind) {
                        Position startPos = Utils.createPosition(cc.getCompilationUnit(), start);
                        Position endPos = Utils.createPosition(cc.getCompilationUnit(), end);
                        FoldingRange range = new FoldingRange(startPos.getLine(), endPos.getLine());
                        range.setStartCharacter(Integer.valueOf(startPos.getCharacter()));
                        range.setEndCharacter(Integer.valueOf(endPos.getCharacter()));
                        range.setKind(kind);
                        return range;
                    }
                });
                v.checkInitialFold();
                v.scan((Tree)cc.getCompilationUnit(), null);
                result.complete(v.getFolds());
            }, true);
        }
        catch (IOException ex) {
            result.completeExceptionally(ex);
        }
        return result;
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        try {
            FileObject file = Utils.fromUri(params.getTextDocument().getUri());
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            StyledDocument doc = ec.getDocument();
            String text = params.getTextDocument().getText();
            try {
                if (doc == null) {
                    doc = ec.openDocument();
                }
                if (!text.contentEquals(doc.getText(0, doc.getLength()))) {
                    doc.remove(0, doc.getLength());
                    doc.insertString(0, text, null);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
            }
            this.openedDocuments.put(params.getTextDocument().getUri(), doc);
            this.runDiagnoticTasks(params.getTextDocument().getUri());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            TextDocumentServiceImpl.reportNotificationDone("didOpen", params);
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        Document doc = this.openedDocuments.get(params.getTextDocument().getUri());
        NbDocument.runAtomic((StyledDocument)((StyledDocument)doc), () -> {
            for (TextDocumentContentChangeEvent change : params.getContentChanges()) {
                try {
                    int start = Utils.getOffset(doc, change.getRange().getStart());
                    int end = Utils.getOffset(doc, change.getRange().getEnd());
                    doc.remove(start, end - start);
                    doc.insertString(start, change.getText(), null);
                }
                catch (BadLocationException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        });
        this.runDiagnoticTasks(params.getTextDocument().getUri());
        TextDocumentServiceImpl.reportNotificationDone("didChange", params);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        try {
            FileObject file = Utils.fromUri(params.getTextDocument().getUri());
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            ec.close();
            this.openedDocuments.remove(params.getTextDocument().getUri());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            TextDocumentServiceImpl.reportNotificationDone("didClose", params);
        }
    }

    public void didSave(DidSaveTextDocumentParams arg0) {
    }

    private void runDiagnoticTasks(String uri) {
        this.diagnosticTasks.computeIfAbsent(uri, u -> BACKGROUND_TASKS.create(() -> {
            this.computeDiags((String)u, (info, doc) -> {
                ErrorHintsProvider ehp = new ErrorHintsProvider();
                return ehp.computeErrors(info, doc, "text/x-java");
            }, "errors", false);
            BACKGROUND_TASKS.create(() -> this.computeDiags((String)u, (info, doc) -> {
                Set disabled = Utilities.disableErrors((FileObject)info.getFileObject());
                if (disabled.size() == Severity.values().length) {
                    return Collections.emptyList();
                }
                return new HintsInvoker(HintsSettings.getGlobalSettings(), new AtomicBoolean()).computeHints(info).stream().filter(ed -> !disabled.contains(ed.getSeverity())).collect(Collectors.toList());
            }, "hints", true)).schedule(500);
        })).schedule(500);
    }

    private void computeDiags(final String uri, final ProduceErrors produceErrors, final String keyPrefix, boolean update) {
        try {
            FileObject file = Utils.fromUri(uri);
            EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
            final StyledDocument doc = ec.openDocument();
            ParserManager.parse(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator it) throws Exception {
                    CompilationController cc = CompilationController.get((Parser.Result)it.getParserResult());
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    HashMap<String, ErrorDescription> id2Errors = new HashMap<String, ErrorDescription>();
                    ArrayList<Diagnostic> diags = new ArrayList<Diagnostic>();
                    int idx = 0;
                    List<Object> errors = produceErrors.computeErrors((CompilationInfo)cc, doc);
                    if (errors == null) {
                        errors = Collections.emptyList();
                    }
                    for (ErrorDescription err : errors) {
                        Diagnostic diag = new Diagnostic(new Range(Utils.createPosition(cc.getCompilationUnit(), err.getRange().getBegin().getOffset()), Utils.createPosition(cc.getCompilationUnit(), err.getRange().getEnd().getOffset())), err.getDescription());
                        switch (err.getSeverity()) {
                            case ERROR: {
                                diag.setSeverity(DiagnosticSeverity.Error);
                                break;
                            }
                            case VERIFIER: 
                            case WARNING: {
                                diag.setSeverity(DiagnosticSeverity.Warning);
                                break;
                            }
                            case HINT: {
                                diag.setSeverity(DiagnosticSeverity.Hint);
                                break;
                            }
                            default: {
                                diag.setSeverity(DiagnosticSeverity.Information);
                            }
                        }
                        String id = keyPrefix + ":" + idx++ + "-" + err.getId();
                        diag.setCode(id);
                        id2Errors.put(id, err);
                        diags.add(diag);
                    }
                    doc.putProperty("lsp-errors-" + keyPrefix, id2Errors);
                    doc.putProperty("lsp-errors-diags-" + keyPrefix, diags);
                    HashMap mergedId2Errors = new HashMap();
                    ArrayList mergedDiags = new ArrayList();
                    for (String k : ERROR_KEYS) {
                        List prevDiags;
                        Map prevErrors = (Map)doc.getProperty("lsp-errors-" + k);
                        if (prevErrors != null) {
                            mergedId2Errors.putAll(prevErrors);
                        }
                        if ((prevDiags = (List)doc.getProperty("lsp-errors-diags-" + k)) == null) continue;
                        mergedDiags.addAll(prevDiags);
                    }
                    doc.putProperty("lsp-errors", mergedId2Errors);
                    doc.putProperty("lsp-errors-diags", mergedDiags);
                    TextDocumentServiceImpl.this.client.publishDiagnostics(new PublishDiagnosticsParams(uri, mergedDiags));
                }
            });
        }
        catch (IOException | ParseException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private JavaSource getSource(String fileUri) {
        Document doc = this.openedDocuments.get(fileUri);
        if (doc == null) {
            try {
                FileObject file = Utils.fromUri(fileUri);
                return JavaSource.forFileObject((FileObject)file);
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return JavaSource.forDocument((Document)doc);
    }

    public static List<TextEdit> modify2TextEdits(JavaSource js, Task<WorkingCopy> task) throws IOException {
        FileObject[] file = new FileObject[1];
        LineMap[] lm = new LineMap[1];
        org.netbeans.api.java.source.ModificationResult changes = js.runModificationTask(wc -> {
            task.run(wc);
            file[0] = wc.getFileObject();
            lm[0] = wc.getCompilationUnit().getLineMap();
        });
        return TextDocumentServiceImpl.fileModifications(changes, file[0], lm[0]);
    }

    private static List<TextEdit> fileModifications(org.netbeans.api.java.source.ModificationResult changes, FileObject file, LineMap lm) {
        List diffs = changes.getDifferences(file);
        if (diffs == null) {
            return Collections.emptyList();
        }
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        IntFunction<Position> offset2Position = lm != null ? pos -> Utils.createPosition(lm, pos) : pos -> Utils.createPosition(file, pos);
        for (ModificationResult.Difference diff : diffs) {
            String newText = diff.getNewText();
            edits.add(new TextEdit(new Range(offset2Position.apply(diff.getStartPosition().getOffset()), offset2Position.apply(diff.getEndPosition().getOffset())), newText != null ? newText : ""));
        }
        return edits;
    }

    private static void reportNotificationDone(String s, Object parameter) {
        if (HOOK_NOTIFICATION != null) {
            HOOK_NOTIFICATION.accept(s, parameter);
        }
    }

    private static interface ProduceErrors {
        public List<ErrorDescription> computeErrors(CompilationInfo var1, Document var2) throws IOException;
    }

    private static final class FixComparator
    implements Comparator<Fix> {
        private FixComparator() {
        }

        @Override
        public int compare(Fix o1, Fix o2) {
            return TextDocumentServiceImpl.compareText(TextDocumentServiceImpl.getSortText(o1), TextDocumentServiceImpl.getSortText(o2));
        }
    }

    private static class ItemFactoryImpl
    implements JavaCompletionTask.ItemFactory<CompletionItem> {
        private static final int DEPRECATED = 10;
        private final LanguageClient client;
        private final String uri;
        private final int offset;
        private final CompilationInfo info;
        private final Scope scope;
        private static final Set<String> SUPPORTED_ELEMENT_KINDS = new HashSet<String>(Arrays.asList("PACKAGE", "CLASS", "INTERFACE", "ENUM", "ANNOTATION_TYPE", "METHOD", "CONSTRUCTOR", "INSTANCE_INIT", "STATIC_INIT", "FIELD", "ENUM_CONSTANT", "TYPE_PARAMETER", "MODULE"));
        private static final Object KEY_IMPORT_TEXT_EDITS = new Object();

        public ItemFactoryImpl(LanguageClient client, CompilationInfo info, String uri, int offset) {
            this.client = client;
            this.uri = uri;
            this.offset = offset;
            this.info = info;
            this.scope = info.getTrees().getScope(info.getTreeUtilities().pathFor(offset));
        }

        private void setCompletionData(CompletionItem ci, Element el) {
            if (SUPPORTED_ELEMENT_KINDS.contains(el.getKind().name())) {
                this.setCompletionData(ci, ElementHandle.create((Element)el));
            }
        }

        private void setCompletionData(CompletionItem ci, ElementHandle handle) {
            ci.setData((Object)new CompletionData(this.uri, this.offset, handle.getKind().name(), SourceUtils.getJVMSignature((ElementHandle)handle)));
        }

        public CompletionItem createKeywordItem(String kwd, String postfix, int substitutionOffset, boolean smartType) {
            CompletionItem item = new CompletionItem(kwd);
            item.setKind(CompletionItemKind.Keyword);
            item.setSortText(String.format("%4d%s", smartType ? 670 : 1670, kwd));
            return item;
        }

        public CompletionItem createPackageItem(String pkgFQN, int substitutionOffset, boolean inPackageStatement) {
            String simpleName = pkgFQN.substring(pkgFQN.lastIndexOf(46) + 1);
            CompletionItem item = new CompletionItem(simpleName);
            item.setKind(CompletionItemKind.Folder);
            item.setSortText(String.format("%4d%s#%s", 1900, simpleName, pkgFQN));
            return item;
        }

        public CompletionItem createTypeItem(CompilationInfo info, TypeElement elem, DeclaredType type, int substitutionOffset, ReferencesCount referencesCount, boolean isDeprecated, boolean insideNew, boolean addTypeVars, boolean addSimpleName, boolean smartType, boolean autoImportEnclosingType) {
            String pkgName;
            CompletionItem item = new CompletionItem(elem.getSimpleName().toString());
            item.setKind(ItemFactoryImpl.elementKind2CompletionItemKind(elem.getKind()));
            String name = elem.getQualifiedName().toString();
            int idx = name.lastIndexOf(46);
            String string = pkgName = idx < 0 ? "" : name.substring(0, idx);
            if (!pkgName.isEmpty()) {
                item.setDetail(name.substring(0, idx));
            }
            item.setSortText(String.format("%4d%s#%2d#%s", smartType ? 800 : 1800, elem.getSimpleName().toString(), org.netbeans.modules.editor.java.Utilities.getImportanceLevel((String)name), pkgName));
            this.setCompletionData(item, elem);
            return item;
        }

        public CompletionItem createTypeItem(ElementHandle<TypeElement> handle, EnumSet<ElementKind> kinds, int substitutionOffset, ReferencesCount referencesCount, Source source, boolean insideNew, boolean addTypeVars, boolean afterExtends) {
            TypeElement te = (TypeElement)handle.resolve(this.info);
            if (te != null && this.info.getTrees().isAccessible(this.scope, te)) {
                String pkgName;
                CompletionItem item = new CompletionItem(te.getSimpleName().toString());
                String name = handle.getQualifiedName();
                int idx = name.lastIndexOf(46);
                String string = pkgName = idx < 0 ? "" : name.substring(0, idx);
                if (!pkgName.isEmpty()) {
                    item.setDetail(pkgName);
                }
                item.setKind(ItemFactoryImpl.elementKind2CompletionItemKind(handle.getKind()));
                item.setSortText(String.format("%4d%s#%2d#%s", 1800, te.getSimpleName().toString(), org.netbeans.modules.editor.java.Utilities.getImportanceLevel((String)name), pkgName));
                this.setCompletionData(item, handle);
                return item;
            }
            return null;
        }

        public CompletionItem createArrayItem(CompilationInfo info, ArrayType type, int substitutionOffset, ReferencesCount referencesCount, Elements elements) {
            return null;
        }

        public CompletionItem createTypeParameterItem(TypeParameterElement elem, int substitutionOffset) {
            CompletionItem item = new CompletionItem(elem.getSimpleName().toString());
            item.setKind(ItemFactoryImpl.elementKind2CompletionItemKind(elem.getKind()));
            item.setSortText(String.format("%4d%s", 1700, elem.getSimpleName().toString()));
            return item;
        }

        public CompletionItem createVariableItem(CompilationInfo info, VariableElement elem, TypeMirror type, int substitutionOffset, ReferencesCount referencesCount, boolean isInherited, boolean isDeprecated, boolean smartType, int assignToVarOffset) {
            CompletionItem item = new CompletionItem(elem.getSimpleName().toString());
            item.setKind(ItemFactoryImpl.elementKind2CompletionItemKind(elem.getKind()));
            int priority = elem.getKind() == ElementKind.ENUM_CONSTANT || elem.getKind() == ElementKind.FIELD ? (smartType ? 300 : 1300) : (smartType ? 200 : 1200);
            item.setSortText(String.format("%4d%s", priority, elem.getSimpleName().toString()));
            this.setCompletionData(item, elem);
            return item;
        }

        public CompletionItem createVariableItem(CompilationInfo info, String varName, int substitutionOffset, boolean newVarName, boolean smartType) {
            CompletionItem item = new CompletionItem(varName);
            item.setKind(CompletionItemKind.Variable);
            item.setSortText(String.format("%4d%s", smartType ? 200 : 1200, varName));
            return item;
        }

        public CompletionItem createExecutableItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, ReferencesCount referencesCount, boolean isInherited, boolean isDeprecated, boolean inImport, boolean addSemicolon, boolean smartType, int assignToVarOffset, boolean memberRef) {
            TypeMirror tm;
            Iterator<? extends VariableElement> it = elem.getParameters().iterator();
            Iterator<? extends TypeMirror> tIt = type.getParameterTypes().iterator();
            StringBuilder label = new StringBuilder();
            String sep = "";
            label.append(elem.getSimpleName().toString());
            label.append("(");
            StringBuilder sortParams = new StringBuilder();
            sortParams.append('(');
            int cnt = 0;
            while (it.hasNext() && tIt.hasNext() && (tm = tIt.next()) != null) {
                label.append(sep);
                String paramTypeName = org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)tm, (boolean)false, (elem.isVarArgs() && !tIt.hasNext() ? 1 : 0) != 0).toString();
                label.append(paramTypeName);
                label.append(' ');
                label.append(it.next().getSimpleName().toString());
                sep = ", ";
                sortParams.append(paramTypeName);
                if (tIt.hasNext()) {
                    sortParams.append(',');
                }
                ++cnt;
            }
            label.append(") : ");
            sortParams.append(')');
            TypeMirror retType = type.getReturnType();
            label.append(org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)retType, (boolean)false).toString());
            CompletionItem item = new CompletionItem(label.toString());
            item.setKind(ItemFactoryImpl.elementKind2CompletionItemKind(elem.getKind()));
            StringBuilder insertText = new StringBuilder();
            insertText.append(elem.getSimpleName());
            insertText.append("(");
            if (elem.getParameters().isEmpty()) {
                insertText.append(")");
            }
            item.setInsertText(insertText.toString());
            item.setInsertTextFormat(InsertTextFormat.PlainText);
            int priority = elem.getKind() == ElementKind.METHOD ? (smartType ? 500 : 1500) : (smartType ? 650 : 1650);
            item.setSortText(String.format("%4d%s#%2d%s", priority, elem.getSimpleName().toString(), cnt, sortParams));
            this.setCompletionData(item, elem);
            return item;
        }

        public CompletionItem createThisOrSuperConstructorItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated, String name) {
            CompletionItem item = this.createExecutableItem(info, elem, type, substitutionOffset, null, false, isDeprecated, false, false, false, -1, false);
            item.setLabel(name != null ? name : elem.getEnclosingElement().getSimpleName().toString());
            StringBuilder insertText = new StringBuilder();
            insertText.append(item.getLabel());
            insertText.append("(");
            if (elem.getParameters().isEmpty()) {
                insertText.append(")");
            }
            item.setInsertText(insertText.toString());
            item.setKind(CompletionItemKind.Constructor);
            item.setSortText(String.format("%4d%s", name != null ? 1550 : 1650, item.getSortText().substring(4)));
            this.setCompletionData(item, elem);
            return item;
        }

        public CompletionItem createOverrideMethodItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean implement) {
            CompletionItem item = this.createExecutableItem(info, elem, type, substitutionOffset, null, false, false, false, false, false, -1, false);
            item.setLabel(String.format("%s - %s", item.getLabel(), implement ? "implement" : "override"));
            item.setInsertText(null);
            item.setKind(ItemFactoryImpl.elementKind2CompletionItemKind(elem.getKind()));
            try {
                List<TextEdit> textEdits = TextDocumentServiceImpl.modify2TextEdits(JavaSource.forFileObject((FileObject)info.getFileObject()), (Task<WorkingCopy>)((Task)wc -> {
                    wc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TreePath tp = wc.getTreeUtilities().pathFor(this.offset);
                    if (implement) {
                        GeneratorUtils.generateAbstractMethodImplementation((WorkingCopy)wc, (TreePath)tp, (ExecutableElement)elem, (int)this.offset);
                    } else {
                        GeneratorUtils.generateMethodOverride((WorkingCopy)wc, (TreePath)tp, (ExecutableElement)elem, (int)this.offset);
                    }
                }));
                if (!textEdits.isEmpty()) {
                    item.setTextEdit(textEdits.get(0));
                }
            }
            catch (IOException ex) {
                this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
            }
            this.setCompletionData(item, elem);
            return item;
        }

        public CompletionItem createGetterSetterMethodItem(CompilationInfo info, VariableElement elem, TypeMirror type, int substitutionOffset, String name, boolean setter) {
            return null;
        }

        public CompletionItem createDefaultConstructorItem(TypeElement elem, int substitutionOffset, boolean smartType) {
            return null;
        }

        public CompletionItem createParametersItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated, int activeParamIndex, String name) {
            return null;
        }

        public CompletionItem createAnnotationItem(CompilationInfo info, TypeElement elem, DeclaredType type, int substitutionOffset, ReferencesCount referencesCount, boolean isDeprecated) {
            return null;
        }

        public CompletionItem createAttributeItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int substitutionOffset, boolean isDeprecated) {
            CompletionItem item = new CompletionItem(elem.getSimpleName().toString());
            item.setKind(CompletionItemKind.Property);
            StringBuilder insertText = new StringBuilder();
            insertText.append(elem.getSimpleName());
            insertText.append("=");
            item.setInsertText(insertText.toString());
            item.setInsertTextFormat(InsertTextFormat.PlainText);
            int priority = isDeprecated ? 110 : 100;
            item.setSortText(String.format("%4d%s", priority, elem.getSimpleName().toString()));
            this.setCompletionData(item, elem);
            return item;
        }

        public CompletionItem createAttributeValueItem(CompilationInfo info, String value, String documentation, TypeElement element, int substitutionOffset, ReferencesCount referencesCount) {
            CompletionItem item = new CompletionItem(value);
            item.setKind(CompletionItemKind.Text);
            item.setSortText(value);
            item.setDocumentation(documentation);
            return item;
        }

        public CompletionItem createStaticMemberItem(CompilationInfo info, DeclaredType type, Element memberElem, TypeMirror memberType, boolean multipleVersions, int substitutionOffset, boolean isDeprecated, boolean addSemicolon) {
            HashMap<Element, List> imports = (HashMap<Element, List>)info.getCachedValue(KEY_IMPORT_TEXT_EDITS);
            if (imports == null) {
                imports = new HashMap<Element, List>();
                info.putCachedValue(KEY_IMPORT_TEXT_EDITS, imports, CompilationInfo.CacheClearPolicy.ON_TASK_END);
            }
            List currentClassImport = imports.computeIfAbsent(type.asElement(), toImport -> {
                try {
                    return TextDocumentServiceImpl.modify2TextEdits(JavaSource.forFileObject((FileObject)info.getFileObject()), (Task<WorkingCopy>)((Task)wc -> {
                        wc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        wc.rewrite((Tree)info.getCompilationUnit(), (Tree)GeneratorUtilities.get((WorkingCopy)wc).addImports(wc.getCompilationUnit(), new HashSet<Element>(Arrays.asList(toImport))));
                    }));
                }
                catch (IOException ex) {
                    this.client.logMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                    return Collections.emptyList();
                }
            });
            String label = type.asElement().getSimpleName() + "." + memberElem.getSimpleName();
            CompletionItem item = new CompletionItem(label);
            item.setKind(ItemFactoryImpl.elementKind2CompletionItemKind(memberElem.getKind()));
            item.setInsertText(label);
            item.setInsertTextFormat(InsertTextFormat.PlainText);
            item.setAdditionalTextEdits(currentClassImport);
            String sortText = memberElem.getSimpleName().toString();
            if (memberElem.getKind().isField()) {
                sortText = sortText + String.format("#%s", org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)type, (boolean)false));
            } else {
                TypeMirror tm;
                StringBuilder sortParams = new StringBuilder();
                sortParams.append('(');
                int cnt = 0;
                Iterator<? extends TypeMirror> tIt = ((ExecutableType)memberType).getParameterTypes().iterator();
                while (tIt.hasNext() && (tm = tIt.next()) != null) {
                    sortParams.append(org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)tm, (boolean)false, (((ExecutableElement)memberElem).isVarArgs() && !tIt.hasNext() ? 1 : 0) != 0).toString());
                    if (tIt.hasNext()) {
                        sortParams.append(',');
                    }
                    ++cnt;
                }
                sortParams.append(')');
                sortText = sortText + String.format("#%2d#%s#s", cnt, sortParams.toString(), org.netbeans.modules.editor.java.Utilities.getTypeName((CompilationInfo)info, (TypeMirror)type, (boolean)false));
            }
            item.setSortText(String.format("%4d%s", memberElem.getKind().isField() ? 720 : 750, sortText));
            this.setCompletionData(item, memberElem);
            return item;
        }

        public CompletionItem createStaticMemberItem(ElementHandle<TypeElement> handle, String name, int substitutionOffset, boolean addSemicolon, ReferencesCount referencesCount, Source source) {
            return null;
        }

        public CompletionItem createChainedMembersItem(CompilationInfo info, List<? extends Element> chainedElems, List<? extends TypeMirror> chainedTypes, int substitutionOffset, boolean isDeprecated, boolean addSemicolon) {
            return null;
        }

        public CompletionItem createInitializeAllConstructorItem(CompilationInfo info, boolean isDefault, Iterable<? extends VariableElement> fields, ExecutableElement superConstructor, TypeElement parent, int substitutionOffset) {
            return null;
        }

        private static CompletionItemKind elementKind2CompletionItemKind(ElementKind kind) {
            switch (kind) {
                case PACKAGE: {
                    return CompletionItemKind.Folder;
                }
                case ENUM: {
                    return CompletionItemKind.Enum;
                }
                case CLASS: {
                    return CompletionItemKind.Class;
                }
                case ANNOTATION_TYPE: {
                    return CompletionItemKind.Interface;
                }
                case INTERFACE: {
                    return CompletionItemKind.Interface;
                }
                case ENUM_CONSTANT: {
                    return CompletionItemKind.EnumMember;
                }
                case FIELD: {
                    return CompletionItemKind.Field;
                }
                case PARAMETER: {
                    return CompletionItemKind.Variable;
                }
                case LOCAL_VARIABLE: {
                    return CompletionItemKind.Variable;
                }
                case EXCEPTION_PARAMETER: {
                    return CompletionItemKind.Variable;
                }
                case METHOD: {
                    return CompletionItemKind.Method;
                }
                case CONSTRUCTOR: {
                    return CompletionItemKind.Constructor;
                }
                case TYPE_PARAMETER: {
                    return CompletionItemKind.TypeParameter;
                }
                case RESOURCE_VARIABLE: {
                    return CompletionItemKind.Variable;
                }
                case MODULE: {
                    return CompletionItemKind.Module;
                }
            }
            return CompletionItemKind.Text;
        }
    }

    public static final class CompletionData {
        public String uri;
        public int offset;
        public String kind;
        public String[] elementHandle;

        public CompletionData() {
        }

        public CompletionData(String uri, int offset, String kind, String[] elementHandle) {
            this.uri = uri;
            this.offset = offset;
            this.kind = kind;
            this.elementHandle = elementHandle;
        }

        public String toString() {
            return "CompletionData{uri=" + this.uri + ", kind=" + this.kind + ", elementHandle=" + this.elementHandle + '}';
        }
    }

    public static final class RefreshDocument
    implements ActiveDocumentProvider.IndexingAware {
        private final Set<TextDocumentServiceImpl> delegates = new WeakSet();

        public synchronized void register(TextDocumentServiceImpl delegate) {
            this.delegates.add(delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void indexingComplete(Set<URL> indexedRoots) {
            TextDocumentServiceImpl[] textDocumentServiceImplArray = this;
            synchronized (this) {
                TextDocumentServiceImpl[] delegates = this.delegates.toArray(new TextDocumentServiceImpl[this.delegates.size()]);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                for (TextDocumentServiceImpl delegate : delegates) {
                    delegate.reRunDiagnostics();
                }
                return;
            }
        }
    }
}

