/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.server.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.server.parser.TargetConfigReader;
import org.netbeans.modules.glassfish.tooling.server.parser.TreeParser;
import org.netbeans.modules.glassfish.tooling.server.parser.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JmxConnectorReader
extends TargetConfigReader
implements XMLReader {
    private static final Logger LOGGER = new Logger(JmxConnectorReader.class);
    public static final String DEFAULT_PATH = "/domain/configs/config/admin-service/jmx-connector";
    private String path;
    private String result;

    public JmxConnectorReader(String path, String targetConfigName) {
        super(targetConfigName);
        this.path = path;
    }

    public JmxConnectorReader(String targetConfigName) {
        this(DEFAULT_PATH, targetConfigName);
    }

    @Override
    public void readAttributes(String qname, Attributes attributes) throws SAXException {
        String METHOD = "getServerConfig";
        if (readData) {
            String jmxAttr = attributes.getValue("port");
            try {
                int port = Integer.parseInt(jmxAttr);
                this.result = "" + port;
                LOGGER.log(Level.INFO, "getServerConfig", "port", this.result);
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.SEVERE, "getServerConfig", "error", ex);
            }
        }
    }

    @Override
    public List<TreeParser.Path> getPathsToListen() {
        LinkedList<TreeParser.Path> paths = new LinkedList<TreeParser.Path>();
        paths.add(new TreeParser.Path(this.path, this));
        paths.add(new TreeParser.Path("/domain/configs/config", new TargetConfigReader.TargetConfigMarker(this)));
        return paths;
    }

    public String getResult() {
        return this.result;
    }
}

