/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionName;
import org.netbeans.modules.php.editor.parser.astnodes.GroupUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.NullableType;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.UnaryOperation;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.Variadic;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.project.api.PhpLanguageProperties;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Parameters;

public final class CodeUtils {
    public static final String FUNCTION_TYPE_PREFIX = "@fn:";
    public static final String METHOD_TYPE_PREFIX = "@mtd:";
    public static final String STATIC_METHOD_TYPE_PREFIX = "@static.mtd:";
    public static final String NULLABLE_TYPE_PREFIX = "?";
    private static final Logger LOGGER = Logger.getLogger(CodeUtils.class.getName());

    private CodeUtils() {
    }

    @CheckForNull
    public static FileObject getFileObject(Document doc) {
        Object sdp = doc.getProperty("stream");
        if (sdp instanceof FileObject) {
            return (FileObject)sdp;
        }
        if (sdp instanceof DataObject) {
            return ((DataObject)sdp).getPrimaryFile();
        }
        return null;
    }

    public static UseScope.Type mapType(UseStatement.Type type) {
        UseScope.Type newType = null;
        switch (type) {
            case CONST: {
                newType = UseScope.Type.CONST;
                break;
            }
            case FUNCTION: {
                newType = UseScope.Type.FUNCTION;
                break;
            }
            case TYPE: {
                newType = UseScope.Type.TYPE;
                break;
            }
            default: {
                assert (false) : "Unknown type: " + (Object)((Object)type);
                break;
            }
        }
        return newType;
    }

    public static NamespaceName compoundName(GroupUseStatementPart groupUseStatementPart, SingleUseStatementPart singleUseStatementPart, boolean baseOffsets) {
        int end;
        int start;
        assert (groupUseStatementPart != null);
        assert (singleUseStatementPart != null);
        assert (groupUseStatementPart.getItems().contains(singleUseStatementPart)) : singleUseStatementPart + " not found in: " + groupUseStatementPart.getItems();
        NamespaceName baseNamespaceName = groupUseStatementPart.getBaseNamespaceName();
        NamespaceName namespaceName = singleUseStatementPart.getName();
        ArrayList<Identifier> segments = new ArrayList<Identifier>(baseNamespaceName.getSegments().size() + namespaceName.getSegments().size());
        segments.addAll(baseNamespaceName.getSegments());
        segments.addAll(namespaceName.getSegments());
        if (baseOffsets) {
            start = baseNamespaceName.getStartOffset();
            end = baseNamespaceName.getEndOffset();
        } else {
            start = namespaceName.getStartOffset();
            end = namespaceName.getEndOffset();
        }
        return new NamespaceName(start, end, segments, baseNamespaceName.isGlobal(), baseNamespaceName.isCurrent());
    }

    public static boolean isSyntheticTypeName(String name) {
        assert (name != null);
        return !name.isEmpty() && name.charAt(0) == '#';
    }

    public static boolean isSyntheticFunctionName(String name) {
        assert (name != null);
        return !name.isEmpty() && name.contains(":");
    }

    public static PhpVersion getPhpVersion(FileObject file) {
        assert (file != null);
        return PhpLanguageProperties.forFileObject((FileObject)file).getPhpVersion();
    }

    public static boolean isPhpVersion(FileObject file, PhpVersion version) {
        assert (file != null);
        assert (version != null);
        return CodeUtils.getPhpVersion(file) == version;
    }

    public static boolean isPhpVersionLessThan(FileObject file, PhpVersion version) {
        assert (file != null);
        assert (version != null);
        return CodeUtils.getPhpVersion(file).compareTo((Enum)version) < 0;
    }

    public static boolean isPhpVersionGreaterThan(FileObject file, PhpVersion version) {
        assert (file != null);
        assert (version != null);
        return CodeUtils.getPhpVersion(file).compareTo((Enum)version) > 0;
    }

    public static boolean isUniformVariableSyntax(StaticDispatch dispatch) {
        assert (dispatch != null);
        return CodeUtils.isUniformVariableSyntax(dispatch.getDispatcher());
    }

    public static boolean isUniformVariableSyntax(Expression expression) {
        assert (expression != null);
        return CodeUtils.extractUnqualifiedName(expression) == null;
    }

    @CheckForNull
    public static Identifier extractUnqualifiedIdentifier(Expression typeName) {
        Parameters.notNull((CharSequence)"typeName", (Object)typeName);
        if (typeName instanceof Identifier) {
            return (Identifier)typeName;
        }
        if (typeName instanceof NamespaceName) {
            return CodeUtils.extractUnqualifiedIdentifier((NamespaceName)typeName);
        }
        if (typeName instanceof Variable) {
            Variable v = (Variable)typeName;
            return CodeUtils.extractUnqualifiedIdentifier(v.getName());
        }
        if (typeName instanceof FieldAccess) {
            return CodeUtils.extractUnqualifiedIdentifier(((FieldAccess)typeName).getField());
        }
        if (typeName instanceof NullableType) {
            return CodeUtils.extractUnqualifiedIdentifier(((NullableType)typeName).getType());
        }
        return null;
    }

    @CheckForNull
    public static String extractUnqualifiedName(Expression typeName) {
        Parameters.notNull((CharSequence)"typeName", (Object)typeName);
        if (typeName instanceof Identifier) {
            return ((Identifier)typeName).getName();
        }
        if (typeName instanceof NamespaceName) {
            return CodeUtils.extractUnqualifiedName((NamespaceName)typeName);
        }
        if (typeName instanceof NullableType) {
            return NULLABLE_TYPE_PREFIX + CodeUtils.extractUnqualifiedName(((NullableType)typeName).getType());
        }
        if (typeName instanceof UnionType) {
            UnionType unionType = (UnionType)typeName;
            StringBuilder sb = new StringBuilder();
            for (Expression type : unionType.getTypes()) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(CodeUtils.extractUnqualifiedName(type));
            }
            return sb.toString();
        }
        return null;
    }

    @CheckForNull
    public static String extractQualifiedName(Expression typeName) {
        Parameters.notNull((CharSequence)"typeName", (Object)typeName);
        if (typeName instanceof Identifier) {
            return ((Identifier)typeName).getName();
        }
        if (typeName instanceof NamespaceName) {
            return CodeUtils.extractQualifiedName((NamespaceName)typeName);
        }
        if (typeName instanceof NullableType) {
            NullableType nullableType = (NullableType)typeName;
            return NULLABLE_TYPE_PREFIX + CodeUtils.extractQualifiedName(nullableType.getType());
        }
        if (typeName instanceof UnionType) {
            UnionType unionType = (UnionType)typeName;
            StringBuilder sb = new StringBuilder();
            for (Expression type : unionType.getTypes()) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(CodeUtils.extractQualifiedName(type));
            }
            return sb.toString();
        }
        assert (false) : typeName.getClass();
        return null;
    }

    public static String extractUnqualifiedClassName(StaticDispatch dispatch) {
        Parameters.notNull((CharSequence)"dispatch", (Object)dispatch);
        Expression dispatcher = dispatch.getDispatcher();
        return CodeUtils.extractUnqualifiedName(dispatcher);
    }

    public static String extractUnqualifiedTypeName(FormalParameter param) {
        Parameters.notNull((CharSequence)"param", (Object)param);
        Expression typeName = param.getParameterType();
        return typeName != null ? CodeUtils.extractUnqualifiedName(typeName) : null;
    }

    public static List<String> extractUnqualifiedTypeName(CatchClause catchClause) {
        Parameters.notNull((CharSequence)"catchClause", (Object)catchClause);
        ArrayList<String> typeNames = new ArrayList<String>();
        for (Expression className : catchClause.getClassNames()) {
            String typeName;
            if (className == null || (typeName = CodeUtils.extractUnqualifiedName(className)) == null) continue;
            typeNames.add(typeName);
        }
        return typeNames;
    }

    public static String extractUnqualifiedSuperClassName(ClassDeclaration clsDeclaration) {
        Parameters.notNull((CharSequence)"clsDeclaration", (Object)clsDeclaration);
        Expression clsName = clsDeclaration.getSuperClass();
        return clsName != null ? CodeUtils.extractUnqualifiedName(clsName) : null;
    }

    @CheckForNull
    public static String extractUnqualifiedSuperClassName(ClassInstanceCreation classInstanceCreation) {
        assert (classInstanceCreation != null);
        assert (classInstanceCreation.isAnonymous()) : classInstanceCreation;
        Expression clsName = classInstanceCreation.getSuperClass();
        return clsName != null ? CodeUtils.extractUnqualifiedName(clsName) : null;
    }

    public static String extractUnqualifiedName(NamespaceName namespaceName) {
        List<Identifier> segments = namespaceName.getSegments();
        return segments.get(segments.size() - 1).getName();
    }

    public static String extractQualifiedName(NamespaceName namespaceName) {
        Parameters.notNull((CharSequence)"namespaceName", (Object)namespaceName);
        StringBuilder sb = new StringBuilder();
        List<Identifier> segments = namespaceName.getSegments();
        if (namespaceName.isGlobal()) {
            sb.append("\\");
        }
        Iterator<Identifier> it = segments.iterator();
        while (it.hasNext()) {
            Identifier identifier = it.next();
            sb.append(identifier.getName());
            if (!it.hasNext()) continue;
            sb.append("\\");
        }
        return sb.toString();
    }

    public static Identifier extractUnqualifiedIdentifier(NamespaceName namespaceName) {
        List<Identifier> segments = namespaceName.getSegments();
        if (segments.size() >= 1) {
            return segments.get(segments.size() - 1);
        }
        return null;
    }

    public static String extractClassName(ClassName clsName) {
        assert (clsName != null);
        Expression name = clsName.getName();
        while (name instanceof Variable || name instanceof FieldAccess) {
            if (name instanceof Variable) {
                Variable var = (Variable)name;
                name = var.getName();
                continue;
            }
            if (!(name instanceof FieldAccess)) continue;
            FieldAccess fld = (FieldAccess)name;
            name = fld.getField().getName();
        }
        if (name instanceof NamespaceName) {
            return CodeUtils.extractQualifiedName((NamespaceName)name);
        }
        return name instanceof Identifier ? ((Identifier)name).getName() : "";
    }

    public static String extractClassName(ClassDeclaration clsDeclaration) {
        return clsDeclaration.getName().getName();
    }

    public static String extractClassName(ClassInstanceCreation classInstanceCreation) {
        return CodeUtils.extractClassName(classInstanceCreation.getClassName());
    }

    public static String extractTypeName(TypeDeclaration typeDeclaration) {
        return typeDeclaration.getName().getName();
    }

    @CheckForNull
    public static String extractVariableName(Variable var) {
        String variableName = VariableNameVisitor.getInstance().findName(var);
        if (variableName == null) {
            LOGGER.log(Level.FINE, "Can not retrieve variable name: {0}", var);
        }
        return variableName;
    }

    @CheckForNull
    public static String extractFormalParameterName(FormalParameter param) {
        Expression expression = param.getParameterName();
        if (expression instanceof Reference) {
            expression = ((Reference)expression).getExpression();
        }
        if (expression instanceof Variadic) {
            expression = ((Variadic)expression).getExpression();
        }
        if (expression instanceof Variable) {
            Variable variable = (Variable)expression;
            return CodeUtils.extractVariableName(variable);
        }
        return null;
    }

    public static String extractVariableType(Assignment assignment) {
        Expression rightSideExpression = assignment.getRightHandSide();
        if (rightSideExpression instanceof Assignment) {
            return CodeUtils.extractVariableType((Assignment)assignment.getRightHandSide());
        }
        if (rightSideExpression instanceof Reference) {
            Reference ref = (Reference)rightSideExpression;
            rightSideExpression = ref.getExpression();
        }
        if (rightSideExpression instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)rightSideExpression;
            Expression className = classInstanceCreation.getClassName().getName();
            return CodeUtils.extractUnqualifiedName(className);
        }
        if (rightSideExpression instanceof ArrayCreation) {
            return "array";
        }
        if (rightSideExpression instanceof FunctionInvocation) {
            FunctionInvocation functionInvocation = (FunctionInvocation)rightSideExpression;
            String fname = CodeUtils.extractFunctionName(functionInvocation);
            return FUNCTION_TYPE_PREFIX + fname;
        }
        if (rightSideExpression instanceof StaticMethodInvocation) {
            StaticMethodInvocation staticMethodInvocation = (StaticMethodInvocation)rightSideExpression;
            String className = CodeUtils.extractUnqualifiedClassName(staticMethodInvocation);
            String methodName = CodeUtils.extractFunctionName(staticMethodInvocation.getMethod());
            if (className != null && methodName != null) {
                return STATIC_METHOD_TYPE_PREFIX + className + '.' + methodName;
            }
        } else if (rightSideExpression instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)rightSideExpression;
            String varName = null;
            if (methodInvocation.getDispatcher() instanceof Variable) {
                Variable var = (Variable)methodInvocation.getDispatcher();
                varName = CodeUtils.extractVariableName(var);
            }
            String methodName = CodeUtils.extractFunctionName(methodInvocation.getMethod());
            if (varName != null && methodName != null) {
                return METHOD_TYPE_PREFIX + varName + '.' + methodName;
            }
        }
        return null;
    }

    public static String extractFunctionName(FunctionInvocation functionInvocation) {
        return CodeUtils.extractFunctionName(functionInvocation.getFunctionName());
    }

    public static String extractFunctionName(FunctionDeclaration functionDeclaration) {
        return functionDeclaration.getFunctionName().getName();
    }

    public static String extractMethodName(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getFunction().getFunctionName().getName();
    }

    @CheckForNull
    public static String extractFunctionName(FunctionName functionName) {
        String scalarName;
        if (functionName.getName() instanceof Identifier) {
            Identifier id = (Identifier)functionName.getName();
            return id.getName();
        }
        if (functionName.getName() instanceof NamespaceName) {
            return CodeUtils.extractUnqualifiedName((NamespaceName)functionName.getName());
        }
        if (functionName.getName() instanceof Scalar && CodeUtils.isQuoted(scalarName = ((Scalar)functionName.getName()).getStringValue())) {
            return scalarName.substring(1, scalarName.length() - 1);
        }
        if (functionName.getName() instanceof Variable) {
            Variable var = (Variable)functionName.getName();
            return CodeUtils.extractVariableName(var);
        }
        return null;
    }

    private static boolean isQuoted(String string) {
        return string != null && string.length() > 2 && (string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\""));
    }

    @CheckForNull
    public static String getParamDefaultValue(FormalParameter param) {
        Expression expr = param.getDefaultValue();
        return CodeUtils.getParamDefaultValue(expr);
    }

    @CheckForNull
    private static String getParamDefaultValue(Expression expr) {
        UnaryOperation.Operator operator = null;
        if (expr instanceof UnaryOperation) {
            UnaryOperation unaryExpr = (UnaryOperation)expr;
            operator = unaryExpr.getOperator();
            expr = unaryExpr.getExpression();
        }
        if (expr instanceof Scalar) {
            Scalar scalar = (Scalar)expr;
            String returnValue = scalar.getStringValue();
            return UnaryOperation.Operator.MINUS.equals((Object)operator) ? "-" + returnValue : returnValue;
        }
        if (expr instanceof NamespaceName) {
            return CodeUtils.extractQualifiedName((NamespaceName)expr);
        }
        if (expr instanceof ArrayCreation) {
            return CodeUtils.getParamDefaultValue((ArrayCreation)expr);
        }
        if (expr instanceof StaticConstantAccess) {
            StaticConstantAccess staticConstantAccess = (StaticConstantAccess)expr;
            Expression dispatcher = staticConstantAccess.getDispatcher();
            if (dispatcher instanceof Identifier) {
                Identifier i = (Identifier)dispatcher;
                return i.getName() + "::" + staticConstantAccess.getConstantName().getName();
            }
            if (dispatcher instanceof NamespaceName) {
                NamespaceName namespace = (NamespaceName)dispatcher;
                StringBuilder sb = new StringBuilder(CodeUtils.extractQualifiedName(namespace));
                return sb.append("::").append(staticConstantAccess.getConstantName().getName()).toString();
            }
        }
        return expr == null ? null : " ";
    }

    private static String getParamDefaultValue(ArrayCreation param) {
        StringBuilder sb = new StringBuilder("[");
        List<ArrayElement> arrayElements = param.getElements();
        if (arrayElements.size() > 0) {
            ArrayElement firstElement = arrayElements.get(0);
            Expression key = firstElement.getKey();
            if (key != null) {
                sb.append(CodeUtils.getParamDefaultValue(key));
                sb.append(" => ");
            }
            sb.append(CodeUtils.getParamDefaultValue(firstElement.getValue()));
        }
        if (arrayElements.size() > 1) {
            sb.append(",...");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String getParamDisplayName(FormalParameter param) {
        Expression paramNameExpr = param.getParameterName();
        StringBuilder paramName = new StringBuilder();
        if (paramNameExpr instanceof Variable) {
            Variable var = (Variable)paramNameExpr;
            Identifier id = (Identifier)var.getName();
            if (var.isDollared()) {
                paramName.append("$");
            }
            paramName.append(id.getName());
        } else if (paramNameExpr instanceof Reference) {
            paramName.append("&");
            Reference reference = (Reference)paramNameExpr;
            Expression expression = reference.getExpression();
            if (expression instanceof Variadic) {
                Variadic variadic = (Variadic)expression;
                paramName.append("...");
                expression = variadic.getExpression();
            }
            if (expression instanceof Variable) {
                Variable var = (Variable)reference.getExpression();
                if (var.isDollared()) {
                    paramName.append("$");
                }
                Identifier id = (Identifier)var.getName();
                paramName.append(id.getName());
            }
        }
        return paramName.length() == 0 ? null : paramName.toString();
    }

    public static boolean isConstructor(MethodDeclaration node) {
        return "__construct".equals(CodeUtils.extractMethodName(node));
    }

    public static List<String> getCommonNamespacePrefixes(List<String> namespaces) {
        if (namespaces.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<String> fqNamespaces = new LinkedList<String>();
        for (String namespace : namespaces) {
            fqNamespaces.add(CodeUtils.fullyQualifyNamespace(namespace));
        }
        ArrayList<String> prefixes = new ArrayList<String>(fqNamespaces.size());
        while (!fqNamespaces.isEmpty()) {
            String ns;
            String namespace;
            namespace = (String)fqNamespaces.poll();
            if (fqNamespaces.isEmpty()) break;
            assert (namespace.charAt(0) == '\\') : namespace;
            int separatorIndex = namespace.indexOf(92, 1);
            if (separatorIndex == -1) continue;
            String prefix = namespace.substring(0, separatorIndex + 1);
            ArrayList<String> prefixedNamespaces = new ArrayList<String>(fqNamespaces.size());
            Iterator iterator = fqNamespaces.iterator();
            while (iterator.hasNext() && (ns = (String)iterator.next()).startsWith(prefix)) {
                prefixedNamespaces.add(ns);
                iterator.remove();
            }
            if (prefixedNamespaces.isEmpty()) continue;
            prefixedNamespaces.add(0, namespace);
            if (prefixedNamespaces.size() > 1) {
                prefix = null;
                for (int i = 1; i < prefixedNamespaces.size(); ++i) {
                    String prev = (String)prefixedNamespaces.get(i - 1);
                    String next = (String)prefixedNamespaces.get(i);
                    String tmpPrefix = CodeUtils.getCommonNamespacePrefix(prev, next);
                    assert (tmpPrefix != null) : prev + " :: " + next;
                    if (prefix == null) {
                        prefix = tmpPrefix;
                        continue;
                    }
                    if (prefix.length() <= tmpPrefix.length()) continue;
                    prefix = tmpPrefix;
                }
                assert (prefix != null) : prefixedNamespaces;
            }
            prefixes.add(prefix);
        }
        return prefixes;
    }

    @CheckForNull
    static String getCommonNamespacePrefix(String ns1, String ns2) {
        int index;
        assert (ns1 != null);
        assert (ns2 != null);
        String fqns1 = CodeUtils.fullyQualifyNamespace(ns1);
        String fqns2 = CodeUtils.fullyQualifyNamespace(ns2);
        for (index = 0; index < fqns1.length() && index < fqns2.length() && fqns1.charAt(index) == fqns2.charAt(index); ++index) {
        }
        if (index < 3) {
            return null;
        }
        String prefix = fqns1.substring(0, index);
        if (prefix.charAt(index - 1) == '\\') {
            return prefix;
        }
        int lastNsIndex = prefix.lastIndexOf(92);
        if (lastNsIndex <= 0) {
            return null;
        }
        return prefix.substring(0, lastNsIndex + 1);
    }

    public static String fullyQualifyNamespace(String namespace) {
        assert (namespace != null);
        if (!namespace.isEmpty() && namespace.charAt(0) != '\\') {
            return '\\' + namespace;
        }
        return namespace;
    }

    public static boolean isNullableType(String typeName) {
        if (typeName == null || typeName.isEmpty()) {
            return false;
        }
        return typeName.startsWith(NULLABLE_TYPE_PREFIX);
    }

    public static String removeNullableTypePrefix(String typeName) {
        if (CodeUtils.isNullableType(typeName)) {
            return typeName.substring(1);
        }
        return typeName;
    }

    private static final class VariableNameVisitor
    extends DefaultVisitor {
        private String name = null;
        private boolean isDollared = false;

        private VariableNameVisitor() {
        }

        public static VariableNameVisitor getInstance() {
            return SingletonHolder.INSTANCE;
        }

        public String findName(Variable var) {
            this.name = null;
            this.scan(var);
            return this.name;
        }

        @Override
        public void visit(Scalar node) {
            String scalarName = node.getStringValue();
            this.name = scalarName.startsWith("'") && scalarName.endsWith("'") || scalarName.startsWith("\"") && scalarName.endsWith("\"") ? scalarName.substring(1, scalarName.length() - 1) : scalarName;
        }

        @Override
        public void visit(Variable node) {
            this.isDollared = node.isDollared();
            super.visit(node);
        }

        @Override
        public void visit(InfixExpression node) {
        }

        @Override
        public void visit(Identifier identifier) {
            this.name = this.isDollared ? "$" + identifier.getName() : identifier.getName();
        }

        @Override
        public void visit(ArrayAccess node) {
            this.scan(node.getName());
        }

        private static class SingletonHolder {
            public static final VariableNameVisitor INSTANCE = new VariableNameVisitor();

            private SingletonHolder() {
            }
        }
    }
}

