/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.netbeans.nbbuild.JarWithModuleAttributes;
import org.netbeans.nbbuild.MakeNBM;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class MakeUpdateDesc
extends MatchingTask {
    protected boolean usedMatchingTask = false;
    private List<Entityinclude> entityincludes = new ArrayList<Entityinclude>();
    private List<Group> groups = new ArrayList<Group>();
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private List<String> includeMessageDigests = Arrays.asList("SHA-512");
    private File desc;
    private File descLicense;
    private boolean automaticGrouping;
    private String dist_base;
    private boolean useLicenseUrl;
    private Path updaterJar;
    private String notificationMessage;
    private String notificationURL;
    private String contentDescription;
    private String contentDescriptionURL;

    public String getIncludeMessageDigests() {
        return this.includeMessageDigests.stream().collect(Collectors.joining(" "));
    }

    public void setIncludeMessageDigests(String includeMessageDigests) {
        if (includeMessageDigests == null) {
            includeMessageDigests = "";
        }
        this.includeMessageDigests = Arrays.asList(includeMessageDigests.split(" "));
    }

    public void setDesc(File d) {
        this.desc = d;
    }

    public void setDescLicense(File d) {
        this.descLicense = d;
    }

    public Group createGroup() {
        Group g = new Group();
        this.groups.add(g);
        return g;
    }

    public Entityinclude createEntityinclude() {
        Entityinclude i = new Entityinclude();
        this.entityincludes.add(i);
        return i;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setAutomaticgrouping(boolean b) {
        this.automaticGrouping = b;
    }

    public void setDistBase(String dbase) {
        this.dist_base = dbase;
    }

    public void setUseLicenseUrl(boolean useLicenseUrl) {
        this.useLicenseUrl = useLicenseUrl;
    }

    public Path createUpdaterJar() {
        this.updaterJar = new Path(this.getProject());
        return this.updaterJar;
    }

    public void setNotificationMessage(String message) {
        this.notificationMessage = message;
    }

    public void setNotificationURL(String url) {
        this.notificationURL = url;
    }

    public void setContentDescription(String message) {
        this.contentDescription = message;
    }

    public void setContentDescriptionURL(String url) {
        this.contentDescriptionURL = url;
    }

    private static String xmlEscape(String s) {
        int max = s.length();
        StringBuffer s2 = new StringBuffer((int)((double)max * 1.1 + 1.0));
        block6: for (int i = 0; i < max; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    s2.append("&lt;");
                    continue block6;
                }
                case '>': {
                    s2.append("&gt;");
                    continue block6;
                }
                case '&': {
                    s2.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    s2.append("&quot;");
                    continue block6;
                }
                default: {
                    s2.append(c);
                }
            }
        }
        return s2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        Group root = new Group();
        for (FileSet fs : this.filesets) {
            root.addFileSet(fs);
        }
        this.groups.add(root);
        if (this.desc.exists()) {
            long time = this.desc.lastModified();
            boolean uptodate = true;
            block16: for (Group group : this.groups) {
                for (FileSet n : group.filesets) {
                    if (n == null) continue;
                    DirectoryScanner ds = n.getDirectoryScanner(this.getProject());
                    String[] files = ds.getIncludedFiles();
                    File bdir = ds.getBasedir();
                    for (String file : files) {
                        File n_file = new File(bdir, file);
                        if (n_file.lastModified() <= time) continue;
                        uptodate = false;
                        break block16;
                    }
                }
            }
            if (uptodate) {
                return;
            }
        }
        this.log("Creating update description " + this.desc.getAbsolutePath());
        Map<String, Collection<Module>> modulesByGroup = this.loadNBMs();
        boolean targetClustersDefined = false;
        for (Collection<Module> collection : modulesByGroup.values()) {
            for (Module module : collection) {
                targetClustersDefined |= module.xml.getAttributeNode("targetcluster") != null;
            }
        }
        boolean isPreferredUpdateDefined = false;
        for (Collection<Module> collection : modulesByGroup.values()) {
            for (Object m2 : collection) {
                isPreferredUpdateDefined |= ((Module)m2).xml.getAttributeNode("preferredupdate") != null;
            }
        }
        boolean bl = false;
        for (Collection<Module> collection : modulesByGroup.values()) {
            for (Module m3 : collection) {
                Element manifest = (Element)m3.xml.getElementsByTagName("manifest").item(0);
                n |= m3.autoload || m3.eager || manifest.getAttribute("AutoUpdate-Show-In-Client").length() > 0 || manifest.getAttribute("AutoUpdate-Essential-Module").length() > 0 ? 1 : 0;
            }
        }
        try {
            void var6_23;
            this.desc.delete();
            FileOutputStream fileOutputStream = new FileOutputStream(this.desc);
            try {
                void var7_35;
                int n;
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"));
                printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                printWriter.println();
                if (this.descLicense != null) {
                    printWriter.println(new String(Files.readAllBytes(this.descLicense.toPath()), "UTF-8"));
                }
                SimpleDateFormat format = new SimpleDateFormat("ss/mm/HH/dd/MM/yyyy");
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                String date = format.format(new Date());
                if (this.entityincludes.size() > 0) {
                    int i;
                    String ent_name = this.desc.getAbsolutePath();
                    int xml_idx = ent_name.indexOf(".xml");
                    ent_name = xml_idx != -1 ? ent_name.substring(0, xml_idx) + ".ent" : ent_name + ".ent";
                    File desc_ent = new File(ent_name);
                    desc_ent.delete();
                    if (this.includeMessageDigests != null && !this.includeMessageDigests.isEmpty()) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.8//EN\" \"https://netbeans.apache.org/dtds/autoupdate-catalog-2_8.dtd\" [");
                    } else if (isPreferredUpdateDefined || this.contentDescription != null && !this.contentDescription.isEmpty()) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.7//EN\" \"https://netbeans.apache.org/dtds/autoupdate-catalog-2_7.dtd\" [");
                    } else if (this.useLicenseUrl) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.6//EN\" \"https://netbeans.apache.org/dtds/autoupdate-catalog-2_6.dtd\" [");
                    } else if (n != 0) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.5//EN\" \"https://netbeans.apache.org/dtds/autoupdate-catalog-2_5.dtd\" [");
                    } else if (targetClustersDefined) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.4//EN\" \"https://netbeans.apache.org/dtds/autoupdate-catalog-2_4.dtd\" [");
                    } else {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.3//EN\" \"https://netbeans.apache.org/dtds/autoupdate-catalog-2_3.dtd\" [");
                    }
                    printWriter.println("    <!ENTITY entity SYSTEM \"" + MakeUpdateDesc.xmlEscape(desc_ent.getName()) + "\">");
                    boolean inc_num = false;
                    for (i = 0; i < this.entityincludes.size(); ++i) {
                        Entityinclude ei = this.entityincludes.get(i);
                        printWriter.println("    <!ENTITY include" + i + " SYSTEM \"" + MakeUpdateDesc.xmlEscape(ei.file) + "\">");
                    }
                    printWriter.println("]>");
                    printWriter.println();
                    printWriter.println("<module_updates timestamp=\"" + MakeUpdateDesc.xmlEscape(date) + "\">");
                    printWriter.println("    &entity;");
                    for (i = 0; i < this.entityincludes.size(); ++i) {
                        printWriter.println("    &include" + i + ";");
                    }
                    printWriter.println("</module_updates>");
                    printWriter.println();
                    printWriter.flush();
                    printWriter.close();
                    FileOutputStream fileOutputStream2 = new FileOutputStream(desc_ent);
                    PrintWriter printWriter2 = new PrintWriter(new OutputStreamWriter((OutputStream)fileOutputStream2, "UTF-8"));
                    printWriter2.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                    printWriter2.println("<!-- external entity include " + date + " -->");
                    printWriter2.println();
                } else {
                    if (this.includeMessageDigests != null && !this.includeMessageDigests.isEmpty()) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.8//EN\" \"https://netbeans.apache.org/dtds/autoupdate-catalog-2_8.dtd\">");
                    } else if (isPreferredUpdateDefined || this.contentDescription != null && !this.contentDescription.isEmpty()) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.7//EN\" \"https://netbeans.apache.org/dtds/autoupdate-catalog-2_7.dtd\">");
                    } else if (this.useLicenseUrl) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.6//EN\" \"https://netbeans.apache.org/dtds/autoupdate-catalog-2_6.dtd\">");
                    } else if (n != 0) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.5//EN\" \"https://netbeans.apache.org/dtds/autoupdate-catalog-2_5.dtd\">");
                    } else if (targetClustersDefined) {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.4//EN\" \"https://netbeans.apache.org/dtds/autoupdate-catalog-2_4.dtd\">");
                    } else {
                        printWriter.println("<!DOCTYPE module_updates PUBLIC \"-//NetBeans//DTD Autoupdate Catalog 2.3//EN\" \"https://netbeans.apache.org/dtds/autoupdate-catalog-2_3.dtd\">");
                    }
                    printWriter.println("<module_updates timestamp=\"" + date + "\">");
                    printWriter.println();
                }
                this.writeNotification((PrintWriter)var7_35);
                var7_35.println();
                this.writeContentDescription((PrintWriter)var7_35);
                var7_35.println();
                HashMap<String, Element> licenses = new HashMap<String, Element>();
                String prefix = null;
                if (this.dist_base != null) {
                    prefix = this.dist_base.equals(".") ? "" : this.dist_base + "/";
                }
                File licensesDir = new File(this.desc.getParentFile(), "licenses");
                if (this.useLicenseUrl) {
                    if (licensesDir.exists()) {
                        File[] licenseFiles;
                        for (File f : licenseFiles = licensesDir.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                return pathname.getName().endsWith(".license");
                            }
                        })) {
                            f.delete();
                        }
                    } else {
                        licensesDir.mkdir();
                    }
                }
                for (Map.Entry<String, Collection<Module>> entry : modulesByGroup.entrySet()) {
                    String groupName = entry.getKey();
                    this.log("Creating group \"" + groupName + "\"");
                    if (groupName != null) {
                        var7_35.println("<module_group name=\"" + MakeUpdateDesc.xmlEscape(groupName) + "\">");
                        var7_35.println();
                    }
                    for (Module m4 : entry.getValue()) {
                        NodeList licenseList;
                        Element manifest;
                        String name;
                        Element module = m4.xml;
                        if (module.getAttribute("downloadsize").equals("0")) {
                            module.setAttribute("downloadsize", Long.toString(m4.nbm.length() + m4.externalDownloadSize));
                        }
                        if ((name = (manifest = (Element)module.getElementsByTagName("manifest").item(0)).getAttribute("OpenIDE-Module-Name")).length() > 0) {
                            this.log(" Adding module " + name + " (" + m4.nbm.getAbsolutePath() + ")");
                        }
                        if (prefix != null) {
                            module.setAttribute("distribution", prefix + m4.relativePath);
                        }
                        if ((licenseList = module.getElementsByTagName("license")).getLength() > 0) {
                            Element license = (Element)licenseList.item(0);
                            if (this.useLicenseUrl) {
                                String relativePath;
                                String path = relativePath = "licenses/" + license.getAttribute("name") + ".license";
                                if (prefix != null) {
                                    path = prefix + relativePath;
                                }
                                license.setAttribute("url", path);
                                String licenseText = license.getTextContent();
                                license.setTextContent("");
                                try (FileOutputStream fos = new FileOutputStream(new File(this.desc.getParentFile(), relativePath));){
                                    fos.write(licenseText.getBytes("UTF-8"));
                                }
                            }
                            licenses.put(license.getAttribute("name"), license);
                            module.removeChild(license);
                        }
                        if (m4.autoload) {
                            module.setAttribute("autoload", "true");
                        }
                        if (m4.eager) {
                            module.setAttribute("eager", "true");
                        }
                        var7_35.flush();
                        XMLUtil.write(module, (OutputStream)var6_23);
                        var7_35.println();
                    }
                    if (groupName == null) continue;
                    var7_35.println("</module_group>");
                    var7_35.println();
                }
                var7_35.flush();
                for (Element license : licenses.values()) {
                    XMLUtil.write(license, (OutputStream)var6_23);
                }
                if (this.entityincludes.size() <= 0) {
                    var7_35.println("</module_updates>");
                    var7_35.println();
                }
                var7_35.flush();
                var7_35.close();
            }
            catch (Throwable throwable) {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            var6_23.flush();
            var6_23.close();
        }
        catch (IOException iOException) {
            this.desc.delete();
            throw new BuildException("Cannot create update description", (Throwable)iOException, this.getLocation());
        }
        if (this.updaterJar != null && this.updaterJar.size() > 0) {
            try {
                MakeNBM.validateAgainstAUDTDs(new InputSource(this.desc.toURI().toString()), this.updaterJar, (Task)this);
            }
            catch (Exception exception) {
                this.desc.delete();
                throw new BuildException("Could not validate " + this.desc + " after writing: " + exception, (Throwable)exception, this.getLocation());
            }
        } else {
            this.log("No updater.jar specified, cannot validate " + this.desc + " against DTD", 1);
        }
    }

    private void writeNotification(PrintWriter pw) {
        if (this.notificationMessage == null) {
            this.notificationMessage = "";
        }
        if (this.notificationURL == null) {
            this.notificationURL = "";
        }
        if (this.notificationMessage.length() > 0 || this.notificationURL.length() > 0) {
            if (this.notificationMessage.length() == 0) {
                pw.println("<notification url=\"" + MakeUpdateDesc.xmlEscape(this.notificationURL.toString()) + "\"/>");
            } else if (this.notificationURL.length() == 0) {
                pw.println("<notification>" + MakeUpdateDesc.xmlEscape(this.notificationMessage) + "</notification>");
            } else {
                pw.println("<notification url=\"" + MakeUpdateDesc.xmlEscape(this.notificationURL.toString()) + "\">" + MakeUpdateDesc.xmlEscape(this.notificationMessage) + "</notification>");
            }
            pw.println();
        }
    }

    private void writeContentDescription(PrintWriter pw) {
        if (this.contentDescription == null) {
            this.contentDescription = "";
        }
        if (this.contentDescriptionURL == null) {
            this.contentDescriptionURL = "";
        }
        if (this.contentDescription.length() > 0 || this.contentDescriptionURL.length() > 0) {
            if (this.contentDescription.length() == 0) {
                pw.println("<content_description url=\"" + MakeUpdateDesc.xmlEscape(this.contentDescriptionURL.toString()) + "\"/>");
            } else if (this.contentDescriptionURL.length() == 0) {
                pw.println("<content_description>" + MakeUpdateDesc.xmlEscape(this.contentDescription) + "</content_description>");
            } else {
                pw.println("<content_description url=\"" + MakeUpdateDesc.xmlEscape(this.contentDescriptionURL.toString()) + "\">" + MakeUpdateDesc.xmlEscape(this.contentDescription) + "</content_description>");
            }
            pw.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Collection<Module>> loadNBMs() throws BuildException {
        final Collator COLL = Collator.getInstance();
        Comparator<String> groupNameComparator = new Comparator<String>(){

            @Override
            public int compare(String gn1, String gn2) {
                return gn1 != null ? (gn2 != null ? COLL.compare(gn1, gn2) : 1) : (gn2 != null ? -1 : 0);
            }
        };
        TreeMap<String, Collection<Module>> r = this.automaticGrouping ? new TreeMap(groupNameComparator) : new LinkedHashMap();
        Comparator<Module> moduleDisplayNameComparator = new Comparator<Module>(){

            @Override
            public int compare(Module m1, Module m2) {
                int res = COLL.compare(this.getName(m1), this.getName(m2));
                return res != 0 ? res : System.identityHashCode(m1) - System.identityHashCode(m2);
            }

            String getName(Module m) {
                Element mani = (Element)m.xml.getElementsByTagName("manifest").item(0);
                String displayName = mani.getAttribute("OpenIDE-Module-Name");
                if (displayName.length() > 0) {
                    return displayName;
                }
                return mani.getAttribute("OpenIDE-Module");
            }
        };
        for (Group g : this.groups) {
            TreeSet<Module> modules = (TreeSet<Module>)r.get(g.name);
            if (modules == null) {
                modules = new TreeSet<Module>(moduleDisplayNameComparator);
                r.put(g.name, modules);
            }
            for (FileSet fs : g.filesets) {
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                for (String file : ds.getIncludedFiles()) {
                    File n_file = new File(fs.getDir(this.getProject()), file);
                    try (JarFile jar = new JarFile(n_file);){
                        Object name;
                        String categ;
                        Module m = new Module();
                        m.nbm = n_file;
                        m.relativePath = file.replace(File.separatorChar, '/');
                        Manifest jarmani = jar.getManifest();
                        if (jarmani != null && jarmani.getMainAttributes().getValue("Bundle-SymbolicName") != null) {
                            m.xml = MakeUpdateDesc.fakeOSGiInfoXml(jar, n_file);
                            modules.add(m);
                            continue;
                        }
                        ZipEntry entry = jar.getEntry("Info/info.xml");
                        if (entry == null) {
                            throw new BuildException("NBM " + n_file + " was malformed: no Info/info.xml", this.getLocation());
                        }
                        try (InputStream is = jar.getInputStream(entry);){
                            m.xml = XMLUtil.parse(new InputSource(is), false, false, XMLUtil.rethrowHandler(), XMLUtil.nullResolver()).getDocumentElement();
                        }
                        Collection<Module> moduleCollection = modules;
                        Element manifest = (Element)m.xml.getElementsByTagName("manifest").item(0);
                        if (this.automaticGrouping && g.name == null && (categ = manifest.getAttribute("OpenIDE-Module-Display-Category")).length() > 0 && (moduleCollection = (Collection)r.get(categ)) == null) {
                            moduleCollection = new TreeSet<Module>(moduleDisplayNameComparator);
                            r.put(categ, moduleCollection);
                        }
                        boolean old = false;
                        String destDir = this.getProject().getProperty("netbeans.dest.dir");
                        if (destDir != null) {
                            for (File cluster : this.getProject().resolveFile(destDir).listFiles()) {
                                if (!new File(cluster, "modules/org-netbeans-modules-autoupdate.jar").isFile()) continue;
                                old = true;
                                break;
                            }
                        }
                        if (!old) {
                            String cnb = manifest.getAttribute("OpenIDE-Module").replaceFirst("/\\d+$", "");
                            entry = jar.getEntry("netbeans/config/Modules/" + cnb.replace('.', '-') + ".xml");
                            if (entry != null) {
                                is = jar.getInputStream(entry);
                                try {
                                    NodeList nl = XMLUtil.parse(new InputSource(is), false, false, XMLUtil.rethrowHandler(), XMLUtil.nullResolver()).getElementsByTagName("param");
                                    for (int i = 0; i < nl.getLength(); ++i) {
                                        name = ((Element)nl.item(i)).getAttribute("name");
                                        String value = ((Text)nl.item(i).getFirstChild()).getData();
                                        if (((String)name).equals("autoload") && value.equals("true")) {
                                            m.autoload = true;
                                        }
                                        if (!((String)name).equals("eager") || !value.equals("true")) continue;
                                        m.eager = true;
                                    }
                                }
                                finally {
                                    is.close();
                                }
                            }
                        }
                        Enumeration<JarEntry> en = jar.entries();
                        while (en.hasMoreElements()) {
                            JarEntry e = en.nextElement();
                            if (!e.getName().endsWith(".external")) continue;
                            InputStream eStream = jar.getInputStream(e);
                            name = null;
                            try {
                                m.externalDownloadSize += this.externalSize(eStream);
                            }
                            catch (Throwable value) {
                                name = value;
                                throw value;
                            }
                            finally {
                                if (eStream == null) continue;
                                if (name != null) {
                                    try {
                                        eStream.close();
                                    }
                                    catch (Throwable value) {
                                        ((Throwable)name).addSuppressed(value);
                                    }
                                    continue;
                                }
                                eStream.close();
                            }
                        }
                        Map<String, String> messageDigests = this.createMessageDigests(n_file);
                        for (Map.Entry<String, String> messageDigest : messageDigests.entrySet()) {
                            Element messageDigestElement = m.xml.getOwnerDocument().createElement("message_digest");
                            messageDigestElement.setAttribute("algorithm", messageDigest.getKey());
                            messageDigestElement.setAttribute("value", messageDigest.getValue());
                            m.xml.appendChild(messageDigestElement);
                        }
                        moduleCollection.add(m);
                    }
                    catch (BuildException x) {
                        throw x;
                    }
                    catch (Exception e) {
                        throw new BuildException("Cannot process " + n_file + ": " + e, (Throwable)e, this.getLocation());
                    }
                }
            }
        }
        return r;
    }

    private long externalSize(InputStream is) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        while ((line = br.readLine()) != null) {
            if (!line.startsWith("SIZE:")) continue;
            return Long.parseLong(line.substring(5).trim());
        }
        return 0L;
    }

    private static Element fakeOSGiInfoXml(JarFile jar, File whereFrom) throws IOException {
        return MakeUpdateDesc.fakeOSGiInfoXml(jar, whereFrom, XMLUtil.createDocument("module"));
    }

    public static Element fakeOSGiInfoXml(JarFile jar, File whereFrom, Document doc) throws IOException {
        Attributes attr = jar.getManifest().getMainAttributes();
        Properties localized = new Properties();
        String bundleLocalization = attr.getValue("Bundle-Localization");
        if (bundleLocalization != null) {
            try (InputStream is = jar.getInputStream(jar.getEntry(bundleLocalization + ".properties"));){
                localized.load(is);
            }
        }
        return MakeUpdateDesc.fakeOSGiInfoXml(attr, localized, whereFrom, doc);
    }

    static Element fakeOSGiInfoXml(Attributes attr, Properties localized, File whereFrom) {
        return MakeUpdateDesc.fakeOSGiInfoXml(attr, localized, whereFrom, XMLUtil.createDocument("module"));
    }

    private static Element fakeOSGiInfoXml(Attributes attr, Properties localized, File whereFrom, Document doc) {
        String bundleDescription;
        String bundleCategory;
        String recommends;
        String provides;
        Element module = doc.getDocumentElement();
        String cnb = JarWithModuleAttributes.extractCodeName(attr);
        module.setAttribute("codenamebase", cnb);
        module.setAttribute("distribution", "");
        module.setAttribute("downloadsize", "0");
        module.setAttribute("targetcluster", whereFrom.getParentFile().getName());
        Element manifest = doc.createElement("manifest");
        module.appendChild(manifest);
        manifest.setAttribute("AutoUpdate-Show-In-Client", "false");
        manifest.setAttribute("OpenIDE-Module", cnb);
        String bundleName = MakeUpdateDesc.loc(localized, attr, "Bundle-Name");
        manifest.setAttribute("OpenIDE-Module-Name", bundleName != null ? bundleName : cnb);
        String bundleVersion = attr.getValue("Bundle-Version");
        manifest.setAttribute("OpenIDE-Module-Specification-Version", bundleVersion != null ? bundleVersion.replaceFirst("^(\\d+([.]\\d+([.]\\d+)?)?)([.].+)?$", "$1") : "0");
        String requireBundle = attr.getValue("Require-Bundle");
        if (requireBundle != null) {
            StringBuilder b = new StringBuilder();
            boolean needsNetbinox = false;
            for (String dep : requireBundle.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)")) {
                Matcher m = Pattern.compile("([^;]+)(.*)").matcher(dep);
                if (!m.matches()) {
                    throw new BuildException("Could not parse dependency: " + dep + " in " + whereFrom);
                }
                String requiredBundleName = m.group(1);
                if (requiredBundleName.trim().equals("org.eclipse.osgi")) {
                    needsNetbinox = true;
                    continue;
                }
                Matcher m2 = Pattern.compile(";([^:=]+):?=\"?([^;\"]+)\"?").matcher(m.group(2));
                boolean isOptional = false;
                while (m2.find()) {
                    if (!m2.group(1).equals("resolution") || !m2.group(2).equals("optional")) continue;
                    isOptional = true;
                    break;
                }
                if (isOptional) continue;
                m2.reset();
                StringBuilder depSB = new StringBuilder();
                depSB.append(requiredBundleName.replace('-', '_'));
                while (m2.find()) {
                    if (!m2.group(1).equals("bundle-version")) continue;
                    String val = m2.group(2);
                    if (val.matches("[0-9]+([.][0-9]+)*")) {
                        depSB.append(" > ").append(val);
                        continue;
                    }
                    Matcher m3 = Pattern.compile("\\[([0-9]+)((?:[.][0-9]+)*),([0-9.]+)\\)").matcher(val);
                    if (!m3.matches()) {
                        throw new BuildException("Could not parse version range: " + val + " in " + whereFrom);
                    }
                    int major = Integer.parseInt(m3.group(1));
                    String rest = m3.group(2);
                    try {
                        int max = Integer.parseInt(m3.group(3));
                        if (major > 99) {
                            depSB.append('/').append(major / 100);
                            if (max > major + 100) {
                                depSB.append('-').append(max / 100 - 1);
                            }
                        } else if (max > 100) {
                            depSB.append("/0-").append(max / 100 - 1);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    depSB.append(" > ").append(major % 100).append(rest);
                }
                if (b.indexOf(depSB.toString()) != -1) continue;
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append((CharSequence)depSB);
            }
            if (b.length() > 0) {
                manifest.setAttribute("OpenIDE-Module-Module-Dependencies", b.toString());
            }
            if (needsNetbinox) {
                manifest.setAttribute("OpenIDE-Module-Needs", "org.netbeans.Netbinox");
            }
        }
        if (!(provides = MakeUpdateDesc.computeExported(attr).toString()).isEmpty()) {
            manifest.setAttribute("OpenIDE-Module-Provides", provides);
        }
        if (!(recommends = MakeUpdateDesc.computeImported(attr).toString()).isEmpty()) {
            manifest.setAttribute("OpenIDE-Module-Recommends", recommends);
        }
        if ((bundleCategory = MakeUpdateDesc.loc(localized, attr, "Bundle-Category")) != null) {
            manifest.setAttribute("OpenIDE-Module-Display-Category", bundleCategory);
        }
        if ((bundleDescription = MakeUpdateDesc.loc(localized, attr, "Bundle-Description")) != null) {
            manifest.setAttribute("OpenIDE-Module-Short-Description", bundleDescription);
        }
        return module;
    }

    private static String loc(Properties localized, Attributes attr, String key) {
        String val = attr.getValue(key);
        if (val == null) {
            return null;
        }
        if (val.startsWith("%")) {
            return localized.getProperty(val.substring(1));
        }
        return val;
    }

    private static StringTokenizer createTokenizer(String osgiDep) {
        int second;
        int first;
        while ((first = osgiDep.indexOf(34)) != -1 && (second = osgiDep.indexOf(34, first + 1)) != -1) {
            osgiDep = osgiDep.substring(0, first - 1) + osgiDep.substring(second + 1);
        }
        return new StringTokenizer(osgiDep, ",");
    }

    private static String beforeSemicolon(StringTokenizer tok) {
        String dep = tok.nextToken().trim();
        int semicolon = dep.indexOf(59);
        if (semicolon >= 0) {
            dep = dep.substring(0, semicolon);
        }
        return dep.replace('-', '_');
    }

    private static StringBuilder computeExported(Attributes attr) {
        StringBuilder sb = new StringBuilder();
        String pkgs = attr.getValue("Export-Package");
        if (pkgs == null) {
            return sb;
        }
        StringTokenizer tok = MakeUpdateDesc.createTokenizer(pkgs);
        while (tok.hasMoreElements()) {
            String token = MakeUpdateDesc.beforeSemicolon(tok);
            if (sb.indexOf(token) != -1) continue;
            sb.append(sb.length() == 0 ? "" : ", ").append(token);
        }
        return sb;
    }

    private static StringBuilder computeImported(Attributes attr) {
        String recomm;
        StringBuilder sb = new StringBuilder();
        String pkgs = attr.getValue("Import-Package");
        if (pkgs != null) {
            StringTokenizer tok = MakeUpdateDesc.createTokenizer(pkgs);
            while (tok.hasMoreElements()) {
                String token = MakeUpdateDesc.beforeSemicolon(tok);
                if (sb.indexOf(token) != -1) continue;
                sb.append(sb.length() == 0 ? "" : ", ").append(token);
            }
        }
        if ((recomm = attr.getValue("Require-Bundle")) != null) {
            StringTokenizer tok = MakeUpdateDesc.createTokenizer(recomm);
            while (tok.hasMoreElements()) {
                String token = MakeUpdateDesc.beforeSemicolon(tok);
                if (sb.indexOf(token) != -1) continue;
                sb.append(sb.length() == 0 ? "" : ", ").append("cnb.").append(token);
            }
        }
        return sb;
    }

    private Map<String, String> createMessageDigests(File targetFile) {
        if (this.includeMessageDigests.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, MessageDigest> digests = new HashMap<String, MessageDigest>(this.includeMessageDigests.size());
        for (String messageDigest : this.includeMessageDigests) {
            try {
                digests.put(messageDigest, MessageDigest.getInstance(messageDigest));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new BuildException("Failed to load requested messageDigest: " + messageDigest, (Throwable)noSuchAlgorithmException);
            }
        }
        try {
            FileInputStream fis = new FileInputStream(targetFile);
            Object object = null;
            try {
                int read;
                byte[] byArray = new byte[102400];
                while ((read = fis.read(byArray)) >= 0) {
                    for (MessageDigest md : digests.values()) {
                        md.update(byArray, 0, read);
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fis != null) {
                    if (object != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        fis.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MakeUpdateDesc.class.getName()).log(Level.SEVERE, null, ex);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : digests.entrySet()) {
            result.put((String)entry.getKey(), MakeUpdateDesc.hexEncode(((MessageDigest)entry.getValue()).digest()));
        }
        return result;
    }

    private static String hexEncode(byte[] input) {
        StringBuilder sb = new StringBuilder(input.length * 2);
        for (byte b : input) {
            sb.append(Character.forDigit((b & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(b & 0xF, 16));
        }
        return sb.toString();
    }

    private static byte[] hexDecode(String input) {
        int length = input.length() / 2;
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            int b = Character.digit(input.charAt(i * 2), 16) << 4;
            result[i] = (byte)((b |= Character.digit(input.charAt(i * 2 + 1), 16)) & 0xFF);
        }
        return result;
    }

    private static class Module {
        public Element xml;
        public File nbm;
        public String relativePath;
        public boolean autoload;
        public boolean eager;
        public long externalDownloadSize;
    }

    public class Entityinclude {
        public String file;

        public void setFile(String f) {
            this.file = f;
        }
    }

    public class Group {
        public List<FileSet> filesets = new ArrayList<FileSet>();
        public String name;

        public void setName(String s) {
            this.name = s;
        }

        public void addFileSet(FileSet set) {
            this.filesets.add(set);
        }
    }
}

