/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.eval;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.ui.eval.ButtonPopupSwitcher;
import org.netbeans.modules.debugger.ui.eval.SwitcherTableItem;
import org.netbeans.spi.debugger.ui.CodeEvaluator;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CodeEvaluatorUI
extends TopComponent
implements HelpCtx.Provider,
DocumentListener,
KeyListener,
PropertyChangeListener {
    private static final String ID = "evaluatorPane";
    private static final String PROP_RESULT_CHANGED = "resultChanged";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static WeakReference<CodeEvaluatorUI> instanceRef;
    private JEditorPane codePane;
    private volatile String codeText = "";
    private Reference<CodeEvaluator.EvaluatorService> debuggerRef = new WeakReference<Object>(null);
    private final DbgManagerListener dbgManagerListener;
    private final JButton dropDownButton;
    private static final RequestProcessor rp;
    private RequestProcessor.Task setupContextTask;
    private JScrollPane editorScrollPane;
    private JButton evaluateButton;
    private JPanel rightPanel;
    private JPanel separatorPanel;

    public CodeEvaluatorUI() {
        this.initComponents();
        this.codePane = new JEditorPaneWithHelp();
        this.codePane.setMinimumSize(new Dimension(0, 0));
        this.codePane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        EditorUI eui = Utilities.getEditorUI((JTextComponent)this.codePane);
        try {
            Field textLimitLineField = EditorUI.class.getDeclaredField("textLimitLineVisible");
            textLimitLineField.setAccessible(true);
            textLimitLineField.set(eui, false);
        }
        catch (Exception textLimitLineField) {
            // empty catch block
        }
        this.dropDownButton = this.createDropDownButton();
        GroupLayout rightPanelLayout = new GroupLayout(this.rightPanel);
        this.rightPanel.setLayout(rightPanelLayout);
        rightPanelLayout.setHorizontalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.dropDownButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 2, 2)).addGroup(rightPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 2, 2).addComponent(this.evaluateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 2, 2)));
        rightPanelLayout.setVerticalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightPanelLayout.createSequentialGroup().addComponent(this.dropDownButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.evaluateButton)));
        Dimension preferredSize = this.rightPanel.getPreferredSize();
        this.rightPanel.setMinimumSize(preferredSize);
        this.editorScrollPane.setViewportView(this.codePane);
        this.invalidate();
        this.codePane.addKeyListener(this);
        this.dbgManagerListener = new DbgManagerListener(this);
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this.dbgManagerListener);
        this.checkDebuggerState();
    }

    public void pasteExpression(String expr) {
        this.codePane.setText(expr);
        this.codeText = expr;
        if (!this.isOpened()) {
            this.open();
        }
        this.requestActive();
    }

    private JButton createDropDownButton() {
        ImageIcon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/evaluator/drop_down_arrow.png", (boolean)false);
        DropDownButton button = new DropDownButton();
        button.setIcon(icon);
        String tooltipText = NbBundle.getMessage(CodeEvaluatorUI.class, (String)"CTL_Expressions_Dropdown_tooltip");
        button.setToolTipText(tooltipText);
        button.setEnabled(false);
        Dimension size = new Dimension(icon.getIconWidth() + 3, icon.getIconHeight() + 2);
        button.setPreferredSize(size);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setFocusable(false);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("pressed".equals(e.getActionCommand())) {
                    JComponent jc = (JComponent)e.getSource();
                    Point p = new Point(0, 0);
                    SwingUtilities.convertPointToScreen(p, jc);
                    if (!ButtonPopupSwitcher.isShown()) {
                        SwitcherTableItem[] items = CodeEvaluatorUI.this.createSwitcherItems();
                        ButtonPopupSwitcher.selectItem(jc, items, p.x, p.y);
                    }
                    if (jc instanceof AbstractButton) {
                        AbstractButton jb = (AbstractButton)jc;
                        jb.getModel().setPressed(false);
                        jb.getModel().setRollover(false);
                        jb.getModel().setArmed(false);
                        jb.repaint();
                    }
                }
            }

            @Override
            public boolean isEnabled() {
                return !CodeEvaluatorUI.this.getEditItemsList().isEmpty();
            }
        };
        action.putValue("SmallIcon", icon);
        action.putValue("ShortDescription", tooltipText);
        button.setAction(action);
        return button;
    }

    private void setupContext() {
        if (this.setupContextTask == null) {
            this.setupContextTask = rp.create(new Runnable(){

                @Override
                public void run() {
                    CodeEvaluatorUI.this.setupContextLazily();
                }
            });
        }
        this.setupContextTask.schedule(500);
    }

    private void setupContextLazily() {
        final String text = this.codeText;
        final Document[] documentPtr = new Document[]{null};
        CodeEvaluator.EvaluatorService es = this.debuggerRef.get();
        if (es != null) {
            class ContextUpdated
            implements Runnable {
                ContextUpdated() {
                }

                @Override
                public void run() {
                    if (CodeEvaluatorUI.this.codePane.getDocument() != documentPtr[0]) {
                        CodeEvaluatorUI.this.codePane.getDocument().addDocumentListener(CodeEvaluatorUI.this);
                        if (text != null) {
                            CodeEvaluatorUI.this.codePane.setText(text);
                        }
                    }
                    documentPtr[0] = CodeEvaluatorUI.this.codePane.getDocument();
                }
            }
            ContextUpdated contextUpdated = new ContextUpdated();
            es.setupContext(this.codePane, contextUpdated);
            SwingUtilities.invokeLater(contextUpdated);
        }
    }

    private List<String> getEditItemsList() {
        CodeEvaluator.EvaluatorService es = this.debuggerRef.get();
        if (es != null) {
            return es.getExpressionsHistory();
        }
        return Collections.EMPTY_LIST;
    }

    private SwitcherTableItem[] createSwitcherItems() {
        List<String> editItemsList = this.getEditItemsList();
        SwitcherTableItem[] items = new SwitcherTableItem[editItemsList.size()];
        int x = 0;
        for (String item : editItemsList) {
            items[x++] = new SwitcherTableItem(new MenuItemActivatable(item), item);
        }
        return items;
    }

    private void recomputeDropDownItems() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List editItemsList = CodeEvaluatorUI.this.getEditItemsList();
                for (String str : editItemsList) {
                    StringTokenizer tok = new StringTokenizer(str, "\n");
                    String dispName = "";
                    while (dispName.trim().length() == 0 && tok.hasMoreTokens()) {
                        dispName = tok.nextToken();
                    }
                }
                CodeEvaluatorUI.this.dropDownButton.setEnabled(!editItemsList.isEmpty());
            }
        });
    }

    public static synchronized CodeEvaluatorUI getInstance() {
        CodeEvaluatorUI instance = (CodeEvaluatorUI)WindowManager.getDefault().findTopComponent(ID);
        if (instance == null) {
            instance = new CodeEvaluatorUI();
        }
        return instance;
    }

    private static CodeEvaluatorUI getDefaultInstance() {
        CodeEvaluatorUI evaluator;
        CodeEvaluatorUI codeEvaluatorUI = evaluator = instanceRef != null ? (CodeEvaluatorUI)instanceRef.get() : null;
        if (evaluator != null) {
            return evaluator;
        }
        final CodeEvaluatorUI[] result = new CodeEvaluatorUI[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = CodeEvaluatorUI.getInstance();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        result[0] = CodeEvaluatorUI.getInstance();
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        instanceRef = new WeakReference<CodeEvaluatorUI>(result[0]);
        return result[0];
    }

    public static void addResultListener(final PropertyChangeListener listener) {
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CodeEvaluatorUI defaultInstance = CodeEvaluatorUI.getDefaultInstance();
                if (defaultInstance != null) {
                    PropertyChangeSupport propertyChangeSupport = defaultInstance.pcs;
                    synchronized (propertyChangeSupport) {
                        defaultInstance.pcs.addPropertyChangeListener(listener);
                    }
                }
            }
        });
    }

    public static void removeResultListener(final PropertyChangeListener listener) {
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CodeEvaluatorUI defaultInstance = CodeEvaluatorUI.getDefaultInstance();
                if (defaultInstance != null) {
                    PropertyChangeSupport propertyChangeSupport = defaultInstance.pcs;
                    synchronized (propertyChangeSupport) {
                        defaultInstance.pcs.removePropertyChangeListener(listener);
                    }
                }
            }
        });
    }

    private static void fireResultChange() {
        rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CodeEvaluatorUI defaultInstance = CodeEvaluatorUI.getDefaultInstance();
                if (defaultInstance != null) {
                    PropertyChangeSupport propertyChangeSupport = defaultInstance.pcs;
                    synchronized (propertyChangeSupport) {
                        defaultInstance.pcs.firePropertyChange(CodeEvaluatorUI.PROP_RESULT_CHANGED, null, null);
                    }
                }
            }
        });
    }

    private synchronized void checkDebuggerState() {
        DebuggerEngine de = DebuggerManager.getDebuggerManager().getCurrentEngine();
        final CodeEvaluator.EvaluatorService es = de != null ? (CodeEvaluator.EvaluatorService)de.lookupFirst(null, CodeEvaluator.EvaluatorService.class) : null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeEvaluator.EvaluatorService lastEs = (CodeEvaluator.EvaluatorService)CodeEvaluatorUI.this.debuggerRef.get();
                CodeEvaluatorUI.this.debuggerRef = new WeakReference<CodeEvaluator.EvaluatorService>(es);
                if (es != lastEs) {
                    CodeEvaluatorUI.this.setupContext();
                    if (lastEs != null) {
                        lastEs.removePropertyChangeListener(CodeEvaluatorUI.this);
                    }
                    if (es != null) {
                        es.addPropertyChangeListener(CodeEvaluatorUI.this);
                    }
                    CodeEvaluatorUI.this.computeEvaluationButtonState();
                    CodeEvaluatorUI.this.recomputeDropDownItems();
                }
            }
        });
    }

    private void computeEvaluationButtonState() {
        CodeEvaluator.EvaluatorService debugger = this.debuggerRef.get();
        boolean isEnabled = debugger != null && debugger.canEvaluate() && this.codePane.getDocument().getLength() > 0 && this.editorScrollPane.getViewport().getView() == this.codePane;
        this.evaluateButton.setEnabled(isEnabled);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this.dbgManagerListener);
    }

    private void initComponents() {
        this.evaluateButton = new JButton();
        this.editorScrollPane = new JScrollPane();
        this.separatorPanel = new JPanel();
        this.rightPanel = new JPanel();
        this.evaluateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/debugger/resources/evaluator/evaluate.png")));
        this.evaluateButton.setText(NbBundle.getMessage(CodeEvaluatorUI.class, (String)"CodeEvaluatorUI.evaluateButton.text"));
        this.evaluateButton.setToolTipText(NbBundle.getMessage(CodeEvaluatorUI.class, (String)"HINT_Evaluate_Button"));
        this.evaluateButton.setEnabled(false);
        this.evaluateButton.setPreferredSize(new Dimension(38, 22));
        this.evaluateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeEvaluatorUI.this.evaluateButtonActionPerformed(evt);
            }
        });
        this.editorScrollPane.setBorder(null);
        this.separatorPanel.setBackground(UIManager.getDefaults().getColor("Separator.foreground"));
        this.separatorPanel.setMaximumSize(new Dimension(1, Short.MAX_VALUE));
        this.separatorPanel.setMinimumSize(new Dimension(1, 10));
        this.separatorPanel.setPreferredSize(new Dimension(1, 10));
        GroupLayout rightPanelLayout = new GroupLayout(this.rightPanel);
        this.rightPanel.setLayout(rightPanelLayout);
        rightPanelLayout.setHorizontalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        rightPanelLayout.setVerticalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 22, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.editorScrollPane, -1, 488, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.separatorPanel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.rightPanel, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editorScrollPane, -1, 22, Short.MAX_VALUE).addComponent(this.separatorPanel, -1, 22, Short.MAX_VALUE).addComponent(this.rightPanel, -1, 22, Short.MAX_VALUE));
    }

    private void evaluateButtonActionPerformed(ActionEvent evt) {
        this.evaluate();
    }

    public static void openEvaluator() {
        String selectedText = null;
        JEditorPane editor = EditorContextDispatcher.getDefault().getMostRecentEditor();
        if (editor != null) {
            selectedText = editor.getSelectedText();
        }
        CodeEvaluatorUI evaluator = CodeEvaluatorUI.getInstance();
        evaluator.open();
        if (selectedText != null) {
            evaluator.codePane.setText(selectedText);
            evaluator.codeText = selectedText;
        }
        evaluator.codePane.selectAll();
        evaluator.requestActive();
    }

    public boolean requestFocusInWindow() {
        this.codePane.requestFocusInWindow();
        return super.requestFocusInWindow();
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    public int getPersistenceType() {
        return 0;
    }

    public String getName() {
        return NbBundle.getMessage(CodeEvaluatorUI.class, (String)"CTL_Code_Evaluator_name");
    }

    public String getToolTipText() {
        return NbBundle.getMessage(CodeEvaluatorUI.class, (String)"CTL_Code_Evaluator_tooltip");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("EvaluateCode");
    }

    public String getExpression() {
        return this.codeText;
    }

    public void evaluate() {
        CodeEvaluator.EvaluatorService es = this.debuggerRef.get();
        if (es != null) {
            es.evaluate(this.codeText);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10 && e.isControlDown()) {
            e.consume();
            if (this.debuggerRef.get() != null) {
                this.evaluate();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateWatch();
        this.codeText = this.codePane.getText();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateWatch();
        this.codeText = this.codePane.getText();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateWatch();
        this.codeText = this.codePane.getText();
    }

    private void updateWatch() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeEvaluatorUI.this.computeEvaluationButtonState();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if ("canEvaluate".equals(propertyName)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodeEvaluator.EvaluatorService debugger = (CodeEvaluator.EvaluatorService)CodeEvaluatorUI.this.debuggerRef.get();
                    if (debugger != null && debugger.canEvaluate()) {
                        CodeEvaluatorUI.this.setupContext();
                    }
                    CodeEvaluatorUI.this.computeEvaluationButtonState();
                }
            });
        } else if ("expressionsHistory".equals(propertyName)) {
            this.recomputeDropDownItems();
        }
    }

    private synchronized TopComponent getResultViewInstance() {
        TopComponent instance = WindowManager.getDefault().findTopComponent("resultsView");
        return instance;
    }

    static {
        rp = new RequestProcessor("Debugger Evaluator", 1);
    }

    private static class DropDownButton
    extends JButton {
        private DropDownButton() {
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            super.processMouseEvent(me);
            if (this.isEnabled() && me.getID() == 501) {
                this.getAction().actionPerformed(new ActionEvent(this, 1001, "pressed"));
            }
        }

        protected String getTabActionCommand(ActionEvent e) {
            return null;
        }

        void performAction(ActionEvent e) {
        }
    }

    private class JEditorPaneWithHelp
    extends JEditorPane
    implements HelpCtx.Provider {
        private JEditorPaneWithHelp() {
        }

        public HelpCtx getHelpCtx() {
            return CodeEvaluatorUI.this.getHelpCtx();
        }
    }

    private class MenuItemActivatable
    implements SwitcherTableItem.Activatable {
        String text;

        MenuItemActivatable(String str) {
            this.text = str;
        }

        @Override
        public void activate() {
            CodeEvaluatorUI.this.codePane.setText(this.text);
            CodeEvaluatorUI.this.codeText = this.text;
        }
    }

    private static class DbgManagerListener
    extends DebuggerManagerAdapter {
        private final Reference<CodeEvaluatorUI> codeEvaluatorRef;

        public DbgManagerListener(CodeEvaluatorUI evaluator) {
            this.codeEvaluatorRef = new WeakReference<CodeEvaluatorUI>(evaluator);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            CodeEvaluatorUI evaluator = this.codeEvaluatorRef.get();
            if (evaluator != null) {
                evaluator.checkDebuggerState();
            }
        }
    }
}

