/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.modules.jshell.editor.Bundle;
import org.netbeans.modules.jshell.support.PersistentSnippets;
import org.netbeans.modules.jshell.support.PersistentSnippetsSupport;
import org.netbeans.modules.jshell.support.ShellSession;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.DropDownButtonFactory;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class RunScriptAction
extends TextAction
implements ContextAwareAction,
Presenter.Toolbar,
PopupMenuListener {
    public static final String ID = "jshell-select-run-saved-snippets";
    private static final String RESOURCE_ICON = "org/netbeans/modules/jshell/resources/run-scripts.png";
    private FileObject scriptFile;
    private Lookup context;
    private JTextComponent editor;
    private PersistentSnippets storage;
    private JPopupMenu popup;
    private JMenu subMenu;
    private boolean updatePopup;
    private L listen = new L();
    private Object weakListen;

    public RunScriptAction() {
        super(ID);
    }

    private RunScriptAction(Lookup context, JTextComponent editor, FileObject scriptOrFolder, String name, String description) {
        this();
        this.context = context;
        this.editor = editor;
        this.storage = PersistentSnippetsSupport.create(context);
        this.scriptFile = scriptOrFolder;
        this.putValue("Name", name);
        if (this.scriptFile == null) {
            this.putValue("ShortDescription", Bundle.DESC_RunSavedScript());
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)RESOURCE_ICON, (boolean)false));
        } else {
            this.putValue("ShortDescription", description);
        }
        if (this.storage == null) {
            this.setEnabled(false);
            return;
        }
        boolean enabled = true;
        if (scriptOrFolder == null || scriptOrFolder.isFolder()) {
            if (scriptOrFolder == null) {
                this.popup = new JPopupMenu(){

                    @Override
                    public int getComponentCount() {
                        RunScriptAction.this.refresh();
                        return super.getComponentCount();
                    }
                };
            } else {
                this.subMenu = new JMenu(){

                    @Override
                    public int getMenuComponentCount() {
                        RunScriptAction.this.refresh();
                        return super.getMenuComponentCount();
                    }
                };
                this.subMenu.setText(name);
                this.subMenu.setToolTipText(description);
            }
            if (this.storage.getSavedClasses(null).isEmpty()) {
                this.setEnabled(false);
            }
            this.invalidate();
            if (scriptOrFolder != null) {
                FileChangeListener fcl = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.listen, (Object)scriptOrFolder);
                scriptOrFolder.addFileChangeListener(fcl);
                this.weakListen = fcl;
            } else {
                ChangeListener cl = WeakListeners.change((ChangeListener)this.listen, (Object)this.storage);
                this.storage.addChangeListener(cl);
                this.weakListen = cl;
            }
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.refresh();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        RunScriptAction runScriptAction = this;
        synchronized (runScriptAction) {
            this.updatePopup = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        RunScriptAction runScriptAction = this;
        synchronized (runScriptAction) {
            this.updatePopup = true;
        }
        if (this.scriptFile != null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::refresh);
        } else {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void refresh() {
        void var4_8;
        RunScriptAction runScriptAction = this;
        synchronized (runScriptAction) {
            if (this.subMenu == null && this.popup == null || !this.updatePopup) {
                return;
            }
            this.updatePopup = false;
        }
        if (this.scriptFile != null && this.scriptFile.isData()) {
            return;
        }
        Collection<Object> scripts = new ArrayList<FileObject>();
        if (this.scriptFile == null) {
            scripts = this.storage.getSavedClasses(null);
        } else {
            scripts.addAll(Arrays.asList(this.scriptFile.getChildren()));
        }
        Component[] componentArray = (this.popup != null ? this.popup : this.subMenu).getComponents();
        int n = componentArray.length;
        boolean bl = false;
        while (var4_8 < n) {
            Action a;
            Component comp = componentArray[var4_8];
            if (comp instanceof JMenuItem && (a = ((JMenuItem)comp).getAction()) instanceof RunScriptAction) {
                ((RunScriptAction)a).dispose();
            }
            JComponent c = this.popup != null ? this.popup : this.subMenu;
            c.remove(comp);
            ++var4_8;
        }
        boolean nonEmpty = false;
        for (FileObject fileObject : scripts) {
            RunScriptAction ra;
            String name = fileObject.getName();
            String desc = this.storage.getDescription(fileObject);
            if (fileObject.isData()) {
                ra = new RunScriptAction(this.context, this.editor, fileObject, name, desc);
                if (this.popup != null) {
                    this.popup.add(ra);
                } else {
                    this.subMenu.add(ra);
                }
                nonEmpty = true;
                continue;
            }
            if (fileObject.getChildren().length <= 0 || fileObject.getPath().endsWith("startup")) continue;
            ra = new RunScriptAction(this.context, this.editor, fileObject, name, desc);
            JMenu subMenu = ra.subMenu;
            subMenu.setLabel(name);
            subMenu.setToolTipText(desc);
            if (this.popup != null) {
                this.popup.add(subMenu);
            } else {
                subMenu.add(subMenu);
            }
            nonEmpty = true;
        }
        this.setEnabled(nonEmpty);
    }

    void dispose() {
        if (this.scriptFile != null) {
            // empty if block
        }
        if (this.storage != null && this.scriptFile == null) {
            this.storage.removeChangeListener((ChangeListener)this.weakListen);
        } else if (this.scriptFile != null && this.scriptFile.isFolder()) {
            this.scriptFile.removeFileChangeListener((FileChangeListener)this.weakListen);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.context == null || this.editor == null || this.scriptFile == null) {
            return;
        }
        FileObject consoleFile = (FileObject)this.context.lookup(FileObject.class);
        if (consoleFile == null) {
            return;
        }
        ShellSession s = ShellSession.get(this.editor.getDocument());
        if (s == null) {
            return;
        }
        try {
            this.runScript(this.scriptFile, s);
        }
        catch (IOException ex) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.ERR_ExecutingScript(ex.getLocalizedMessage()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        JTextComponent c = RunScriptAction.findComponent(actionContext);
        return new RunScriptAction(actionContext, c, null, null, null);
    }

    public Component getToolbarPresenter() {
        if (this.popup != null) {
            JButton button = DropDownButtonFactory.createDropDownButton((Icon)((ImageIcon)this.getValue("SmallIcon")), (JPopupMenu)this.popup);
            button.putClientProperty("hideActionText", Boolean.TRUE);
            button.setAction(this);
            return button;
        }
        return new JButton(this);
    }

    static JTextComponent findComponent(Lookup lookup) {
        JEditorPane[] panes;
        EditorCookie ec = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (ec != null && (panes = ec.getOpenedPanes()) != null && panes.length > 0) {
            return panes[0];
        }
        return (JTextComponent)lookup.lookup(JTextComponent.class);
    }

    @Deprecated
    private void runScript(FileObject scriptFile, ShellSession session) throws IOException {
        PersistentSnippetsSupport.runScript(scriptFile, session, true);
    }

    static class SaveScriptAction
    extends TextAction {
        private final JTextComponent comp;
        private final Lookup context;
        private final PersistentSnippets storage;

        public SaveScriptAction(JTextComponent comp, Lookup context, PersistentSnippets storage) {
            super(Bundle.LBL_SaveSnippets());
            this.comp = comp;
            this.context = context;
            this.storage = storage;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class L
    extends FileChangeAdapter
    implements ChangeListener {
        L() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            RunScriptAction.this.invalidate();
        }

        public void fileRenamed(FileRenameEvent fe) {
            RunScriptAction.this.invalidate();
        }

        public void fileDeleted(FileEvent fe) {
            RunScriptAction.this.invalidate();
        }

        public void fileDataCreated(FileEvent fe) {
            RunScriptAction.this.invalidate();
        }

        public void fileFolderCreated(FileEvent fe) {
            RunScriptAction.this.invalidate();
        }
    }
}

