/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.runtime.interop.ScopeVariables;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ScopeVariables.class)
final class ScopeVariablesGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private ScopeVariablesGen() {
    }

    static {
        LibraryExport.register(ScopeVariables.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=ScopeVariables.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, ScopeVariables.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof ScopeVariables);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof ScopeVariables);
            return new Cached(receiver);
        }

        @GeneratedBy(value=ScopeVariables.class)
        private static final class Uncached
        extends InteropLibrary {
            Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof ScopeVariables) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ScopeVariables && Uncached.accepts_(receiver);
            }

            public boolean isAdoptable() {
                return false;
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                ScopeVariables arg0Value = (ScopeVariables)arg0Value_;
                if ("this".equals(arg1Value)) {
                    return ScopeVariables.IsMemberReadable.doReadThis(arg0Value, arg1Value);
                }
                if (!"this".equals(arg1Value)) {
                    return ScopeVariables.IsMemberReadable.doGeneric(arg0Value, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                ScopeVariables arg0Value = (ScopeVariables)arg0Value_;
                if ("this".equals(arg1Value)) {
                    return ScopeVariables.IsMemberModifiable.doReadThis(arg0Value, arg1Value);
                }
                if (!"this".equals(arg1Value)) {
                    return ScopeVariables.IsMemberModifiable.doGeneric(arg0Value, arg1Value);
                }
                throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                ScopeVariables arg0Value = (ScopeVariables)arg0Value_;
                if ("this".equals(arg1Value)) {
                    return ScopeVariables.ReadMember.doReadThis(arg0Value, arg1Value);
                }
                return ScopeVariables.ReadMember.doGeneric(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                ScopeVariables arg0Value = (ScopeVariables)arg0Value_;
                ScopeVariables.WriteMember.doGeneric(arg0Value, arg1Value, arg2Value);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isScope(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables)receiver).isScope();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables)receiver).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables)receiver).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasScopeParent(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables)receiver).hasScopeParent();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getScopeParent(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables)receiver).getScopeParent();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables)receiver).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables)receiver).getMembers(includeInternal);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables)receiver).isMemberInsertable(member);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasSourceLocation(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables)receiver).hasSourceLocation();
            }

            @CompilerDirectives.TruffleBoundary
            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables)receiver).getSourceLocation();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((ScopeVariables)receiver).toDisplayString(allowSideEffects);
            }

            @CompilerDirectives.TruffleBoundary
            private static boolean accepts_(Object arg0Value_) {
                ScopeVariables arg0Value = (ScopeVariables)arg0Value_;
                return arg0Value.accepts(arg0Value.blockOrRoot, arg0Value.nodeEnter);
            }
        }

        @GeneratedBy(value=ScopeVariables.class)
        private static final class Cached
        extends InteropLibrary {
            @CompilerDirectives.CompilationFinal
            private volatile int state_;
            @CompilerDirectives.CompilationFinal
            private volatile int exclude_;
            @CompilerDirectives.CompilationFinal
            private IsMemberReadableCachedData isMemberReadable_cached_cache;
            @CompilerDirectives.CompilationFinal
            private IsMemberModifiableCachedData isMemberModifiable_cached_cache;
            @Node.Child
            private ReadMemberCachedData readMember_cached_cache;
            @Node.Child
            private WriteMemberCachedData writeMember_cached_cache;
            @CompilerDirectives.CompilationFinal
            private Node acceptsNode__cachedNode_;
            @CompilerDirectives.CompilationFinal
            private boolean acceptsNode__cachedNodeEnter_;

            Cached(Object originalReceiver) {
                ScopeVariables receiver = (ScopeVariables)originalReceiver;
                this.acceptsNode__cachedNode_ = receiver.blockOrRoot;
                this.acceptsNode__cachedNodeEnter_ = receiver.nodeEnter;
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof ScopeVariables) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof ScopeVariables && this.accepts_(receiver);
            }

            @ExplodeLoop
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ScopeVariables arg0Value = (ScopeVariables)arg0Value_;
                int state = this.state_;
                if ((state & 7) != 0) {
                    if ((state & 1) != 0 && "this".equals(arg1Value)) {
                        return ScopeVariables.IsMemberReadable.doReadThis(arg0Value, arg1Value);
                    }
                    if ((state & 2) != 0) {
                        IsMemberReadableCachedData s2_ = this.isMemberReadable_cached_cache;
                        while (s2_ != null) {
                            if (s2_.cachedMember_.equals(arg1Value)) {
                                assert (!"this".equals(s2_.cachedMember_));
                                return ScopeVariables.IsMemberReadable.doCached(arg0Value, arg1Value, s2_.cachedMember_, s2_.cachedResult_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 4) != 0 && !"this".equals(arg1Value)) {
                        return ScopeVariables.IsMemberReadable.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableAndSpecialize(ScopeVariables arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    if ("this".equals(arg1Value)) {
                        this.state_ = state |= 1;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = ScopeVariables.IsMemberReadable.doReadThis(arg0Value, arg1Value);
                        return bl;
                    }
                    if ((exclude & 1) == 0) {
                        String cachedMember__;
                        int count2_ = 0;
                        IsMemberReadableCachedData s2_ = this.isMemberReadable_cached_cache;
                        if ((state & 2) != 0) {
                            while (s2_ != null) {
                                if (s2_.cachedMember_.equals(arg1Value)) {
                                    assert (!"this".equals(s2_.cachedMember_));
                                    break;
                                }
                                s2_ = s2_.next_;
                                ++count2_;
                            }
                        }
                        if (s2_ == null && !"this".equals(cachedMember__ = arg1Value) && count2_ < 4) {
                            s2_ = new IsMemberReadableCachedData(this.isMemberReadable_cached_cache);
                            s2_.cachedMember_ = cachedMember__;
                            s2_.cachedResult_ = ScopeVariables.IsMemberReadable.doGeneric(arg0Value, arg1Value);
                            this.isMemberReadable_cached_cache = s2_;
                            this.state_ = state |= 2;
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            boolean bl = ScopeVariables.IsMemberReadable.doCached(arg0Value, arg1Value, s2_.cachedMember_, s2_.cachedResult_);
                            return bl;
                        }
                    }
                    if (!"this".equals(arg1Value)) {
                        this.exclude_ = exclude |= 1;
                        this.isMemberReadable_cached_cache = null;
                        state &= 0xFFFFFFFD;
                        this.state_ = state |= 4;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = ScopeVariables.IsMemberReadable.doGeneric(arg0Value, arg1Value);
                        return bl;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public NodeCost getCost() {
                IsMemberReadableCachedData s2_;
                int state = this.state_;
                if ((state & 7) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state & 7 & (state & 7) - 1) == 0 && ((s2_ = this.isMemberReadable_cached_cache) == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @ExplodeLoop
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ScopeVariables arg0Value = (ScopeVariables)arg0Value_;
                int state = this.state_;
                if ((state & 0x38) != 0) {
                    if ((state & 8) != 0 && "this".equals(arg1Value)) {
                        return ScopeVariables.IsMemberModifiable.doReadThis(arg0Value, arg1Value);
                    }
                    if ((state & 0x10) != 0) {
                        IsMemberModifiableCachedData s2_ = this.isMemberModifiable_cached_cache;
                        while (s2_ != null) {
                            if (s2_.cachedMember_.equals(arg1Value)) {
                                assert (!"this".equals(s2_.cachedMember_));
                                return ScopeVariables.IsMemberModifiable.doCached(arg0Value, arg1Value, s2_.cachedMember_, s2_.cachedResult_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 0x20) != 0 && !"this".equals(arg1Value)) {
                        return ScopeVariables.IsMemberModifiable.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableAndSpecialize(ScopeVariables arg0Value, String arg1Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    if ("this".equals(arg1Value)) {
                        this.state_ = state |= 8;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = ScopeVariables.IsMemberModifiable.doReadThis(arg0Value, arg1Value);
                        return bl;
                    }
                    if ((exclude & 2) == 0) {
                        String cachedMember__;
                        int count2_ = 0;
                        IsMemberModifiableCachedData s2_ = this.isMemberModifiable_cached_cache;
                        if ((state & 0x10) != 0) {
                            while (s2_ != null) {
                                if (s2_.cachedMember_.equals(arg1Value)) {
                                    assert (!"this".equals(s2_.cachedMember_));
                                    break;
                                }
                                s2_ = s2_.next_;
                                ++count2_;
                            }
                        }
                        if (s2_ == null && !"this".equals(cachedMember__ = arg1Value) && count2_ < 4) {
                            s2_ = new IsMemberModifiableCachedData(this.isMemberModifiable_cached_cache);
                            s2_.cachedMember_ = cachedMember__;
                            s2_.cachedResult_ = ScopeVariables.IsMemberModifiable.doGeneric(arg0Value, arg1Value);
                            this.isMemberModifiable_cached_cache = s2_;
                            this.state_ = state |= 0x10;
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            boolean bl = ScopeVariables.IsMemberModifiable.doCached(arg0Value, arg1Value, s2_.cachedMember_, s2_.cachedResult_);
                            return bl;
                        }
                    }
                    if (!"this".equals(arg1Value)) {
                        this.exclude_ = exclude |= 2;
                        this.isMemberModifiable_cached_cache = null;
                        state &= 0xFFFFFFEF;
                        this.state_ = state |= 0x20;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = ScopeVariables.IsMemberModifiable.doGeneric(arg0Value, arg1Value);
                        return bl;
                    }
                    throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @ExplodeLoop
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ScopeVariables arg0Value = (ScopeVariables)arg0Value_;
                int state = this.state_;
                if ((state & 0x1C0) != 0) {
                    if ((state & 0x40) != 0 && "this".equals(arg1Value)) {
                        return ScopeVariables.ReadMember.doReadThis(arg0Value, arg1Value);
                    }
                    if ((state & 0x80) != 0) {
                        ReadMemberCachedData s2_ = this.readMember_cached_cache;
                        while (s2_ != null) {
                            if (s2_.cachedMember_.equals(arg1Value)) {
                                assert (!"this".equals(s2_.cachedMember_));
                                return ScopeVariables.ReadMember.doCached(arg0Value, arg1Value, s2_.cachedMember_, s2_.readNode_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state & 0x100) != 0) {
                        return ScopeVariables.ReadMember.doGeneric(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberAndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object readMemberAndSpecialize(ScopeVariables arg0Value, String arg1Value) throws UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    if ("this".equals(arg1Value)) {
                        this.state_ = state |= 0x40;
                        lock.unlock();
                        hasLock = false;
                        Object object = ScopeVariables.ReadMember.doReadThis(arg0Value, arg1Value);
                        return object;
                    }
                    if ((exclude & 4) == 0) {
                        String cachedMember__;
                        int count2_ = 0;
                        ReadMemberCachedData s2_ = this.readMember_cached_cache;
                        if ((state & 0x80) != 0) {
                            while (s2_ != null) {
                                if (s2_.cachedMember_.equals(arg1Value)) {
                                    assert (!"this".equals(s2_.cachedMember_));
                                    break;
                                }
                                s2_ = s2_.next_;
                                ++count2_;
                            }
                        }
                        if (s2_ == null && !"this".equals(cachedMember__ = arg1Value) && count2_ < 4) {
                            s2_ = (ReadMemberCachedData)super.insert((Node)new ReadMemberCachedData(this.readMember_cached_cache));
                            s2_.cachedMember_ = cachedMember__;
                            s2_.readNode_ = ScopeVariables.findReadNode(arg1Value, arg0Value.frame, arg0Value.blockOrRoot);
                            this.readMember_cached_cache = s2_;
                            this.state_ = state |= 0x80;
                        }
                        if (s2_ != null) {
                            lock.unlock();
                            hasLock = false;
                            Object object = ScopeVariables.ReadMember.doCached(arg0Value, arg1Value, s2_.cachedMember_, s2_.readNode_);
                            return object;
                        }
                    }
                    this.exclude_ = exclude |= 4;
                    this.readMember_cached_cache = null;
                    state &= 0xFFFFFF7F;
                    this.state_ = state |= 0x100;
                    lock.unlock();
                    hasLock = false;
                    Object object = ScopeVariables.ReadMember.doGeneric(arg0Value, arg1Value);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @ExplodeLoop
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                ScopeVariables arg0Value = (ScopeVariables)arg0Value_;
                int state = this.state_;
                if ((state & 0x600) != 0) {
                    if ((state & 0x200) != 0) {
                        WriteMemberCachedData s1_ = this.writeMember_cached_cache;
                        while (s1_ != null) {
                            if (s1_.cachedMember_.equals(arg1Value)) {
                                ScopeVariables.WriteMember.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedMember_, s1_.writeNode_);
                                return;
                            }
                            s1_ = s1_.next_;
                        }
                    }
                    if ((state & 0x400) != 0) {
                        ScopeVariables.WriteMember.doGeneric(arg0Value, arg1Value, arg2Value);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void writeMemberAndSpecialize(ScopeVariables arg0Value, String arg1Value, Object arg2Value) throws UnknownIdentifierException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state = this.state_;
                int exclude = this.exclude_;
                try {
                    if ((exclude & 8) == 0) {
                        int count1_ = 0;
                        WriteMemberCachedData s1_ = this.writeMember_cached_cache;
                        if ((state & 0x200) != 0) {
                            while (s1_ != null && !s1_.cachedMember_.equals(arg1Value)) {
                                s1_ = s1_.next_;
                                ++count1_;
                            }
                        }
                        if (s1_ == null && count1_ < 4) {
                            WriteNode writeNode___;
                            s1_ = (WriteMemberCachedData)super.insert((Node)new WriteMemberCachedData(this.writeMember_cached_cache));
                            s1_.cachedMember_ = arg1Value;
                            s1_.writeNode_ = writeNode___ = ScopeVariables.findWriteNode(arg1Value, arg0Value.frame, arg0Value.blockOrRoot);
                            this.writeMember_cached_cache = s1_;
                            this.state_ = state |= 0x200;
                        }
                        if (s1_ != null) {
                            lock.unlock();
                            hasLock = false;
                            ScopeVariables.WriteMember.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedMember_, s1_.writeNode_);
                            return;
                        }
                    }
                    this.exclude_ = exclude |= 8;
                    this.writeMember_cached_cache = null;
                    state &= 0xFFFFFDFF;
                    this.state_ = state |= 0x400;
                    lock.unlock();
                    hasLock = false;
                    ScopeVariables.WriteMember.doGeneric(arg0Value, arg1Value, arg2Value);
                    return;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            private boolean accepts_(Object arg0Value_) {
                ScopeVariables arg0Value = (ScopeVariables)arg0Value_;
                return arg0Value.accepts(this.acceptsNode__cachedNode_, this.acceptsNode__cachedNodeEnter_);
            }

            public boolean isScope(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ScopeVariables)receiver).isScope();
            }

            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ScopeVariables)receiver).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ScopeVariables)receiver).getLanguage();
            }

            public boolean hasScopeParent(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ScopeVariables)receiver).hasScopeParent();
            }

            public Object getScopeParent(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ScopeVariables)receiver).getScopeParent();
            }

            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ScopeVariables)receiver).hasMembers();
            }

            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ScopeVariables)receiver).getMembers(includeInternal);
            }

            public boolean isMemberInsertable(Object receiver, String member) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ScopeVariables)receiver).isMemberInsertable(member);
            }

            public boolean hasSourceLocation(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ScopeVariables)receiver).hasSourceLocation();
            }

            public SourceSection getSourceLocation(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ScopeVariables)receiver).getSourceLocation();
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((ScopeVariables)receiver).toDisplayString(allowSideEffects);
            }

            @GeneratedBy(value=ScopeVariables.class)
            private static final class WriteMemberCachedData
            extends Node {
                @Node.Child
                WriteMemberCachedData next_;
                @CompilerDirectives.CompilationFinal
                String cachedMember_;
                @CompilerDirectives.CompilationFinal
                WriteNode writeNode_;

                WriteMemberCachedData(WriteMemberCachedData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }

            @GeneratedBy(value=ScopeVariables.class)
            private static final class ReadMemberCachedData
            extends Node {
                @Node.Child
                ReadMemberCachedData next_;
                @CompilerDirectives.CompilationFinal
                String cachedMember_;
                @CompilerDirectives.CompilationFinal
                JavaScriptNode readNode_;

                ReadMemberCachedData(ReadMemberCachedData next_) {
                    this.next_ = next_;
                }

                public NodeCost getCost() {
                    return NodeCost.NONE;
                }
            }

            @GeneratedBy(value=ScopeVariables.class)
            private static final class IsMemberModifiableCachedData {
                @CompilerDirectives.CompilationFinal
                IsMemberModifiableCachedData next_;
                @CompilerDirectives.CompilationFinal
                String cachedMember_;
                @CompilerDirectives.CompilationFinal
                boolean cachedResult_;

                IsMemberModifiableCachedData(IsMemberModifiableCachedData next_) {
                    this.next_ = next_;
                }
            }

            @GeneratedBy(value=ScopeVariables.class)
            private static final class IsMemberReadableCachedData {
                @CompilerDirectives.CompilationFinal
                IsMemberReadableCachedData next_;
                @CompilerDirectives.CompilationFinal
                String cachedMember_;
                @CompilerDirectives.CompilationFinal
                boolean cachedResult_;

                IsMemberReadableCachedData(IsMemberReadableCachedData next_) {
                    this.next_ = next_;
                }
            }
        }
    }
}

