/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.j2seplatform.spi.J2SEPlatformDefaultJavadoc;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class J2SEPlatformDefaultJavadocImpl
implements J2SEPlatformDefaultJavadoc {
    private static final Logger LOG = Logger.getLogger(J2SEPlatformDefaultJavadocImpl.class.getName());
    private static final Map<String, String> OFFICIAL_JAVADOC = new HashMap<String, String>();

    @Override
    public Collection<URI> getDefaultJavadoc(@NonNull JavaPlatform platform) {
        String location;
        ArrayList<? extends URI> result = new ArrayList<URI>();
        JavadocFilter filter = new JavadocFilter();
        for (FileObject folder : platform.getInstallFolders()) {
            for (FileObject file : folder.getChildren()) {
                Collection<? extends URI> roots = filter.accept(file);
                result.addAll(roots);
            }
        }
        if (!result.isEmpty()) {
            return Collections.unmodifiableList(result);
        }
        String version = platform.getSpecification().getVersion().toString();
        if (!OFFICIAL_JAVADOC.containsKey(version)) {
            LOG.log(Level.WARNING, "unrecognized Java spec version: {0}", version);
        }
        if ((location = OFFICIAL_JAVADOC.get(version)) != null) {
            try {
                return Collections.singletonList(new URI(location));
            }
            catch (URISyntaxException x) {
                LOG.log(Level.INFO, null, x);
            }
        }
        return Collections.emptyList();
    }

    static {
        OFFICIAL_JAVADOC.put("1.0", null);
        OFFICIAL_JAVADOC.put("1.1", null);
        OFFICIAL_JAVADOC.put("1.2", null);
        OFFICIAL_JAVADOC.put("1.3", null);
        OFFICIAL_JAVADOC.put("1.4", null);
        OFFICIAL_JAVADOC.put("1.5", "https://docs.oracle.com/javase/1.5.0/docs/api/");
        OFFICIAL_JAVADOC.put("1.6", "https://docs.oracle.com/javase/6/docs/api/");
        OFFICIAL_JAVADOC.put("1.7", "https://docs.oracle.com/javase/7/docs/api/");
        OFFICIAL_JAVADOC.put("1.8", "https://docs.oracle.com/javase/8/docs/api/");
        OFFICIAL_JAVADOC.put("9", "https://docs.oracle.com/javase/9/docs/api/");
        OFFICIAL_JAVADOC.put("10", "https://docs.oracle.com/javase/10/docs/api/");
        OFFICIAL_JAVADOC.put("11", "https://docs.oracle.com/en/java/javase/11/docs/api/");
        OFFICIAL_JAVADOC.put("12", "https://docs.oracle.com/en/java/javase/12/docs/api/");
        OFFICIAL_JAVADOC.put("13", "https://docs.oracle.com/en/java/javase/13/docs/api/");
        OFFICIAL_JAVADOC.put("14", "https://docs.oracle.com/en/java/javase/14/docs/api/");
        OFFICIAL_JAVADOC.put("15", "https://docs.oracle.com/en/java/javase/15/docs/api/");
        OFFICIAL_JAVADOC.put("16", "https://docs.oracle.com/en/java/javase/16/docs/api/");
        OFFICIAL_JAVADOC.put("17", "https://download.java.net/java/early_access/jdk17/docs/api/");
        OFFICIAL_JAVADOC.put("18", "https://download.java.net/java/early_access/jdk18/docs/api/");
    }

    private static final class JavadocFilter {
        private static final Pattern DOCS_FILE_PATTERN = Pattern.compile(".*docs.*\\.(zip|jar)", 2);
        private static final Pattern JAVAFX_FILE_PATTERN = Pattern.compile(".*j(ava)?fx.*", 2);
        private static final Collection<String> DOCS_PATHS;
        private static final Map<String, String> VENDOR_DOCS;

        private JavadocFilter() {
        }

        @NonNull
        Collection<? extends URI> accept(@NonNull FileObject fo) {
            if (fo.canRead()) {
                if (fo.isFolder()) {
                    if ("docs".equals(fo.getName())) {
                        return Collections.singleton(fo.toURI());
                    }
                } else if (fo.isData()) {
                    FileObject root;
                    String nameExt = fo.getNameExt();
                    String vendorPath = VENDOR_DOCS.get(nameExt);
                    if (vendorPath != null) {
                        if (FileUtil.isArchiveFile((FileObject)fo)) {
                            try {
                                return Collections.singleton(new URL(FileUtil.getArchiveRoot((URL)fo.toURL()).toExternalForm() + vendorPath).toURI());
                            }
                            catch (MalformedURLException | URISyntaxException e) {
                                LOG.log(Level.INFO, "Invalid Javadoc URI for file : {0}, reason: {1}", new Object[]{FileUtil.getFileDisplayName((FileObject)fo), e.getMessage()});
                            }
                        }
                    } else if (DOCS_FILE_PATTERN.matcher(nameExt).matches() && !JAVAFX_FILE_PATTERN.matcher(nameExt).matches() && (root = FileUtil.getArchiveRoot((FileObject)fo)) != null) {
                        ArrayList<URI> roots = new ArrayList<URI>(DOCS_PATHS.size());
                        for (String path : DOCS_PATHS) {
                            FileObject docRoot = root.getFileObject(path);
                            if (docRoot == null) continue;
                            roots.add(docRoot.toURI());
                        }
                        return Collections.unmodifiableCollection(roots);
                    }
                }
            }
            return Collections.emptySet();
        }

        static {
            ArrayList<String> paths = new ArrayList<String>(3);
            paths.add("docs/api/");
            paths.add("docs/jdk/api/");
            paths.add("docs/jre/api/");
            DOCS_PATHS = Collections.unmodifiableList(paths);
            HashMap<String, String> docs = new HashMap<String, String>();
            docs.put("appledocs.jar", "appledoc/api/");
            VENDOR_DOCS = Collections.unmodifiableMap(docs);
        }
    }
}

