/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.timers;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import org.netbeans.modules.timers.TimeComponentPanel;
import org.openide.ErrorManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class TimeComponent
extends TopComponent {
    private static final String PREFERRED_ID = "timers";
    static final String ICON_PATH = "org/netbeans/modules/timers/resources/timer.png";
    private static TimeComponent INSTANCE;

    public TimeComponent() {
        this.setName(PREFERRED_ID);
        this.setDisplayName(NbBundle.getMessage(TimeComponent.class, (String)"LBL_TimeComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(new TimeComponentPanel(), gridBagConstraints);
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public int getPersistenceType() {
        return 0;
    }

    public static synchronized TimeComponent getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new TimeComponent();
        }
        return INSTANCE;
    }

    public static synchronized TimeComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find TimeComponent component. It will not be located properly in the window system.");
            return TimeComponent.getDefault();
        }
        if (win instanceof TimeComponent) {
            return (TimeComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'timers' ID. That is a potential source of errors and unexpected behavior.");
        return TimeComponent.getDefault();
    }
}

