/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring.rename;

import java.text.MessageFormat;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.jpa.refactoring.PersistenceXmlRefactoring;
import org.netbeans.modules.j2ee.jpa.refactoring.RefactoringUtil;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class PersistenceXmlRename
extends PersistenceXmlRefactoring {
    private final RenameRefactoring renameRefactoring;

    public PersistenceXmlRename(RenameRefactoring rename) {
        this.renameRefactoring = rename;
    }

    @Override
    protected AbstractRefactoring getRefactoring() {
        return this.renameRefactoring;
    }

    @Override
    protected RefactoringElementImplementation getRefactoringElement(PersistenceUnit persistenceUnit, FileObject clazz, PUDataObject pUDataObject, FileObject persistenceXml) {
        String clazzFqn = JavaIdentifiers.getQualifiedName((FileObject)clazz);
        String newName = RefactoringUtil.renameClass(clazzFqn, this.renameRefactoring.getNewName());
        return new PersistenceXmlClassRenameRefactoringElement(persistenceUnit, clazzFqn, newName, pUDataObject, persistenceXml);
    }

    private static class PersistenceXmlClassRenameRefactoringElement
    extends PersistenceXmlRefactoring.PersistenceXmlRefactoringElement {
        private final String newName;

        public PersistenceXmlClassRenameRefactoringElement(PersistenceUnit persistenceUnit, String oldName, String newName, PUDataObject puDataObject, FileObject parentFile) {
            super(persistenceUnit, oldName, puDataObject, parentFile);
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.clazz, this.newName};
            return MessageFormat.format(NbBundle.getMessage(PersistenceXmlRename.class, (String)"TXT_PersistenceXmlRename"), args);
        }

        public void undoChange() {
            ProviderUtil.renameManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.clazz, (String)this.newName, (PUDataObject)this.puDataObject);
        }

        public void performChange() {
            ProviderUtil.renameManagedClass((PersistenceUnit)this.persistenceUnit, (String)this.newName, (String)this.clazz, (PUDataObject)this.puDataObject);
        }
    }
}

