/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.ArrayLiteralNode;
import com.oracle.truffle.js.nodes.access.GetTemplateObjectNodeGen;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import java.util.Set;

public abstract class GetTemplateObjectNode
extends JavaScriptNode {
    protected final JSContext context;
    @Node.Child
    private ArrayLiteralNode rawStrings;
    @Node.Child
    private ArrayLiteralNode cookedStrings;
    private final Object identity;

    protected GetTemplateObjectNode(JSContext context, ArrayLiteralNode rawStrings, ArrayLiteralNode cookedStrings) {
        this.context = context;
        this.rawStrings = rawStrings;
        this.cookedStrings = cookedStrings;
        this.identity = this;
    }

    protected GetTemplateObjectNode(JSContext context, ArrayLiteralNode rawStrings, ArrayLiteralNode cookedStrings, Object identity) {
        this.context = context;
        this.rawStrings = rawStrings;
        this.cookedStrings = cookedStrings;
        this.identity = identity;
    }

    public static GetTemplateObjectNode create(JSContext context, ArrayLiteralNode rawStrings, ArrayLiteralNode cookedStrings) {
        return GetTemplateObjectNodeGen.create(context, rawStrings, cookedStrings);
    }

    @Specialization(guards={"!context.isMultiContext()"}, assumptions={"context.getSingleRealmAssumption()"})
    protected DynamicObject doCached(VirtualFrame frame, @Cached(value="doUncached(frame)") DynamicObject cachedTemplate) {
        return cachedTemplate;
    }

    @Specialization(replaces={"doCached"})
    protected DynamicObject doUncached(VirtualFrame frame) {
        DynamicObject cached = Boundaries.mapGet(this.context.getRealm().getTemplateRegistry(), this.identity);
        if (cached != null) {
            return cached;
        }
        cached = this.buildTemplateObject(frame);
        Boundaries.mapPut(this.context.getRealm().getTemplateRegistry(), this.identity, cached);
        return cached;
    }

    private DynamicObject buildTemplateObject(VirtualFrame frame) {
        DynamicObject template = this.cookedStrings.execute(frame);
        DynamicObject rawObj = this.rawStrings.execute(frame);
        JSObject.setIntegrityLevel(rawObj, true);
        JSObjectUtil.putDataProperty(this.context, template, "raw", rawObj, JSAttributes.notConfigurableNotEnumerableNotWritable());
        JSObject.setIntegrityLevel(template, true);
        return template;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return GetTemplateObjectNodeGen.create(this.context, GetTemplateObjectNode.cloneUninitialized(this.rawStrings, materializedTags), GetTemplateObjectNode.cloneUninitialized(this.cookedStrings, materializedTags), this.identity);
    }
}

