/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import javax.swing.Action;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.SourcePath;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingActionsProvider;
import org.netbeans.modules.debugger.jpda.ui.models.MonitorModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ThreadsActionsProvider
implements NodeActionsProvider {
    private Action SUSPEND_ACTION;
    private Action RESUME_ACTION;
    private Action INTERRUPT_ACTION;
    private Action GO_TO_SOURCE_ACTION;
    private Action MAKE_CURRENT_ACTION = Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_ThreadAction_MakeCurrent_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            if (node instanceof MonitorModel.ThreadWithBordel) {
                node = ((MonitorModel.ThreadWithBordel)node).getOriginalThread();
            }
            return ThreadsActionsProvider.this.debugger.getCurrentThread() != node;
        }

        public void perform(Object[] nodes) {
            if (nodes[0] instanceof MonitorModel.ThreadWithBordel) {
                nodes[0] = ((MonitorModel.ThreadWithBordel)nodes[0]).getOriginalThread();
            }
            ((JPDAThread)nodes[0]).makeCurrent();
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private JPDADebugger debugger;

    private static Action createGO_TO_SOURCE_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_ThreadAction_GoToSource_Label"), (Models.ActionPerformer)new DebuggingActionsProvider.LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof MonitorModel.ThreadWithBordel) {
                    node = ((MonitorModel.ThreadWithBordel)node).getOriginalThread();
                }
                return ThreadsActionsProvider.isGoToSourceSupported((JPDAThread)node);
            }

            @Override
            public void run(Object[] nodes) {
                if (nodes[0] instanceof MonitorModel.ThreadWithBordel) {
                    nodes[0] = ((MonitorModel.ThreadWithBordel)nodes[0]).getOriginalThread();
                }
                String language = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
                SourcePath sp = (SourcePath)DebuggerManager.getDebuggerManager().getCurrentEngine().lookupFirst(null, SourcePath.class);
                sp.showSource((JPDAThread)nodes[0], language);
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    private Action createSUSPEND_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_ThreadAction_Suspend_Label"), (Models.ActionPerformer)new DebuggingActionsProvider.LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof MonitorModel.ThreadWithBordel) {
                    node = ((MonitorModel.ThreadWithBordel)node).getOriginalThread();
                }
                if (node instanceof JPDAThread) {
                    return !((JPDAThread)node).isSuspended();
                }
                return true;
            }

            @Override
            public void run(Object[] nodes) {
                int k = nodes.length;
                for (int i = 0; i < k; ++i) {
                    Object node;
                    Object object = node = nodes[i] instanceof MonitorModel.ThreadWithBordel ? ((MonitorModel.ThreadWithBordel)nodes[i]).getOriginalThread() : nodes[i];
                    if (node instanceof JPDAThread) {
                        ((JPDAThread)node).suspend();
                        continue;
                    }
                    ((JPDAThreadGroup)node).suspend();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
    }

    private Action createRESUME_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_ThreadAction_Resume_Label"), (Models.ActionPerformer)new DebuggingActionsProvider.LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof MonitorModel.ThreadWithBordel) {
                    node = ((MonitorModel.ThreadWithBordel)node).getOriginalThread();
                }
                if (node instanceof JPDAThread) {
                    return ((JPDAThread)node).isSuspended();
                }
                return true;
            }

            @Override
            public void run(Object[] nodes) {
                int k = nodes.length;
                for (int i = 0; i < k; ++i) {
                    Object node;
                    Object object = node = nodes[i] instanceof MonitorModel.ThreadWithBordel ? ((MonitorModel.ThreadWithBordel)nodes[i]).getOriginalThread() : nodes[i];
                    if (node instanceof JPDAThread) {
                        ((JPDAThread)node).resume();
                        continue;
                    }
                    ((JPDAThreadGroup)node).resume();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
    }

    private Action createINTERRUPT_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)NbBundle.getBundle(ThreadsActionsProvider.class).getString("CTL_ThreadAction_Interrupt_Label"), (Models.ActionPerformer)new DebuggingActionsProvider.LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof MonitorModel.ThreadWithBordel) {
                    node = ((MonitorModel.ThreadWithBordel)node).getOriginalThread();
                }
                if (node instanceof JPDAThread) {
                    return !((JPDAThread)node).isSuspended();
                }
                return false;
            }

            @Override
            public void run(Object[] nodes) {
                int k = nodes.length;
                for (int i = 0; i < k; ++i) {
                    Object node;
                    Object object = node = nodes[i] instanceof MonitorModel.ThreadWithBordel ? ((MonitorModel.ThreadWithBordel)nodes[i]).getOriginalThread() : nodes[i];
                    if (!(node instanceof JPDAThread)) continue;
                    ((JPDAThread)node).interrupt();
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
    }

    public ThreadsActionsProvider(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        RequestProcessor requestProcessor = (RequestProcessor)lookupProvider.lookupFirst(null, RequestProcessor.class);
        this.SUSPEND_ACTION = this.createSUSPEND_ACTION(requestProcessor);
        this.RESUME_ACTION = this.createRESUME_ACTION(requestProcessor);
        this.INTERRUPT_ACTION = this.createINTERRUPT_ACTION(requestProcessor);
        this.GO_TO_SOURCE_ACTION = ThreadsActionsProvider.createGO_TO_SOURCE_ACTION(requestProcessor);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return new Action[0];
        }
        if (node instanceof JPDAThreadGroup) {
            return new Action[]{this.RESUME_ACTION, this.SUSPEND_ACTION};
        }
        if (node instanceof JPDAThread) {
            JPDAThread t = (JPDAThread)node;
            boolean suspended = t.isSuspended();
            Action a = null;
            a = suspended ? this.RESUME_ACTION : this.SUSPEND_ACTION;
            return new Action[]{this.MAKE_CURRENT_ACTION, a, this.INTERRUPT_ACTION, this.GO_TO_SOURCE_ACTION};
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (!(node instanceof JPDAThread)) {
            if (node instanceof JPDAThreadGroup) {
                return;
            }
            throw new UnknownTypeException(node);
        }
        ((JPDAThread)node).makeCurrent();
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private static boolean isGoToSourceSupported(JPDAThread t) {
        return t.isSuspended();
    }
}

