/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.composer.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.composer.commands.Composer;
import org.netbeans.modules.php.composer.ui.options.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ComposerOptionsPanel
extends JPanel {
    private static final String COMPOSER_LAST_FOLDER_SUFFIX = ".composer";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel authorEmailLabel;
    private JTextField authorEmailTextField;
    private JLabel authorNameLabel;
    private JTextField authorNameTextField;
    private JButton browseButton;
    private JLabel composerLabel;
    private JTextField composerTextField;
    private JLabel errorLabel;
    private JLabel hintLabel;
    private JCheckBox ignoreVendorCheckBox;
    private JLabel installationInstructionsLabel;
    private JLabel learnMoreLabel;
    private JLabel noteLabel;
    private JButton searchButton;
    private JLabel vendorLabel;
    private JTextField vendorTextField;

    public ComposerOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        this.hintLabel.setText(Bundle.ComposerOptionsPanel_composer_hint(Composer.COMPOSER_FILENAMES.get(0), Composer.COMPOSER_FILENAMES.get(1)));
        this.errorLabel.setText(" ");
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.composerTextField.getDocument().addDocumentListener(documentListener);
        this.vendorTextField.getDocument().addDocumentListener(documentListener);
        this.authorNameTextField.getDocument().addDocumentListener(documentListener);
        this.authorEmailTextField.getDocument().addDocumentListener(documentListener);
        this.ignoreVendorCheckBox.addItemListener(new DefaultItemListener());
    }

    public String getComposerPath() {
        return this.composerTextField.getText();
    }

    public void setComposerPath(String composerPath) {
        this.composerTextField.setText(composerPath);
    }

    public String getVendor() {
        return this.vendorTextField.getText();
    }

    public void setVendor(String vendor) {
        this.vendorTextField.setText(vendor);
    }

    public String getAuthorName() {
        return this.authorNameTextField.getText();
    }

    public void setAuthorName(String authorName) {
        this.authorNameTextField.setText(authorName);
    }

    public String getAuthorEmail() {
        return this.authorEmailTextField.getText();
    }

    public void setAuthorEmail(String authorEmail) {
        this.authorEmailTextField.setText(authorEmail);
    }

    public boolean isIgnoreVendor() {
        return this.ignoreVendorCheckBox.isSelected();
    }

    public void setIgnoreVendor(boolean ignoreVendor) {
        this.ignoreVendorCheckBox.setSelected(ignoreVendor);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.composerLabel = new JLabel();
        this.composerTextField = new JTextField();
        this.browseButton = new JButton();
        this.searchButton = new JButton();
        this.hintLabel = new JLabel();
        this.vendorLabel = new JLabel();
        this.vendorTextField = new JTextField();
        this.authorNameLabel = new JLabel();
        this.authorNameTextField = new JTextField();
        this.authorEmailLabel = new JLabel();
        this.authorEmailTextField = new JTextField();
        this.ignoreVendorCheckBox = new JCheckBox();
        this.noteLabel = new JLabel();
        this.installationInstructionsLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.errorLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.composerLabel, (String)NbBundle.getMessage(ComposerOptionsPanel.class, (String)"ComposerOptionsPanel.composerLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ComposerOptionsPanel.class, (String)"ComposerOptionsPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComposerOptionsPanel.this.browseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchButton, (String)NbBundle.getMessage(ComposerOptionsPanel.class, (String)"ComposerOptionsPanel.searchButton.text"));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComposerOptionsPanel.this.searchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.hintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.vendorLabel, (String)NbBundle.getMessage(ComposerOptionsPanel.class, (String)"ComposerOptionsPanel.vendorLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.authorNameLabel, (String)NbBundle.getMessage(ComposerOptionsPanel.class, (String)"ComposerOptionsPanel.authorNameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.authorEmailLabel, (String)NbBundle.getMessage(ComposerOptionsPanel.class, (String)"ComposerOptionsPanel.authorEmailLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.ignoreVendorCheckBox, (String)NbBundle.getMessage(ComposerOptionsPanel.class, (String)"ComposerOptionsPanel.ignoreVendorCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(ComposerOptionsPanel.class, (String)"ComposerOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.installationInstructionsLabel, (String)NbBundle.getMessage(ComposerOptionsPanel.class, (String)"ComposerOptionsPanel.installationInstructionsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.learnMoreLabel, (String)NbBundle.getMessage(ComposerOptionsPanel.class, (String)"ComposerOptionsPanel.learnMoreLabel.text"));
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ComposerOptionsPanel.this.learnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                ComposerOptionsPanel.this.learnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteLabel, -2, -1, -2).addComponent(this.errorLabel).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.installationInstructionsLabel).addComponent(this.learnMoreLabel, -2, -1, -2))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.composerLabel).addComponent(this.authorNameLabel).addComponent(this.authorEmailLabel).addComponent(this.vendorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hintLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.vendorTextField, GroupLayout.Alignment.LEADING).addComponent(this.authorEmailTextField, GroupLayout.Alignment.LEADING, -1, 145, Short.MAX_VALUE).addComponent(this.composerTextField, GroupLayout.Alignment.LEADING).addComponent(this.authorNameTextField, GroupLayout.Alignment.LEADING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton))))).addGroup(layout.createSequentialGroup().addComponent(this.ignoreVendorCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.composerTextField, -2, -1, -2).addComponent(this.composerLabel).addComponent(this.searchButton).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.vendorTextField, -2, -1, -2).addComponent(this.vendorLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.authorNameTextField, -2, -1, -2).addComponent(this.authorNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.authorEmailTextField, -2, -1, -2).addComponent(this.authorEmailLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ignoreVendorCheckBox).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installationInstructionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.learnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File composer = new FileChooserBuilder(ComposerOptionsPanel.class.getName() + COMPOSER_LAST_FOLDER_SUFFIX).setTitle(Bundle.ComposerOptionsPanel_browse_title()).setFilesOnly(true).showOpenDialog();
        if (composer != null) {
            composer = FileUtil.normalizeFile((File)composer);
            this.composerTextField.setText(composer.getAbsolutePath());
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        String script = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String[])Composer.COMPOSER_FILENAMES.toArray(new String[0]));
            }

            public String getWindowTitle() {
                return Bundle.ComposerOptionsPanel_search_scripts_title();
            }

            public String getListTitle() {
                return Bundle.ComposerOptionsPanel_search_scripts();
            }

            public String getPleaseWaitPart() {
                return Bundle.ComposerOptionsPanel_search_scripts_pleaseWaitPart();
            }

            public String getNoItemsFound() {
                return Bundle.ComposerOptionsPanel_search_scripts_notFound();
            }
        });
        if (script != null) {
            this.composerTextField.setText(script);
        }
    }

    private void learnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void learnMoreLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://getcomposer.org/doc/00-intro.md#installation"));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ComposerOptionsPanel.this.fireChange();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            ComposerOptionsPanel.this.fireChange();
        }
    }
}

