/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.Attributed;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class LambdaFunctionDeclaration
extends Expression
implements Attributed {
    private final boolean isReference;
    private final boolean isStatic;
    private final List<FormalParameter> formalParameters = new ArrayList<FormalParameter>();
    @NullAllowed
    private final Expression returnType;
    private final List<Expression> lexicalVariables = new ArrayList<Expression>();
    private final Block body;
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public LambdaFunctionDeclaration(int start, int end, List formalParameters, Expression returnType, List lexicalVars, Block body, boolean isReference, boolean isStatic) {
        this(start, end, formalParameters, returnType, lexicalVars, body, isReference, isStatic, Collections.emptyList());
    }

    private LambdaFunctionDeclaration(int start, int end, List<FormalParameter> formalParameters, Expression returnType, List<Expression> lexicalVars, Block body, boolean isReference, boolean isStatic, List<Attribute> attributes) {
        super(start, end);
        this.attributes.addAll(attributes);
        if (formalParameters == null) {
            throw new IllegalArgumentException();
        }
        this.isReference = isReference;
        this.isStatic = isStatic;
        this.formalParameters.addAll(formalParameters);
        this.returnType = returnType;
        if (lexicalVars != null) {
            this.lexicalVariables.addAll(lexicalVars);
        }
        this.body = body;
    }

    public static LambdaFunctionDeclaration create(LambdaFunctionDeclaration declaration, List<Attribute> attributes) {
        assert (attributes != null);
        int start = attributes.isEmpty() ? declaration.getStartOffset() : attributes.get(0).getStartOffset();
        return new LambdaFunctionDeclaration(start, declaration.getEndOffset(), declaration.getFormalParameters(), declaration.getReturnType(), declaration.getLexicalVariables(), declaration.getBody(), declaration.isReference(), declaration.isStatic(), attributes);
    }

    public Block getBody() {
        return this.body;
    }

    public List<FormalParameter> getFormalParameters() {
        return Collections.unmodifiableList(this.formalParameters);
    }

    @CheckForNull
    public Expression getReturnType() {
        return this.returnType;
    }

    public List<Expression> getLexicalVariables() {
        return Collections.unmodifiableList(this.lexicalVariables);
    }

    public boolean isReference() {
        return this.isReference;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public synchronized void addAttributes(List<Attribute> attributes) {
        this.attributes.addAll(attributes);
    }

    @Override
    public synchronized List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public boolean isAttributed() {
        return !this.attributes.isEmpty();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sbAttributes = new StringBuilder();
        this.getAttributes().forEach(attribute -> sbAttributes.append(attribute).append(" "));
        StringBuilder sbParams = new StringBuilder();
        for (FormalParameter formalParameter : this.getFormalParameters()) {
            sbParams.append(formalParameter).append(",");
        }
        StringBuilder sbLex = new StringBuilder();
        for (Expression expression : this.getLexicalVariables()) {
            sbLex.append(expression).append(",");
        }
        return sbAttributes.toString() + (this.isStatic() ? "static " : "") + "function" + (this.isReference() ? " & " : "") + "(" + sbParams.toString() + ")" + (sbLex.length() > 0 ? " use (" + sbLex.toString() + ")" : "") + (this.getReturnType() != null ? ": " + this.getReturnType() : "") + this.getBody();
    }
}

