/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.ui;

import java.text.MessageFormat;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.groovy.refactoring.findusages.model.RefactoringElement;
import org.netbeans.modules.groovy.refactoring.findusages.model.VariableRefactoringElement;
import org.netbeans.modules.groovy.refactoring.ui.WhereUsedPanel;
import org.netbeans.modules.groovy.refactoring.utils.GroovyProjectUtil;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WhereUsedQueryUI
implements RefactoringUI {
    private final RefactoringElement element;
    private final WhereUsedQuery query;
    private final ElementKind kind;
    private final String name;
    private WhereUsedPanel panel;

    public WhereUsedQueryUI(RefactoringElement element) {
        this.query = new WhereUsedQuery(Lookups.singleton((Object)element));
        this.query.getContext().add((Object)GroovyProjectUtil.getClasspathInfoFor(element.getFileObject()));
        this.element = element;
        this.name = this.getElementName();
        this.kind = element.getKind();
    }

    private String getElementName() {
        if (this.element instanceof VariableRefactoringElement) {
            return ((VariableRefactoringElement)this.element).getVariableName();
        }
        return this.element.getName();
    }

    public boolean isQuery() {
        return true;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = WhereUsedPanel.create(this.element, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.query.putValue((Object)"SEARCH_IN_COMMENTS", (Object)this.panel.isSearchInComments());
        if (this.kind == ElementKind.METHOD) {
            this.setForMethod();
            return this.query.checkParameters();
        }
        if (this.kind == ElementKind.MODULE || this.kind == ElementKind.CLASS || this.kind == ElementKind.INTERFACE) {
            this.setForClass();
            return this.query.checkParameters();
        }
        return null;
    }

    private void setForMethod() {
        this.query.getContext().add((Object)this.element);
        this.query.setRefactoringSource(Lookups.singleton((Object)this.element));
        this.query.putValue((Object)WhereUsedQueryConstants.SEARCH_FROM_BASECLASS, (Object)this.panel.isMethodFromBaseClass());
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)this.panel.isMethodOverriders());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isMethodFindUsages());
    }

    private void setForClass() {
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES, (Object)this.panel.isClassSubTypes());
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES, (Object)this.panel.isClassSubTypesDirectOnly());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isClassFindUsages());
    }

    public Problem checkParameters() {
        if (this.kind == ElementKind.METHOD) {
            return this.query.fastCheckParameters();
        }
        if (this.kind == ElementKind.MODULE || this.kind == ElementKind.CLASS || this.kind == ElementKind.INTERFACE) {
            return this.query.fastCheckParameters();
        }
        return null;
    }

    public AbstractRefactoring getRefactoring() {
        return this.query;
    }

    public String getDescription() {
        String desc = null;
        if (this.panel != null && this.kind != null) {
            switch (this.kind) {
                case CONSTRUCTOR: {
                    if (this.panel.isMethodFindUsages() && this.panel.isMethodOverriders()) {
                        desc = this.getString("DSC_WhereUsedAndOverriders", this.name);
                        break;
                    }
                    if (this.panel.isMethodFindUsages()) {
                        desc = this.getString("DSC_WhereUsed", this.name);
                        break;
                    }
                    if (!this.panel.isMethodOverriders()) break;
                    desc = this.getString("DSC_WhereUsedMethodOverriders", this.name);
                    break;
                }
                case METHOD: {
                    if (this.panel.isMethodFindUsages() && this.panel.isMethodOverriders()) {
                        desc = this.getString("DSC_WhereUsedFindUsagesAndMethodOverriders", this.element.getOwnerNameWithoutPackage(), this.element.getName());
                        break;
                    }
                    if (this.panel.isMethodFindUsages()) {
                        desc = this.getString("DSC_WhereUsedFindUsages", this.element.getOwnerNameWithoutPackage(), this.element.getName());
                        break;
                    }
                    if (!this.panel.isMethodOverriders()) break;
                    desc = this.getString("DSC_WhereUsedMethodOverriders", this.element.getOwnerNameWithoutPackage(), this.element.getName());
                    break;
                }
                case MODULE: 
                case CLASS: 
                case INTERFACE: {
                    if (this.panel.isClassFindUsages()) break;
                    if (!this.panel.isClassSubTypesDirectOnly()) {
                        desc = this.getString("DSC_WhereUsedFindAllSubTypes", this.name);
                        break;
                    }
                    desc = this.getString("DSC_WhereUsedFindDirectSubTypes", this.name);
                    break;
                }
                case PACKAGE: {
                    break;
                }
            }
        }
        if (desc == null) {
            desc = this.getString("DSC_WhereUsed", this.name);
        }
        return desc;
    }

    private String getString(String key, String ... values) {
        return new MessageFormat(NbBundle.getMessage(WhereUsedQueryUI.class, (String)key)).format(values);
    }

    public String getName() {
        return this.getString("DSC_WhereUsed", this.name);
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.groovy.refactoring.ui.WhereUsedQueryUI");
    }
}

