/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.parser;

import java.util.Collections;
import java.util.List;

public abstract class JspSyntaxElement {
    private CharSequence source;
    private int from;
    private int to;

    public JspSyntaxElement(CharSequence source, int from, int to) {
        this.source = source;
        this.from = from;
        this.to = to;
    }

    public int from() {
        return this.from;
    }

    public int to() {
        return this.to;
    }

    public CharSequence text() {
        return this.source.subSequence(this.from, this.to);
    }

    public String toString() {
        return "JspSyntaxElement[" + this.from() + " - " + this.to() + ", " + (Object)((Object)this.kind()) + "]";
    }

    public abstract Kind kind();

    public static class Attribute {
        private String name;
        private String value;
        private int nameOffset;
        private int valueOffset;
        private int valueLength;

        Attribute(String name, String value, int nameOffset, int valueOffset, int valueLength) {
            this.name = name;
            this.value = value;
            this.nameOffset = nameOffset;
            this.valueOffset = valueOffset;
            this.valueLength = valueLength;
        }

        public String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public int getValueLength() {
            return this.valueLength;
        }

        void setValue(String value) {
            this.value = value;
        }

        public int getNameOffset() {
            return this.nameOffset;
        }

        void setNameOffset(int ofs) {
            this.nameOffset = ofs;
        }

        public int getValueOffset() {
            return this.valueOffset;
        }

        void setValueOffset(int ofs) {
            this.valueOffset = ofs;
        }

        public String toString() {
            return "TagAttribute[name=" + this.getName() + "; value=" + this.getValue() + "; nameOffset=" + this.getNameOffset() + "; valueOffset=" + this.getValueOffset() + "]";
        }

        public boolean equals(Object o) {
            if (!(o instanceof Attribute)) {
                return false;
            }
            return this.getName().equals(((Attribute)o).getName());
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }
    }

    public static class Directive
    extends AttributedTagLikeElement {
        public Directive(CharSequence source, int from, int length, String name, List<Attribute> attribs) {
            super(source, from, length, name, attribs);
        }

        @Override
        public Kind kind() {
            return Kind.DIRECTIVE;
        }
    }

    public static class OpenTag
    extends Tag {
        public OpenTag(CharSequence source, int from, int length, String name, List<Attribute> attribs, boolean isEmpty) {
            super(source, from, length, name, attribs, isEmpty);
        }

        @Override
        public Kind kind() {
            return Kind.OPENTAG;
        }
    }

    public static abstract class Tag
    extends AttributedTagLikeElement {
        private boolean empty;

        public Tag(CharSequence source, int from, int length, String name, List attribs, boolean isEmpty) {
            super(source, from, length, name, attribs);
            this.empty = isEmpty;
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }

    public static abstract class AttributedTagLikeElement
    extends Named {
        private List<Attribute> attribs;

        public AttributedTagLikeElement(CharSequence source, int from, int length, String name, List attribs) {
            super(source, from, length, name);
            this.attribs = attribs;
        }

        public List<Attribute> attributes() {
            return this.attribs == null ? Collections.EMPTY_LIST : this.attribs;
        }

        public Attribute getAttribute(String name) {
            return this.getAttribute(name, true);
        }

        public Attribute getAttribute(String name, boolean ignoreCase) {
            for (Attribute ta : this.attributes()) {
                if (!ta.getName().equals(name)) continue;
                return ta;
            }
            return null;
        }
    }

    public static class EndTag
    extends Named {
        public EndTag(CharSequence source, int from, int to, String name) {
            super(source, from, to, name);
        }

        @Override
        public Kind kind() {
            return Kind.ENDTAG;
        }
    }

    public static abstract class Named
    extends JspSyntaxElement {
        protected String name;

        public Named(CharSequence source, int from, int to, String name) {
            super(source, from, to);
            this.name = name;
        }

        public String name() {
            return this.name;
        }
    }

    public static class Error
    extends JspSyntaxElement {
        public Error(CharSequence source, int from, int to) {
            super(source, from, to);
        }

        @Override
        public Kind kind() {
            return Kind.ERROR;
        }
    }

    public static class Scripting
    extends JspSyntaxElement {
        public Scripting(CharSequence source, int from, int to) {
            super(source, from, to);
        }

        @Override
        public Kind kind() {
            return Kind.SCRIPTING;
        }
    }

    public static class SharedTextElement
    extends JspSyntaxElement {
        private static final String TO_STRING = "<n/a>";

        public SharedTextElement() {
            super(null, 0, 0);
        }

        @Override
        public CharSequence text() {
            return TO_STRING;
        }

        @Override
        public Kind kind() {
            return Kind.TEXT;
        }

        @Override
        public int from() {
            assert (false);
            return super.from();
        }

        @Override
        public int to() {
            assert (false);
            return super.to();
        }

        @Override
        public String toString() {
            return "JspSyntaxElement[SHARED_TEXT_ELEMENT]";
        }
    }

    public static class Comment
    extends JspSyntaxElement {
        public Comment(CharSequence source, int from, int to) {
            super(source, from, to);
        }

        @Override
        public Kind kind() {
            return Kind.COMMENT;
        }
    }

    public static enum Kind {
        TEXT,
        COMMENT,
        SCRIPTING,
        ERROR,
        ENDTAG,
        OPENTAG,
        DIRECTIVE;

    }
}

