/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.Verifier;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConverterConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String CONVERTER = "converter";
    private static final String CONVERTER_ID = "converter-id";
    private static final String CONVERTER_FOR_CLASS = "converter-for-class";
    private static final String CONVERTER_CLASS = "converter-class";

    @Override
    public void process(ServletContext sc, DocumentInfo[] documentInfos) throws Exception {
        this.processAnnotations(FacesConverter.class);
        for (int i = 0; i < documentInfos.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing converter elements for document: ''{0}''", documentInfos[i].getSourceURI()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList nodes = document.getDocumentElement().getElementsByTagNameNS(namespace, CONVERTER);
            if (nodes == null || nodes.getLength() <= 0) continue;
            this.addConverters(nodes, namespace);
        }
        this.invokeNext(sc, documentInfos);
    }

    private void addConverters(NodeList converters, String namespace) {
        Application application = this.getApplication();
        Verifier verifier = Verifier.getCurrentInstance();
        int size = converters.getLength();
        for (int i = 0; i < size; ++i) {
            Node converter = converters.item(i);
            NodeList children = ((Element)converter).getElementsByTagNameNS(namespace, "*");
            String converterId = null;
            String converterClass = null;
            String converterForClass = null;
            int csize = children.getLength();
            block13: for (int c = 0; c < csize; ++c) {
                Node n = children.item(c);
                switch (n.getLocalName()) {
                    case "converter-id": {
                        converterId = this.getNodeText(n);
                        continue block13;
                    }
                    case "converter-class": {
                        converterClass = this.getNodeText(n);
                        continue block13;
                    }
                    case "converter-for-class": {
                        converterForClass = this.getNodeText(n);
                    }
                }
            }
            if (converterId != null && converterClass != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("[Converter by ID] Calling Application.addConverter({0}, {1}", converterId, converterClass));
                }
                if (verifier != null) {
                    verifier.validateObject(Verifier.ObjectType.CONVERTER, converterClass, Converter.class);
                }
                application.addConverter(converterId, converterClass);
                continue;
            }
            if (converterClass == null || converterForClass == null) continue;
            try {
                Class cfcClass = Util.loadClass(converterForClass, this.getClass());
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, MessageFormat.format("[Converter for Class] Calling Application.addConverter({0}, {1}", converterForClass, converterClass));
                }
                if (verifier != null) {
                    verifier.validateObject(Verifier.ObjectType.CONVERTER, converterClass, Converter.class);
                }
                application.addConverter(cfcClass, converterClass);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                throw new ConfigurationException(cnfe);
            }
        }
    }
}

