/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.paginator.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;

public abstract class AbstractResponseIterator<REQUESTBUILDER, REQUEST, RESPONSE> {
    protected final REQUESTBUILDER requestBuilder;
    protected final Function<RESPONSE, String> nextPageTokenRetrievalFunction;
    protected final Function<REQUEST, RESPONSE> pageRetrievalFunction;
    protected final Function<RequestBuilderAndToken<REQUESTBUILDER>, REQUEST> requestBuilderFunction;
    protected RESPONSE currentResponse;
    protected String nextPageToken;

    public AbstractResponseIterator(REQUESTBUILDER requestBuilder, Function<RESPONSE, String> nextPageTokenRetrievalFunction, Function<RequestBuilderAndToken<REQUESTBUILDER>, REQUEST> requestBuilderFunction, Function<REQUEST, RESPONSE> pageRetrievalFunction) {
        this.requestBuilder = requestBuilder;
        this.nextPageTokenRetrievalFunction = nextPageTokenRetrievalFunction;
        this.requestBuilderFunction = requestBuilderFunction;
        this.pageRetrievalFunction = pageRetrievalFunction;
    }

    protected REQUEST getNextRequest() {
        RequestBuilderAndToken<REQUESTBUILDER> requestBuilderAndToken = new RequestBuilderAndToken<REQUESTBUILDER>(this.requestBuilder, this.getNextPageToken());
        return (REQUEST)this.requestBuilderFunction.apply(requestBuilderAndToken);
    }

    protected Optional<String> getNextPageToken() {
        if (this.currentResponse == null) {
            return null;
        }
        return Optional.fromNullable((Object)this.nextPageTokenRetrievalFunction.apply(this.currentResponse));
    }

    protected void fetchNextPage() {
        this.currentResponse = this.pageRetrievalFunction.apply(this.getNextRequest());
        this.nextPageToken = (String)this.nextPageTokenRetrievalFunction.apply(this.currentResponse);
    }
}

