/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.maven.indexer.api.NBGroupInfo;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.QueryRequest;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.indexer.spi.ArchetypeQueries;
import org.netbeans.modules.maven.indexer.spi.BaseQueries;
import org.netbeans.modules.maven.indexer.spi.ChecksumQueries;
import org.netbeans.modules.maven.indexer.spi.ClassUsageQuery;
import org.netbeans.modules.maven.indexer.spi.ClassesQuery;
import org.netbeans.modules.maven.indexer.spi.ContextLoadedQuery;
import org.netbeans.modules.maven.indexer.spi.DependencyInfoQueries;
import org.netbeans.modules.maven.indexer.spi.GenericFindQuery;
import org.netbeans.modules.maven.indexer.spi.NullResultImpl;
import org.netbeans.modules.maven.indexer.spi.RepositoryIndexQueryProvider;
import org.netbeans.modules.maven.indexer.spi.ResultImplementation;
import org.netbeans.modules.project.spi.intern.ProjectIDEServices;
import org.openide.util.Lookup;

public final class RepositoryQueries {
    private static <T> Result<T> getQueryResult(List<RepositoryInfo> repos, QueryCall<T> c) {
        LinkedList results = new LinkedList();
        if (repos == null) {
            repos = RepositoryPreferences.getInstance().getRepositoryInfos();
        }
        Map<RepositoryIndexQueryProvider, List<RepositoryInfo>> qp2Repo = RepositoryQueries.getQueryProvider2Repo(repos);
        for (Map.Entry<RepositoryIndexQueryProvider, List<RepositoryInfo>> e : qp2Repo.entrySet()) {
            results.add(c.call(e.getKey(), e.getValue()));
        }
        return new Result(new CompositeResult(results));
    }

    private static Map<RepositoryIndexQueryProvider, List<RepositoryInfo>> getQueryProvider2Repo(List<RepositoryInfo> repos) {
        Collection idxs = Lookup.getDefault().lookupAll(RepositoryIndexQueryProvider.class);
        HashMap<RepositoryIndexQueryProvider, List<RepositoryInfo>> qp2Repo = new HashMap<RepositoryIndexQueryProvider, List<RepositoryInfo>>();
        block0: for (RepositoryInfo repo : repos) {
            for (RepositoryIndexQueryProvider idx : idxs) {
                if (!idx.handlesRepository(repo)) continue;
                LinkedList<RepositoryInfo> mappedRepos = (LinkedList<RepositoryInfo>)qp2Repo.get(idx);
                if (mappedRepos == null) {
                    mappedRepos = new LinkedList<RepositoryInfo>();
                    qp2Repo.put(idx, mappedRepos);
                }
                mappedRepos.add(repo);
                continue block0;
            }
        }
        return qp2Repo;
    }

    public static Result<String> getGroupsResult(@NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.getQueryResult(repos, (queryProvider, providerRepos) -> {
            BaseQueries baseQueries = queryProvider.getBaseQueries();
            assert (baseQueries != null) : "RepositoryIndexQueryProvider.getBaseQueries not allowed to return null";
            return baseQueries.getGroups(providerRepos);
        });
    }

    public static Result<NBVersionInfo> getRecordsResult(String groupId, String artifactId, String version, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.getQueryResult(repos, (queryProvider, providerRepos) -> {
            BaseQueries baseQueries = queryProvider.getBaseQueries();
            assert (baseQueries != null) : "RepositoryIndexQueryProvider.getBaseQueries not allowed to return null";
            return baseQueries.getRecords(groupId, artifactId, version, providerRepos);
        });
    }

    public static Result<String> getGAVsForPackaging(String packaging, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.getQueryResult(repos, (queryProvider, providerRepos) -> {
            BaseQueries baseQueries = queryProvider.getBaseQueries();
            assert (baseQueries != null) : "RepositoryIndexQueryProvider.getBaseQueries not allowed to return null";
            return baseQueries.getGAVsForPackaging(packaging, providerRepos);
        });
    }

    public static Result<String> getArtifactsResult(String groupId, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.getQueryResult(repos, (queryProvider, providerRepos) -> {
            BaseQueries baseQueries = queryProvider.getBaseQueries();
            assert (baseQueries != null) : "RepositoryIndexQueryProvider.getBaseQueries not allowed to return null";
            return baseQueries.getArtifacts(groupId, providerRepos);
        });
    }

    public static Result<NBVersionInfo> getVersionsResult(String groupId, String artifactId, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.getQueryResult(repos, (queryProvider, providerRepos) -> {
            BaseQueries baseQueries = queryProvider.getBaseQueries();
            assert (baseQueries != null) : "RepositoryIndexQueryProvider.getBaseQueries not allowed to return null";
            return baseQueries.getVersions(groupId, artifactId, providerRepos);
        });
    }

    public static Result<NBGroupInfo> findDependencyUsageResult(String groupId, String artifactId, String version, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.getQueryResult(repos, (queryProvider, providerRepos) -> {
            DependencyInfoQueries dependencyInfoQueries = queryProvider.getDependencyInfoQueries();
            return dependencyInfoQueries != null ? dependencyInfoQueries.findDependencyUsageGroups(groupId, artifactId, version, providerRepos) : new NullResultImpl();
        });
    }

    public static Result<NBVersionInfo> findBySHA1Result(File file, @NullAllowed List<RepositoryInfo> repos) {
        try {
            String calculateChecksum = RepositoryUtil.calculateSHA1Checksum(file);
            return RepositoryQueries.findBySHA1(calculateChecksum, repos);
        }
        catch (IOException ex) {
            Logger.getLogger(RepositoryQueries.class.getName()).log(Level.INFO, "Could not determine SHA-1 of " + file, ex);
            return new Result<NBVersionInfo>(new NullResultImpl());
        }
    }

    private static Result<NBVersionInfo> findBySHA1(String sha1, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.getQueryResult(repos, (queryProvider, providerRepos) -> {
            ChecksumQueries checksumQueries = queryProvider.getChecksumQueries();
            return checksumQueries != null ? checksumQueries.findBySHA1(sha1, providerRepos) : new NullResultImpl();
        });
    }

    public static Result<NBVersionInfo> findVersionsByClassResult(String className, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.getQueryResult(repos, (queryProvider, providerRepos) -> {
            ClassesQuery classesQuery = queryProvider.getClassesQuery();
            return classesQuery != null ? classesQuery.findVersionsByClass(className, providerRepos) : new NullResultImpl();
        });
    }

    public static void findVersionsByClass(QueryRequest query) {
        Iterator<RepositoryInfo> it1 = query.getRepositories().iterator();
        while (it1.hasNext()) {
            RepositoryInfo repositoryInfo = it1.next();
            ArrayList<RepositoryInfo> repositoryInfoL = new ArrayList<RepositoryInfo>(1);
            repositoryInfoL.add(repositoryInfo);
            Result queryResult = RepositoryQueries.getQueryResult(repositoryInfoL, (queryProvider, providerRepos) -> {
                ClassesQuery classesQuery = queryProvider.getClassesQuery();
                return classesQuery != null ? classesQuery.findVersionsByClass(query.getClassName(), providerRepos) : new NullResultImpl();
            });
            query.addResults(queryResult.getResults(), !it1.hasNext());
            if (query.countObservers() != 0) continue;
            return;
        }
        if (!query.isFinished()) {
            query.addResults(null, true);
        }
    }

    public static Result<ClassUsage> findClassUsagesResult(String className, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.getQueryResult(repos, (queryProvider, providerRepos) -> {
            ClassUsageQuery classUsageQuery = queryProvider.getClassUsageQuery();
            return classUsageQuery != null ? classUsageQuery.findClassUsages(className, repos) : new NullResultImpl();
        });
    }

    public static Result<NBVersionInfo> findArchetypesResult(@NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.getQueryResult(repos, (queryProvider, providerRepos) -> {
            ArchetypeQueries archetypeQueries = queryProvider.getArchetypeQueries();
            return archetypeQueries != null ? archetypeQueries.findArchetypes(repos) : new NullResultImpl();
        });
    }

    public static Result<String> filterPluginArtifactIdsResult(String groupId, String prefix, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.getQueryResult(repos, (queryProvider, providerRepos) -> {
            BaseQueries baseQueries = queryProvider.getBaseQueries();
            assert (baseQueries != null) : "RepositoryIndexQueryProvider.getBaseQueries not allowed to return null";
            return baseQueries.filterPluginArtifactIds(groupId, prefix, providerRepos);
        });
    }

    public static Result<String> filterPluginGroupIdsResult(String prefix, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.getQueryResult(repos, (queryProvider, providerRepos) -> {
            BaseQueries baseQueries = queryProvider.getBaseQueries();
            assert (baseQueries != null) : "RepositoryIndexQueryProvider.getBaseQueries not allowed to return null";
            return baseQueries.filterPluginGroupIds(prefix, providerRepos);
        });
    }

    public static Result<NBVersionInfo> findResult(List<QueryField> fields, @NullAllowed List<RepositoryInfo> repos) {
        return RepositoryQueries.getQueryResult(repos, (queryProvider, providerRepos) -> {
            GenericFindQuery genericFindQuery = queryProvider.getGenericFindQuery();
            return genericFindQuery != null ? genericFindQuery.find(fields, providerRepos) : new NullResultImpl();
        });
    }

    public static void find(QueryRequest query) {
        Iterator<RepositoryInfo> it1 = query.getRepositories().iterator();
        while (it1.hasNext()) {
            RepositoryInfo repositoryInfo = it1.next();
            ArrayList<RepositoryInfo> repositoryInfoL = new ArrayList<RepositoryInfo>(1);
            repositoryInfoL.add(repositoryInfo);
            Result qeuryResult = RepositoryQueries.getQueryResult(repositoryInfoL, (queryProvider, providerRepos) -> {
                GenericFindQuery genericFindQuery = queryProvider.getGenericFindQuery();
                return genericFindQuery != null ? genericFindQuery.find(query.getQueryFields(), providerRepos) : new NullResultImpl();
            });
            query.addResults(qeuryResult.getResults(), !it1.hasNext());
            if (query.countObservers() != 0) continue;
            return;
        }
        if (!query.isFinished()) {
            query.addResults(null, true);
        }
    }

    @NonNull
    public static List<RepositoryInfo> getLoadedContexts() {
        ArrayList<RepositoryInfo> toRet = new ArrayList<RepositoryInfo>();
        List<RepositoryInfo> repos = RepositoryPreferences.getInstance().getRepositoryInfos();
        Map<RepositoryIndexQueryProvider, List<RepositoryInfo>> i2r = RepositoryQueries.getQueryProvider2Repo(repos);
        for (Map.Entry<RepositoryIndexQueryProvider, List<RepositoryInfo>> e : i2r.entrySet()) {
            ContextLoadedQuery clq = e.getKey().getContextLoadedQuery();
            if (clq == null) continue;
            toRet.addAll(clq.getLoaded(repos));
        }
        return toRet;
    }

    private static interface QueryCall<T> {
        public ResultImplementation<T> call(RepositoryIndexQueryProvider var1, List<RepositoryInfo> var2);
    }

    public static final class ClassUsage {
        private final NBVersionInfo artifact;
        private final Set<String> classes;

        public ClassUsage(NBVersionInfo artifact, Set<String> classes) {
            this.artifact = artifact;
            this.classes = classes;
        }

        public NBVersionInfo getArtifact() {
            return this.artifact;
        }

        public Set<String> getClasses() {
            return this.classes;
        }

        public String toString() {
            return "" + this.artifact + this.classes;
        }
    }

    private static final class CompositeResult<T>
    implements ResultImplementation {
        private final List<ResultImplementation<T>> results;

        public CompositeResult(List<ResultImplementation<T>> results) {
            this.results = results;
        }

        @Override
        public boolean isPartial() {
            for (ResultImplementation<T> result : this.results) {
                if (!result.isPartial()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void waitForSkipped() {
            for (ResultImplementation<T> result : this.results) {
                result.waitForSkipped();
            }
        }

        @Override
        public List<T> getResults() {
            return Collections.unmodifiableList(this.results.stream().flatMap(r -> r.getResults().stream()).distinct().collect(Collectors.toCollection(() -> new LinkedList())));
        }

        @Override
        public int getTotalResultCount() {
            int ret = 0;
            for (ResultImplementation<T> result : this.results) {
                ret += result.getTotalResultCount();
            }
            return ret;
        }

        @Override
        public int getReturnedResultCount() {
            return this.getResults().size();
        }
    }

    public static final class Result<T> {
        private final ResultImplementation<T> impl;

        public Result(ResultImplementation<T> impl) {
            this.impl = impl;
        }

        public synchronized boolean isPartial() {
            return this.impl.isPartial();
        }

        public void waitForSkipped() {
            assert (!ProjectIDEServices.isEventDispatchThread());
            this.impl.waitForSkipped();
        }

        public synchronized List<T> getResults() {
            return this.impl.getResults();
        }

        public int getTotalResultCount() {
            return this.impl.getTotalResultCount();
        }

        public int getReturnedResultCount() {
            return this.impl.getReturnedResultCount();
        }
    }
}

