/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectToObjectConverter
implements ConditionalGenericConverter {
    ObjectToObjectConverter() {
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.getType().equals(targetType.getType())) {
            return false;
        }
        return ObjectToObjectConverter.hasValueOfMethodOrConstructor(targetType.getType(), sourceType.getType());
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        Class<?> sourceClass = sourceType.getType();
        Class<?> targetClass = targetType.getType();
        Method method = ObjectToObjectConverter.getValueOfMethodOn(targetClass, sourceClass);
        try {
            if (method != null) {
                ReflectionUtils.makeAccessible(method);
                return method.invoke(null, source);
            }
            Constructor<?> constructor = ObjectToObjectConverter.getConstructor(targetClass, sourceClass);
            if (constructor != null) {
                ReflectionUtils.makeAccessible(constructor);
                return constructor.newInstance(source);
            }
        }
        catch (InvocationTargetException ex) {
            throw new ConversionFailedException(sourceType, targetType, source, ex.getTargetException());
        }
        catch (Throwable ex) {
            throw new ConversionFailedException(sourceType, targetType, source, ex);
        }
        throw new IllegalStateException("No static valueOf(" + sourceClass.getName() + ") method or Constructor(" + sourceClass.getName() + ") exists on " + targetClass.getName());
    }

    static boolean hasValueOfMethodOrConstructor(Class<?> clazz, Class<?> sourceParameterType) {
        return ObjectToObjectConverter.getValueOfMethodOn(clazz, sourceParameterType) != null || ObjectToObjectConverter.getConstructor(clazz, sourceParameterType) != null;
    }

    private static Method getValueOfMethodOn(Class<?> clazz, Class<?> sourceParameterType) {
        return ClassUtils.getStaticMethod(clazz, "valueOf", sourceParameterType);
    }

    private static Constructor<?> getConstructor(Class<?> clazz, Class<?> sourceParameterType) {
        return ClassUtils.getConstructorIfAvailable(clazz, sourceParameterType);
    }
}

