/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.EjbResourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.MessageDestinationConfiguration;
import org.netbeans.modules.javaee.wildfly.config.ds.DatasourceSupport;
import org.netbeans.modules.javaee.wildfly.config.mdb.MessageDestinationSupport;
import org.netbeans.modules.javaee.wildfly.config.mdb.wf10.MessageDestinationSupportImpl;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.openide.loaders.DataObject;

public abstract class WildflyDeploymentConfiguration
implements DatasourceConfiguration,
MessageDestinationConfiguration,
EjbResourceConfiguration {
    protected static final String MAIL_SERVICE_JNDI_NAME_JB4 = "java:Mail";
    protected final J2eeModule j2eeModule;
    protected DataObject deploymentDescriptorDO;
    protected final WildflyPluginUtils.Version version;
    private File resourceDir;
    private DatasourceSupport dsSupport;
    private MessageDestinationSupport destSupport;
    protected boolean isWildFly;

    public WildflyDeploymentConfiguration(J2eeModule j2eeModule, WildflyPluginUtils.Version version, boolean isWildFly) {
        this.j2eeModule = j2eeModule;
        this.version = version;
        this.resourceDir = j2eeModule.getResourceDirectory();
        this.isWildFly = isWildFly;
    }

    public J2eeModule getJ2eeModule() {
        return this.j2eeModule;
    }

    public boolean isWildfly() {
        return this.isWildFly;
    }

    public boolean supportsCreateDatasource() {
        return false;
    }

    public boolean supportsCreateMessageDestination() {
        return this.isWildfly();
    }

    private DatasourceSupport getDatasourceSupport() {
        if (this.dsSupport == null) {
            this.dsSupport = new DatasourceSupport(this.resourceDir);
        }
        return this.dsSupport;
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        return this.getDatasourceSupport().getDatasources();
    }

    public Datasource createDatasource(String jndiName, String url, String username, String password, String driver) throws UnsupportedOperationException, ConfigurationException, DatasourceAlreadyExistsException {
        return this.getDatasourceSupport().createDatasource(jndiName, url, username, password, driver);
    }

    public void bindDatasourceReference(String referenceName, String jndiName) throws ConfigurationException {
    }

    public void bindDatasourceReferenceForEjb(String ejbName, String ejbType, String referenceName, String jndiName) throws ConfigurationException {
    }

    public String findDatasourceJndiName(String referenceName) throws ConfigurationException {
        return null;
    }

    public String findDatasourceJndiNameForEjb(String ejbName, String referenceName) throws ConfigurationException {
        return null;
    }

    private MessageDestinationSupport getMessageDestinationsSupport() throws IOException {
        if (this.destSupport == null) {
            String configFile = "module-destinations";
            if (this.j2eeModule != null && this.j2eeModule.getArchive() != null) {
                configFile = this.j2eeModule.getArchive().getName();
            }
            this.destSupport = this.version.compareTo(WildflyPluginUtils.WILDFLY_10_0_0) < 0 ? new org.netbeans.modules.javaee.wildfly.config.mdb.MessageDestinationSupportImpl(this.resourceDir, configFile) : new MessageDestinationSupportImpl(this.resourceDir, configFile);
        }
        return this.destSupport;
    }

    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        try {
            return this.getMessageDestinationsSupport().getMessageDestinations();
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public MessageDestination createMessageDestination(String name, MessageDestination.Type type) throws UnsupportedOperationException, ConfigurationException {
        try {
            return this.getMessageDestinationsSupport().createMessageDestination(name, type);
        }
        catch (IOException ex) {
            throw new ConfigurationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void bindMdbToMessageDestination(String mdbName, String name, MessageDestination.Type type) throws ConfigurationException {
    }

    public String findMessageDestinationName(String mdbName) throws ConfigurationException {
        return null;
    }

    public void bindMessageDestinationReference(String referenceName, String connectionFactoryName, String destName, MessageDestination.Type type) throws ConfigurationException {
    }

    public void bindMessageDestinationReferenceForEjb(String ejbName, String ejbType, String referenceName, String connectionFactoryName, String destName, MessageDestination.Type type) throws ConfigurationException {
    }

    public String findJndiNameForEjb(String ejbName) throws ConfigurationException {
        return null;
    }

    public void bindEjbReference(String referenceName, String jndiName) throws ConfigurationException {
    }

    public void bindEjbReferenceForEjb(String ejbName, String ejbType, String referenceName, String jndiName) throws ConfigurationException {
    }
}

