/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

public class DelegatingJavaFileManager
implements JavaFileManager {
    private final JavaFileManager releaseFM;
    private final JavaFileManager baseFM;

    public static void installReleaseFileManager(Context context, JavaFileManager releaseFM, JavaFileManager originalFM) {
        DelegatingJavaFileManager delegatingJavaFileManager;
        context.put(JavaFileManager.class, (JavaFileManager)null);
        JavaFileManager javaFileManager = originalFM;
        if (javaFileManager instanceof StandardJavaFileManager) {
            StandardJavaFileManager standardJavaFileManager = (StandardJavaFileManager)javaFileManager;
            delegatingJavaFileManager = new DelegatingSJFM(releaseFM, standardJavaFileManager);
        } else {
            delegatingJavaFileManager = new DelegatingJavaFileManager(releaseFM, originalFM);
        }
        DelegatingJavaFileManager nue = delegatingJavaFileManager;
        context.put(JavaFileManager.class, nue);
    }

    private DelegatingJavaFileManager(JavaFileManager releaseFM, JavaFileManager baseFM) {
        this.releaseFM = releaseFM;
        this.baseFM = baseFM;
    }

    private JavaFileManager delegate(JavaFileManager.Location location) {
        if (this.releaseFM.hasLocation(location)) {
            return this.releaseFM;
        }
        return this.baseFM;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.delegate(location).getClassLoader(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        return this.delegate(location).list(location, packageName, kinds, recurse);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        return this.delegate(location).inferBinaryName(location, file);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return this.baseFM.isSameFile(a, b);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.baseFM.handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.releaseFM.hasLocation(location) || this.baseFM.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        return this.delegate(location).getJavaFileForInput(location, className, kind);
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return this.delegate(location).getJavaFileForOutput(location, className, kind, sibling);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.delegate(location).getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.delegate(location).getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public void flush() throws IOException {
        this.releaseFM.flush();
        this.baseFM.flush();
    }

    @Override
    public void close() throws IOException {
        this.releaseFM.close();
        this.baseFM.close();
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        return this.delegate(location).getLocationForModule(location, moduleName);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        return this.delegate(location).getLocationForModule(location, fo);
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(JavaFileManager.Location location, Class<S> service) throws IOException {
        return this.delegate(location).getServiceLoader(location, service);
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        return this.delegate(location).inferModuleName(location);
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        return this.delegate(location).listLocationsForModules(location);
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject fo) throws IOException {
        return this.delegate(location).contains(location, fo);
    }

    @Override
    public int isSupportedOption(String option) {
        return this.baseFM.isSupportedOption(option);
    }

    public JavaFileManager getBaseFileManager() {
        return this.baseFM;
    }

    private static final class DelegatingSJFM
    extends DelegatingJavaFileManager
    implements StandardJavaFileManager {
        private final StandardJavaFileManager baseSJFM;

        private DelegatingSJFM(JavaFileManager releaseFM, StandardJavaFileManager baseSJFM) {
            super(releaseFM, baseSJFM);
            this.baseSJFM = baseSJFM;
        }

        @Override
        public boolean isSameFile(FileObject a, FileObject b) {
            return this.baseSJFM.isSameFile(a, b);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
            return this.baseSJFM.getJavaFileObjectsFromFiles(files);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Collection<? extends Path> paths) {
            return this.baseSJFM.getJavaFileObjectsFromPaths(paths);
        }

        @Override
        @Deprecated
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Iterable<? extends Path> paths) {
            return this.baseSJFM.getJavaFileObjectsFromPaths(paths);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
            return this.baseSJFM.getJavaFileObjects(files);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... paths) {
            return this.baseSJFM.getJavaFileObjects(paths);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
            return this.baseSJFM.getJavaFileObjectsFromStrings(names);
        }

        @Override
        public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
            return this.baseSJFM.getJavaFileObjects(names);
        }

        @Override
        public void setLocation(JavaFileManager.Location location, Iterable<? extends File> files) throws IOException {
            this.baseSJFM.setLocation(location, files);
        }

        @Override
        public void setLocationFromPaths(JavaFileManager.Location location, Collection<? extends Path> paths) throws IOException {
            this.baseSJFM.setLocationFromPaths(location, paths);
        }

        @Override
        public void setLocationForModule(JavaFileManager.Location location, String moduleName, Collection<? extends Path> paths) throws IOException {
            this.baseSJFM.setLocationForModule(location, moduleName, paths);
        }

        @Override
        public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
            return this.baseSJFM.getLocation(location);
        }

        @Override
        public Iterable<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
            return this.baseSJFM.getLocationAsPaths(location);
        }

        @Override
        public Path asPath(FileObject file) {
            return this.baseSJFM.asPath(file);
        }

        @Override
        public void setPathFactory(StandardJavaFileManager.PathFactory f) {
            this.baseSJFM.setPathFactory(f);
        }
    }
}

