/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.analysis.commands.CodeSniffer;
import org.netbeans.modules.php.analysis.commands.MessDetector;
import org.netbeans.modules.php.analysis.util.Bundle;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.openide.filesystems.FileChooserBuilder;

public final class AnalysisUiUtils {
    private static final String CODE_SNIFFER_LAST_FOLDER_SUFFIX = ".codeSniffer";
    private static final String CODING_STANDARDS_FIXER_LAST_FOLDER_SUFFIX = ".codingStandarsFixer";
    private static final String MESS_DETECTOR_LAST_FOLDER_SUFFIX = ".messDetector";
    private static final String MESS_DETECTOR_RULE_SET_FILE_LAST_FOLDER_SUFFIX = ".messDetector.ruleSetFile";
    private static final String PHPSTAN_LAST_FOLDER_SUFFIX = ".phpstan";
    private static final String PHPSTAN_CONFIGURATION_LAST_FOLDER_SUFFIX = ".phpstan.config";

    private AnalysisUiUtils() {
    }

    @CheckForNull
    public static File browseCodeSniffer() {
        return AnalysisUiUtils.browse(CODE_SNIFFER_LAST_FOLDER_SUFFIX, Bundle.AnalysisUiUtils_browse_code_sniffer_title());
    }

    @CheckForNull
    public static File browseCodingStandardsFixer() {
        return AnalysisUiUtils.browse(CODING_STANDARDS_FIXER_LAST_FOLDER_SUFFIX, Bundle.AnalysisUiUtils_browse_coding_standards_fixer_title());
    }

    @CheckForNull
    public static File browseMessDetector() {
        return AnalysisUiUtils.browse(MESS_DETECTOR_LAST_FOLDER_SUFFIX, Bundle.AnalysisUiUtils_browse_mess_detector_title());
    }

    @CheckForNull
    public static File browseMessDetectorRuleSet() {
        return AnalysisUiUtils.browse(MESS_DETECTOR_RULE_SET_FILE_LAST_FOLDER_SUFFIX, Bundle.AnalysisUiUtils_browse_mess_detector_rule_set_title());
    }

    @CheckForNull
    public static File browsePHPStan() {
        return AnalysisUiUtils.browse(PHPSTAN_LAST_FOLDER_SUFFIX, Bundle.AnalysisUiUtils_browse_phpstan_title());
    }

    @CheckForNull
    public static File browsePHPStanConfiguration() {
        return AnalysisUiUtils.browse(PHPSTAN_CONFIGURATION_LAST_FOLDER_SUFFIX, Bundle.AnalysisUiUtils_browse_phpstan_configuration_title());
    }

    @CheckForNull
    private static File browse(String lastFolderSuffix, String title) {
        File file = new FileChooserBuilder(AnalysisUiUtils.class.getName() + lastFolderSuffix).setFilesOnly(true).setTitle(title).showOpenDialog();
        return file;
    }

    @CheckForNull
    public static String searchCodeSniffer() {
        SearchParameter param = new SearchParameter().setFilenames(Arrays.asList("phpcs", CodeSniffer.LONG_NAME)).setWindowTitle(Bundle.AnalysisUiUtils_search_code_sniffer_title()).setListTitle(Bundle.AnalysisUiUtils_search_code_sniffer_scripts()).setPleaseWaitPart(Bundle.AnalysisUiUtils_search_code_sniffer_pleaseWaitPart()).setNoItemsFound(Bundle.AnalysisUiUtils_search_code_sniffer_notFound());
        return AnalysisUiUtils.search(param);
    }

    @CheckForNull
    public static String searchCodingStandardsFixer() {
        SearchParameter param = new SearchParameter().setFilenames(Arrays.asList("php-cs-fixer", "php-cs-fixer.phar")).setWindowTitle(Bundle.AnalysisUiUtils_search_coding_standards_fixer_title()).setListTitle(Bundle.AnalysisUiUtils_search_coding_standards_fixer_scripts()).setPleaseWaitPart(Bundle.AnalysisUiUtils_search_coding_standards_fixer_pleaseWaitPart()).setNoItemsFound(Bundle.AnalysisUiUtils_search_coding_standards_fixer_notFound());
        return AnalysisUiUtils.search(param);
    }

    @CheckForNull
    public static String searchMessDetector() {
        SearchParameter param = new SearchParameter().setFilenames(Arrays.asList("phpmd", MessDetector.LONG_NAME)).setWindowTitle(Bundle.AnalysisUiUtils_search_mess_detector_title()).setListTitle(Bundle.AnalysisUiUtils_search_mess_detector_fixer_scripts()).setPleaseWaitPart(Bundle.AnalysisUiUtils_search_mess_detector_fixer_pleaseWaitPart()).setNoItemsFound(Bundle.AnalysisUiUtils_search_mess_detector_fixer_notFound());
        return AnalysisUiUtils.search(param);
    }

    @CheckForNull
    public static String searchPHPStan() {
        SearchParameter param = new SearchParameter().setFilenames(Arrays.asList("phpstan", "phpstan.phar")).setWindowTitle(Bundle.AnalysisUiUtils_search_phpstan_title()).setListTitle(Bundle.AnalysisUiUtils_search_phpstan_scripts()).setPleaseWaitPart(Bundle.AnalysisUiUtils_search_phpstan_pleaseWaitPart()).setNoItemsFound(Bundle.AnalysisUiUtils_search_phpstan_notFound());
        return AnalysisUiUtils.search(param);
    }

    @CheckForNull
    private static String search(final SearchParameter param) {
        return UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String[])param.getFilenames().toArray(new String[param.getFilenames().size()]));
            }

            public String getWindowTitle() {
                return param.getWindowTitle();
            }

            public String getListTitle() {
                return param.getListTitle();
            }

            public String getPleaseWaitPart() {
                return param.getPleaseWaitPart();
            }

            public String getNoItemsFound() {
                return param.getNoItemsFound();
            }
        });
    }

    private static final class SearchParameter {
        private final List<String> filenames = new ArrayList<String>();
        private String windowTitle;
        private String listTitle;
        private String pleaseWaitPart;
        private String noItemsFound;

        private SearchParameter() {
        }

        public List<String> getFilenames() {
            return Collections.unmodifiableList(this.filenames);
        }

        public String getWindowTitle() {
            return this.windowTitle;
        }

        public String getListTitle() {
            return this.listTitle;
        }

        public String getPleaseWaitPart() {
            return this.pleaseWaitPart;
        }

        public String getNoItemsFound() {
            return this.noItemsFound;
        }

        SearchParameter setFilenames(List<String> filenames) {
            this.filenames.clear();
            this.filenames.addAll(filenames);
            return this;
        }

        SearchParameter setWindowTitle(String windowTitle) {
            this.windowTitle = windowTitle;
            return this;
        }

        SearchParameter setListTitle(String listTitle) {
            this.listTitle = listTitle;
            return this;
        }

        SearchParameter setPleaseWaitPart(String pleaseWaitPart) {
            this.pleaseWaitPart = pleaseWaitPart;
            return this;
        }

        SearchParameter setNoItemsFound(String noItemsFound) {
            this.noItemsFound = noItemsFound;
            return this;
        }
    }
}

