/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild.extlibs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.netbeans.nbbuild.extlibs.ConfigureProxy;
import org.netbeans.nbbuild.extlibs.MavenCoordinate;

public class DownloadBinaries
extends Task {
    private static final String MAVEN_REPO = "https://repo1.maven.org/maven2/";
    private static final Pattern URL_PATTERN = Pattern.compile("(https?://\\S*[^/\\s]+)\\s+(\\S+)$");
    private File cache;
    private String server;
    private String repos = "https://repo1.maven.org/maven2/";
    private final List<FileSet> manifests = new ArrayList<FileSet>();
    private boolean clean;

    public void setCache(File cache) {
        this.cache = cache;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setRepos(String repos) {
        this.repos = repos;
    }

    public void addManifest(FileSet manifest) {
        this.manifests.add(manifest);
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public void execute() throws BuildException {
        boolean success = true;
        for (FileSet fs : this.manifests) {
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            File basedir = scanner.getBasedir();
            for (String include : scanner.getIncludedFiles()) {
                File manifest = new File(basedir, include);
                this.log("Scanning: " + manifest, 3);
                try (FileInputStream is = new FileInputStream(manifest);){
                    String line;
                    BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                    while ((line = r.readLine()) != null) {
                        if (line.startsWith("#") || line.trim().length() == 0) continue;
                        String[] hashAndFile = line.split(" ", 2);
                        if (hashAndFile.length < 2) {
                            throw new BuildException("Bad line '" + line + "' in " + manifest, this.getLocation());
                        }
                        Matcher urlMatcher = URL_PATTERN.matcher(hashAndFile[1]);
                        if (MavenCoordinate.isMavenFile(hashAndFile[1])) {
                            MavenCoordinate mc = MavenCoordinate.fromGradleFormat(hashAndFile[1]);
                            success &= this.fillInFile(hashAndFile[0], mc.toArtifactFilename(), manifest, () -> this.mavenFile(mc));
                            continue;
                        }
                        if (urlMatcher.matches()) {
                            success &= this.fillInFile(hashAndFile[0], urlMatcher.group(2), manifest, () -> DownloadBinaries.downloadFromServer(this, new URL(urlMatcher.group(1))));
                            continue;
                        }
                        success &= this.fillInFile(hashAndFile[0], hashAndFile[1], manifest, () -> this.legacyDownload(hashAndFile[0] + "-" + hashAndFile[1]));
                    }
                }
                catch (IOException x) {
                    throw new BuildException("Could not open " + manifest + ": " + x, (Throwable)x, this.getLocation());
                }
            }
        }
        if (!success) {
            throw new BuildException("Failed to download binaries - see log message for the detailed reasons.", this.getLocation());
        }
    }

    public static InputStream downloadMaven(Task task, URI u) throws IOException {
        MavenCoordinate mc = MavenCoordinate.fromM2Url(u);
        byte[] arr = DownloadBinaries.downloadMavenFile(task, mc, MAVEN_REPO);
        return new ByteArrayInputStream(arr);
    }

    private byte[] mavenFile(MavenCoordinate mc) throws IOException {
        try {
            return DownloadBinaries.downloadMavenFile(this, mc, this.repos.split(" "));
        }
        catch (BuildException ex) {
            throw new BuildException(ex.getMessage() + " from maven and " + this.server, null, this.getLocation());
        }
    }

    private static byte[] downloadMavenFile(Task task, MavenCoordinate mc, String ... m2Repositories) throws IOException {
        String cacheName = mc.toMavenPath();
        ArrayList<String> urls = new ArrayList<String>();
        for (String prefix : m2Repositories) {
            urls.add(prefix + cacheName);
        }
        for (String url : urls) {
            try {
                File file;
                if (url.startsWith("file:") && !(file = new File(new URI(url))).exists()) continue;
                URL u = new URL(url);
                task.getProject().log("Trying: " + url);
                return DownloadBinaries.downloadFromServer(task, u);
            }
            catch (IOException | URISyntaxException exception) {
            }
        }
        throw new BuildException("Could not download " + cacheName);
    }

    private boolean fillInFile(String expectedHash, String baseName, File manifest, Downloader download) throws BuildException {
        File f = new File(manifest.getParentFile(), baseName);
        if (!this.clean) {
            if (!f.exists() || !this.hash(f).equals(expectedHash)) {
                this.log("Creating " + f);
                String cacheName = expectedHash + "-" + baseName;
                if (this.cache != null) {
                    this.cache.mkdirs();
                    File cacheFile = new File(this.cache, cacheName);
                    if (!cacheFile.exists()) {
                        this.doDownload(cacheName, cacheFile, expectedHash, download);
                    }
                    if (f.isFile() && !f.delete()) {
                        throw new BuildException("Could not delete " + f);
                    }
                    try {
                        FileUtils.getFileUtils().copyFile(cacheFile, f);
                    }
                    catch (IOException x) {
                        throw new BuildException("Could not copy " + cacheFile + " to " + f + ": " + x, (Throwable)x, this.getLocation());
                    }
                } else {
                    this.doDownload(cacheName, f, expectedHash, download);
                }
            }
            if (!f.exists()) {
                return false;
            }
            String actualHash = this.hash(f);
            if (!actualHash.equals(expectedHash)) {
                this.log("File " + f + " requested by " + manifest + " to have hash " + expectedHash + " actually had hash " + actualHash, 1);
                return false;
            }
            this.log("Have " + f + " with expected hash", 3);
            return true;
        }
        if (f.exists()) {
            String actualHash = this.hash(f);
            if (!actualHash.equals(expectedHash)) {
                this.log("File " + f + " requested by " + manifest + " to have hash " + expectedHash + " actually had hash " + actualHash, 1);
                return false;
            }
            this.log("Deleting " + f);
            f.delete();
        }
        return true;
    }

    private boolean doDownload(String cacheName, File destination, String expectedHash, Downloader download) {
        try {
            String actualHash;
            byte[] downloaded = download.download();
            if (expectedHash != null && !expectedHash.equals(actualHash = this.hash(new ByteArrayInputStream(downloaded)))) {
                this.log("Download of " + cacheName + " produced content with hash " + actualHash + " when " + expectedHash + " was expected", 1);
                return false;
            }
            FileOutputStream os = new FileOutputStream(destination);
            try {
                ((OutputStream)os).write(downloaded);
            }
            catch (IOException x) {
                ((OutputStream)os).close();
                destination.delete();
                throw x;
            }
            ((OutputStream)os).close();
            return true;
        }
        catch (IOException | RuntimeException x) {
            String msg = "Could not download " + cacheName + " to " + destination + ": " + x;
            this.log(msg, 1);
            return false;
        }
    }

    private byte[] legacyDownload(String cacheName) throws IOException {
        if (this.server == null) {
            throw new BuildException("Must specify a server to download files from", this.getLocation());
        }
        Throwable firstProblem = null;
        for (String prefix : this.server.split(" ")) {
            try {
                URL url = new URL(prefix + cacheName);
                this.log("Trying: " + url, 3);
                return DownloadBinaries.downloadFromServer(this, url);
            }
            catch (IOException iOException) {
            }
        }
        throw new BuildException("Could not download " + cacheName + " from " + this.server + ": " + firstProblem, firstProblem, this.getLocation());
    }

    private static byte[] downloadFromServer(Task task, URL url) throws IOException {
        byte[] byArray;
        block11: {
            task.getProject().log("Downloading: " + url);
            URLConnection conn = ConfigureProxy.openConnection(task, url, null);
            int code = 200;
            if (conn instanceof HttpURLConnection) {
                code = ((HttpURLConnection)conn).getResponseCode();
            }
            if (code != 200) {
                throw new IOException("Skipping download from " + url + " due to response code " + code);
            }
            InputStream is = conn.getInputStream();
            try {
                int read;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((read = is.read(buf)) != -1) {
                    baos.write(buf, 0, read);
                }
                byArray = baos.toByteArray();
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IOException("Cannot download: " + url + " due to: " + ex, ex);
                }
            }
            is.close();
        }
        return byArray;
    }

    private String hash(File f) {
        String string;
        FileInputStream is = new FileInputStream(f);
        try {
            string = this.hash(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException x) {
                throw new BuildException("Could not get hash for " + f + ": " + x, (Throwable)x, this.getLocation());
            }
        }
        is.close();
        return string;
    }

    private String hash(InputStream is) throws IOException {
        int r;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException x) {
            throw new BuildException((Throwable)x, this.getLocation());
        }
        byte[] buf = new byte[4096];
        while ((r = is.read(buf)) != -1) {
            digest.update(buf, 0, r);
        }
        return String.format("%040X", new BigInteger(1, digest.digest()));
    }

    static interface Downloader {
        public byte[] download() throws IOException;
    }
}

