/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.wsdlmodel;

import com.sun.tools.ws.processor.model.Operation;
import com.sun.tools.ws.processor.model.java.JavaParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlParameter;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.java.WsdlJavaMethod;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaMethod;
import org.openide.util.NbBundle;

public class WsdlOperation
implements WSOperation {
    private String operationName;
    private Operation operation;

    public WsdlOperation(Operation operation) {
        this.operation = operation;
    }

    public Object getInternalJAXWSOperation() {
        return this.operation;
    }

    public JavaMethod getJavaMethod() {
        Operation op = (Operation)this.getInternalJAXWSOperation();
        com.sun.tools.ws.processor.model.java.JavaMethod m = op != null ? op.getJavaMethod() : null;
        WsdlJavaMethod method = new WsdlJavaMethod(m);
        return method;
    }

    public String getName() {
        if (this.operationName == null) {
            this.operationName = this.operation.getName().getLocalPart();
        }
        String postfix = null;
        switch (this.getOperationType()) {
            case 0: {
                break;
            }
            case 1: {
                postfix = NbBundle.getMessage(WsdlOperation.class, (String)"TXT_asyncPolling");
                break;
            }
            case 2: {
                postfix = NbBundle.getMessage(WsdlOperation.class, (String)"TXT_asyncCallback");
                break;
            }
        }
        if (postfix != null) {
            this.operationName = NbBundle.getMessage(WsdlOperation.class, (String)"TXT_operationName", (Object)this.operationName, (Object)postfix);
        }
        return this.operationName;
    }

    public String getJavaName() {
        return this.operation.getJavaMethod().getName();
    }

    public String getReturnTypeName() {
        return this.operation.getJavaMethod().getReturnType().getName();
    }

    public List<WsdlParameter> getParameters() {
        ArrayList<WsdlParameter> wsdlParameters = new ArrayList<WsdlParameter>();
        if (this.operation == null) {
            return wsdlParameters;
        }
        List parameterList = this.operation.getJavaMethod().getParametersList();
        for (JavaParameter param : parameterList) {
            wsdlParameters.add(new WsdlParameter(param));
        }
        return wsdlParameters;
    }

    public Iterator<String> getExceptions() {
        return this.operation.getJavaMethod().getExceptions();
    }

    public int getOperationType() {
        String returnType = this.getReturnTypeName();
        if (returnType.startsWith("javax.xml.ws.Response")) {
            return 1;
        }
        if (returnType.startsWith("java.util.concurrent.Future")) {
            return 2;
        }
        return 0;
    }

    public String getOperationName() {
        if (this.operationName == null) {
            this.operationName = this.operation.getName().getLocalPart();
        }
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }
}

