/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.api.jaxws.project.JaxWsBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxwsmodel.project.TransformerUtils;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public class J2seBuildScriptExtensionProvider
implements JaxWsBuildScriptExtensionProvider {
    private static String COMPILE_ON_SAVE_UNSUPPORTED = "compile.on.save.unsupported.jaxws";
    static String JAX_WS_STYLESHEET_RESOURCE = "/org/netbeans/modules/websvc/jaxwsmodel/resources/jaxws-j2se.xsl";
    private Project project;

    public J2seBuildScriptExtensionProvider(Project project) {
        this.project = project;
    }

    @Override
    public void addJaxWsExtension(AntBuildExtender ext) throws IOException {
        TransformerUtils.transformClients(this.project.getProjectDirectory(), JAX_WS_STYLESHEET_RESOURCE);
        FileObject jaxws_build = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
        assert (jaxws_build != null);
        AntBuildExtender.Extension extension = ext.getExtension("jaxws");
        if (extension == null) {
            extension = ext.addExtension("jaxws", jaxws_build);
            extension.addDependency("-pre-pre-compile", "wsimport-client-generate");
            J2seBuildScriptExtensionProvider.disableCompileOnSave(this.project);
            ProjectManager.getDefault().saveProject(this.project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJaxWsExtension(final AntBuildExtender ext) throws IOException {
        FileLock fileLock;
        FileObject jaxws_build;
        AntBuildExtender.Extension extension = ext.getExtension("jaxws");
        if (extension != null) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                @Override
                public void run() {
                    ext.removeExtension("jaxws");
                }
            });
            this.enableCompileOnSave();
            ProjectManager.getDefault().saveProject(this.project);
        }
        if ((jaxws_build = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml")) != null && (fileLock = jaxws_build.lock()) != null) {
            try {
                jaxws_build.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    private static void disableCompileOnSave(Project prj) throws IOException {
        EditableProperties props = WSUtils.getEditableProperties(prj, "nbproject/project.properties");
        props.put(COMPILE_ON_SAVE_UNSUPPORTED, "true");
        WSUtils.storeEditableProperties(prj, "nbproject/project.properties", props);
    }

    private void enableCompileOnSave() throws IOException {
        EditableProperties props = WSUtils.getEditableProperties(this.project, "nbproject/project.properties");
        props.remove((Object)COMPILE_ON_SAVE_UNSUPPORTED);
        WSUtils.storeEditableProperties(this.project, "nbproject/project.properties", props);
    }

    @Override
    public void handleJaxWsModelChanges(JaxWsModel model) throws IOException {
        AntBuildExtender ext = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        if (ext != null) {
            if (model.getClients().length == 0) {
                this.removeJaxWsExtension(ext);
            } else {
                this.addJaxWsExtension(ext);
            }
        }
    }
}

