/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.view;

import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ViewAction
extends ContextAction {
    private static final String HG_SCRIPTS_DIR = "scripts";

    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_View";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        File[] roots = HgUtils.getActionRoots(context);
        if (roots == null || roots.length == 0) {
            return;
        }
        final File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        String repository = root.getAbsolutePath();
        RequestProcessor rp = Mercurial.getInstance().getParallelRequestProcessor();
        rp.post(new Runnable(){

            @Override
            public void run() {
                ViewAction.performView(root);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performView(File root) {
        OutputLogger logger = OutputLogger.getLogger(root);
        try {
            logger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_TITLE"));
            logger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_TITLE_SEP"));
            String hgkCommand = "hgk";
            if (Utilities.isWindows()) {
                hgkCommand = hgkCommand + ".cmd";
            }
            boolean bHgkFound = false;
            if (HgUtils.isInUserPath(hgkCommand)) {
                bHgkFound = true;
            } else if (HgUtils.isSolaris()) {
                File f = new File("/usr/demo/mercurial", hgkCommand);
                if (f.exists() && f.isFile()) {
                    bHgkFound = true;
                }
            } else if (Utilities.isWindows()) {
                bHgkFound = HgUtils.isInUserPath(HG_SCRIPTS_DIR + File.separator + hgkCommand);
            }
            boolean bHgkPropExists = HgConfigFiles.getSysInstance().containsProperty("extensions", "hgext.hgk");
            if (!bHgkFound) {
                logger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_HGK_NOT_FOUND_INFO"));
                logger.output("");
                logger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_HGK_NOT_FOUND"));
                logger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_HGK_NOT_FOUND_TITLE"));
            }
            if (!bHgkPropExists) {
                boolean bConfirmSetHgkProp = false;
                bConfirmSetHgkProp = HgUtils.confirmDialog(ViewAction.class, "MSG_VIEW_SETHGK_PROP_CONFIRM_TITLE", "MSG_VIEW_SETHGK_PROP_CONFIRM_QUERY");
                if (bConfirmSetHgkProp) {
                    logger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_SETHGK_PROP_DO_INFO"));
                    HgConfigFiles hcf = HgConfigFiles.getSysInstance();
                    if (hcf.getException() == null) {
                        hcf.setProperty("hgext.hgk", "");
                    } else {
                        Mercurial.LOG.log(Level.WARNING, ViewAction.class.getName() + ": Cannot set hgk property");
                        Mercurial.LOG.log(Level.INFO, null, hcf.getException());
                        HgModuleConfig.notifyParsingError();
                    }
                } else {
                    logger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_NOTSETHGK_PROP_INFO"));
                    logger.output("");
                    logger.closeLog();
                    return;
                }
            }
            logger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_LAUNCH_INFO", (Object)root.getAbsolutePath()));
            logger.output("");
            HgCommand.doView(root, logger);
        }
        catch (HgException.HgCommandCanceledException hgkCommand) {
        }
        catch (HgException ex) {
            HgUtils.notifyException(ex);
        }
        finally {
            logger.closeLog();
        }
    }
}

