/**
 * An HTMLOptionsCollection is a list of nodes representing HTML option element. An individual node may be accessed by either ordinal index or the node's name or id attributes.Note: Collections in the HTML DOM are assumed to be live meaning that they are automatically updated when the underlying document is changed.
 */
var HTMLOptionsCollection = {
}
/**
 * This method retrieves a node specified by ordinal index. Nodes are numbered in tree order (depth-first traversal order).
 * @syntax hTMLOptionsCollection.item(index)
 * @param {Number} index The index of the node to be fetched. The index origin is 0.
 * @returns {Node} The Node at the corresponding position upon success. A value of null is returned if the index is out of range.
 */
HTMLOptionsCollection.prototype.item = function(index) {};

/**
 * This attribute specifies the length or size of the list. Exceptions on setting DOMException NOT_SUPPORTED_ERR: if setting the length is not allowed by the implementation.
 * @syntax hTMLOptionsCollection.length
 * @returns {Number} 
 */
HTMLOptionsCollection.prototype.length = new Number();

/**
 * This method retrieves a Node using a name. It first searches for a Node with a matching id attribute. If it doesn't find one, it then searches for a Node with a matching name attribute, but only on those elements that are allowed a name attribute. This method is case insensitive in HTML documents
 * @syntax hTMLOptionsCollection.namedItem(name)
 * @param {String} name The name of the Node to be fetched.
 * @returns {Node} The Node with a name or id attribute whose value corresponds to the specified string. Upon failure (e.g., no node with this name exists), returns null.
 */
HTMLOptionsCollection.prototype.namedItem = function(name) {};

/**
 * Represents the HTMLOptionsCollection prototype object.
 * @syntax HTMLOptionsCollection.prototype
 * @static
 */
HTMLOptionsCollection.prototype;

