/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.SubSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SegmentedSequence
extends BasedSequenceImpl {
    private final BasedSequence baseSeq;
    private final char[] nonBaseChars;
    private final int[] baseOffsets;
    private final int baseStartOffset;
    private final int length;
    private final int startOffset;
    private final int endOffset;

    @Override
    public Object getBase() {
        return this.baseSeq.getBase();
    }

    @Override
    public BasedSequence getBaseSequence() {
        return this.baseSeq.getBaseSequence();
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public Range getIndexRange(int startOffset, int endOffset) {
        int start = Integer.MIN_VALUE;
        int end = Integer.MIN_VALUE;
        for (int i = 0; i < this.baseOffsets.length; ++i) {
            if (this.baseOffsets[i] == startOffset) {
                start = i;
            }
            if (this.baseOffsets[i] == endOffset) {
                end = i;
            }
            if (start != Integer.MIN_VALUE && end != Integer.MIN_VALUE) break;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < start) {
            end = start;
        }
        if (start > end) {
            start = end;
        }
        return Range.of(start, end);
    }

    public int[] getBaseOffsets() {
        return this.baseOffsets;
    }

    public int getBaseStartOffset() {
        return this.baseStartOffset;
    }

    @Override
    public int getIndexOffset(int index) {
        if (index < 0 || index > this.length) {
            throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
        }
        if (index == this.length) {
            if (this.length == 0) {
                throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
            }
            int offset = this.baseOffsets[this.baseStartOffset + index - 1];
            if (offset < 0) {
                return -1;
            }
            return offset + 1;
        }
        int offset = this.baseOffsets[this.baseStartOffset + index];
        return offset < 0 ? -1 : offset;
    }

    public static BasedSequence of(List<BasedSequence> segments) {
        if (segments.size() != 0) {
            BasedSequence lastSegment = null;
            BasedSequence firstSegment = segments.get(0);
            BasedSequence base = firstSegment.getBaseSequence();
            ArrayList<BasedSequence> mergedSequences = new ArrayList<BasedSequence>();
            int startOffset = -1;
            int endOffset = -1;
            for (BasedSequence segment : segments) {
                if (segment.isNull()) continue;
                if (base.getBase() != segment.getBase()) assert (false) : "all segments must come from the same base sequence";
                if (startOffset == -1) {
                    startOffset = segment.getStartOffset();
                }
                endOffset = segment.getEndOffset();
                if (segment.isEmpty()) continue;
                if (segment instanceof PrefixedSubSequence || segment instanceof SegmentedSequence) {
                    if (lastSegment != null) {
                        mergedSequences.add(lastSegment);
                    }
                    mergedSequences.add(segment);
                    lastSegment = null;
                    continue;
                }
                if (lastSegment == null) {
                    lastSegment = segment;
                    continue;
                }
                if (lastSegment.getEndOffset() != segment.getStartOffset()) {
                    mergedSequences.add(lastSegment);
                    lastSegment = segment;
                    continue;
                }
                lastSegment = lastSegment.baseSubSequence(lastSegment.getStartOffset(), segment.getEndOffset());
            }
            if (lastSegment != null) {
                mergedSequences.add(lastSegment);
            }
            if (mergedSequences.size() == 1) {
                return (BasedSequence)mergedSequences.get(0);
            }
            if (mergedSequences.size() != 0) {
                return new SegmentedSequence(mergedSequences, startOffset, endOffset);
            }
        }
        return SubSequence.NULL;
    }

    private SegmentedSequence(List<BasedSequence> segments, int startOffset, int endOffset) {
        this.baseSeq = segments.get(0).getBaseSequence();
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        int length = 0;
        BasedSequence base = segments.size() > 0 ? segments.get(0).getBaseSequence() : SubSequence.NULL;
        int index = 0;
        int lastEnd = base.getStartOffset();
        for (BasedSequence segment : segments) {
            assert (base.getBase() == segment.getBase()) : "all segments must come from the same base sequence, segments[" + index + "], length so far: " + length;
            if (segment.getStartOffset() < lastEnd) assert (false) : "segments must be in increasing index order from base sequence start=" + segment.getStartOffset() + ", length=" + length + " at index: " + index;
            lastEnd = segment.getEndOffset();
            length += segment.length();
            ++index;
        }
        this.baseStartOffset = 0;
        this.length = length;
        this.baseOffsets = new int[length];
        int len = 0;
        StringBuilder sb = null;
        for (BasedSequence basedSequence : segments) {
            int ciMax = basedSequence.length();
            for (int ci = 0; ci < ciMax; ++ci) {
                int offset = basedSequence.getIndexOffset(ci);
                if (offset < 0) {
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append(basedSequence.charAt(ci));
                    offset = -sb.length();
                }
                assert (ci + len < this.baseOffsets.length) : "Incorrect array size calculation: length: " + length + " ci + len: " + (ci + len);
                this.baseOffsets[ci + len] = offset;
            }
            len += ciMax;
        }
        this.nonBaseChars = (char[])(sb != null ? sb.toString().toCharArray() : null);
    }

    private SegmentedSequence(BasedSequence baseSeq, int[] baseOffsets, int baseStartOffset, char[] nonBaseChars, int length) {
        int iMax = baseOffsets.length;
        assert (baseStartOffset + length <= iMax) : "Sub-sequence offsets list length < baseStartOffset + sub-sequence length";
        int startOffset = 0;
        int endOffset = 0;
        if (nonBaseChars == null) {
            startOffset = baseStartOffset < iMax ? baseOffsets[baseStartOffset] : baseSeq.getEndOffset();
            if (length == 0) {
                endOffset = startOffset;
            } else {
                endOffset = baseOffsets[baseStartOffset + length - 1] + 1;
                assert (startOffset <= endOffset);
            }
        } else {
            boolean finished = false;
            for (int iS = baseStartOffset; iS < iMax; ++iS) {
                if (baseOffsets[iS] < 0) continue;
                startOffset = baseOffsets[iS];
                if (length != 0) {
                    int iE = baseStartOffset + length;
                    while (iE-- > iS) {
                        if (baseOffsets[iE] < 0) continue;
                        endOffset = baseOffsets[iE] + 1;
                        assert (startOffset <= endOffset);
                        finished = true;
                        break;
                    }
                }
                if (!finished) {
                    endOffset = startOffset;
                }
                finished = true;
                break;
            }
            if (!finished) {
                endOffset = startOffset = baseSeq.getEndOffset();
            }
        }
        this.baseSeq = baseSeq;
        this.baseOffsets = baseOffsets;
        this.baseStartOffset = baseStartOffset;
        this.nonBaseChars = nonBaseChars;
        this.length = length;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public Range getSourceRange() {
        return new Range(this.getStartOffset(), this.getEndOffset());
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException("String index: " + index + " out of range: 0, " + this.length());
        }
        int offset = this.baseOffsets[this.baseStartOffset + index];
        if (offset < 0) {
            return this.nonBaseChars[-offset - 1];
        }
        return this.baseSeq.charAt(offset);
    }

    @Override
    public BasedSequence baseSubSequence(int start, int end) {
        if (start < 0 || start > this.baseSeq.length()) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + start);
        }
        if (end < 0 || end > this.baseSeq.length()) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + end);
        }
        return this.baseSeq.baseSubSequence(start, end);
    }

    @Override
    public BasedSequence subSequence(int start, int end) {
        if (start < 0 || start > this.length) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + start);
        }
        if (end < 0 || end > this.length) {
            throw new StringIndexOutOfBoundsException("String index out of range: " + end);
        }
        if (start == 0 && end == this.length) {
            return this;
        }
        return new SegmentedSequence(this.baseSeq, this.baseOffsets, this.baseStartOffset + start, this.nonBaseChars, end - start);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof CharSequence && this.toString().equals(obj.toString());
    }

    public static BasedSequence of(BasedSequence ... segments) {
        return SegmentedSequence.of(Arrays.asList(segments));
    }
}

