/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.adm.requests.DeleteVulnerabilityAuditRequest;
import com.oracle.bmc.adm.responses.DeleteVulnerabilityAuditResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteVulnerabilityAuditConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteVulnerabilityAuditConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static DeleteVulnerabilityAuditRequest interceptRequest(DeleteVulnerabilityAuditRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DeleteVulnerabilityAuditRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getVulnerabilityAuditId(), (String)"vulnerabilityAuditId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20220421").path("vulnerabilityAudits").path(HttpUtils.encodePathSegment((String)request.getVulnerabilityAuditId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, DeleteVulnerabilityAuditResponse> fromResponse() {
        Function<Response, DeleteVulnerabilityAuditResponse> transformer = new Function<Response, DeleteVulnerabilityAuditResponse>(){

            public DeleteVulnerabilityAuditResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.adm.responses.DeleteVulnerabilityAuditResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                DeleteVulnerabilityAuditResponse.Builder builder = DeleteVulnerabilityAuditResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                DeleteVulnerabilityAuditResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

