/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger.models;

import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.cpplite.debugger.CPPFrame;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebugger;
import org.netbeans.modules.cpplite.debugger.CPPThread;
import org.netbeans.modules.cpplite.debugger.models.Bundle;
import org.netbeans.modules.nativeimage.api.debug.NIVariable;
import org.netbeans.modules.nativeimage.spi.debug.filters.VariableDisplayer;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.WeakListeners;

public class VariablesModel
implements TreeModel,
NodeModel,
TableModel,
CPPLiteDebugger.StateListener {
    private static final String LOCAL = "org/netbeans/modules/debugger/resources/localsView/LocalVariable";
    private static final Object[] NO_VARS = new Object[]{Bundle.CTL_VariablesModel_noVars()};
    private final CPPLiteDebugger debugger;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private final VariableDisplayer displayer;
    private volatile CPPFrame currentFrame;

    public VariablesModel(ContextProvider contextProvider) {
        this.debugger = (CPPLiteDebugger)contextProvider.lookupFirst(null, CPPLiteDebugger.class);
        this.debugger.addStateListener((CPPLiteDebugger.StateListener)WeakListeners.create(CPPLiteDebugger.StateListener.class, (EventListener)this, (Object)this.debugger));
        this.displayer = (VariableDisplayer)contextProvider.lookupFirst(null, VariableDisplayer.class);
        this.currentFrame = this.debugger.getCurrentFrame();
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        NIVariable parentVar;
        if (parent == "Root") {
            parentVar = null;
        } else if (parent instanceof NIVariable) {
            parentVar = (NIVariable)parent;
        } else {
            throw new UnknownTypeException(parent);
        }
        CPPFrame frame = this.currentFrame;
        if (frame != null) {
            Object[] array;
            if (parentVar == null) {
                Map<String, NIVariable> variables = frame.getVariables();
                array = variables.values().toArray(new NIVariable[0]);
                if (array.length == 1 && array[0] == null) {
                    return new Object[]{variables.keySet().iterator().next()};
                }
            } else {
                array = parentVar.getChildren(from, to);
            }
            if (this.displayer != null) {
                array = this.displayer.displayed((NIVariable[])array);
            }
            return array;
        }
        return NO_VARS;
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof String) {
            return true;
        }
        if (node instanceof NIVariable) {
            return ((NIVariable)node).getNumChildren() == 0;
        }
        throw new UnknownTypeException(node);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return Integer.MAX_VALUE;
        }
        if (node instanceof NIVariable) {
            return ((NIVariable)node).getNumChildren();
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            return (String)node;
        }
        if (node instanceof NIVariable) {
            return ((NIVariable)node).getName();
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        if (node instanceof NIVariable) {
            return LOCAL;
        }
        if (node instanceof String) {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            return null;
        }
        throw new UnknownTypeException(node);
    }

    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (columnID.equals("LocalsValue") && node instanceof NIVariable) {
            return ((NIVariable)node).getValue();
        }
        if (columnID.equals("LocalsType") && node instanceof NIVariable) {
            return ((NIVariable)node).getType();
        }
        if (node instanceof String) {
            return "";
        }
        throw new UnknownTypeException(node);
    }

    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof String && columnID.equals("LocalsValue")) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        throw new UnknownTypeException(node);
    }

    void fireChanges() {
        ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)this);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)event);
        }
    }

    @Override
    public void currentThread(CPPThread thread) {
    }

    @Override
    public void currentFrame(CPPFrame frame) {
        this.currentFrame = frame;
        this.fireChanges();
    }

    @Override
    public void suspended(boolean suspended) {
    }

    @Override
    public void finished() {
    }
}

