/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.devops.Devops;
import com.oracle.bmc.devops.model.BuildPipeline;
import com.oracle.bmc.devops.model.BuildPipelineStage;
import com.oracle.bmc.devops.model.BuildRun;
import com.oracle.bmc.devops.model.Connection;
import com.oracle.bmc.devops.model.DeployArtifact;
import com.oracle.bmc.devops.model.DeployEnvironment;
import com.oracle.bmc.devops.model.DeployPipeline;
import com.oracle.bmc.devops.model.DeployStage;
import com.oracle.bmc.devops.model.Deployment;
import com.oracle.bmc.devops.model.Project;
import com.oracle.bmc.devops.model.Repository;
import com.oracle.bmc.devops.model.Trigger;
import com.oracle.bmc.devops.requests.GetBuildPipelineRequest;
import com.oracle.bmc.devops.requests.GetBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.GetBuildRunRequest;
import com.oracle.bmc.devops.requests.GetConnectionRequest;
import com.oracle.bmc.devops.requests.GetDeployArtifactRequest;
import com.oracle.bmc.devops.requests.GetDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.GetDeployPipelineRequest;
import com.oracle.bmc.devops.requests.GetDeployStageRequest;
import com.oracle.bmc.devops.requests.GetDeploymentRequest;
import com.oracle.bmc.devops.requests.GetProjectRequest;
import com.oracle.bmc.devops.requests.GetRepositoryRequest;
import com.oracle.bmc.devops.requests.GetTriggerRequest;
import com.oracle.bmc.devops.requests.GetWorkRequestRequest;
import com.oracle.bmc.devops.responses.GetBuildPipelineResponse;
import com.oracle.bmc.devops.responses.GetBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.GetBuildRunResponse;
import com.oracle.bmc.devops.responses.GetConnectionResponse;
import com.oracle.bmc.devops.responses.GetDeployArtifactResponse;
import com.oracle.bmc.devops.responses.GetDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.GetDeployPipelineResponse;
import com.oracle.bmc.devops.responses.GetDeployStageResponse;
import com.oracle.bmc.devops.responses.GetDeploymentResponse;
import com.oracle.bmc.devops.responses.GetProjectResponse;
import com.oracle.bmc.devops.responses.GetRepositoryResponse;
import com.oracle.bmc.devops.responses.GetTriggerResponse;
import com.oracle.bmc.devops.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class DevopsWaiters {
    private final ExecutorService executorService;
    private final Devops client;

    public Waiter<GetBuildPipelineRequest, GetBuildPipelineResponse> forBuildPipeline(GetBuildPipelineRequest request, BuildPipeline.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBuildPipeline(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBuildPipelineRequest, GetBuildPipelineResponse> forBuildPipeline(GetBuildPipelineRequest request, BuildPipeline.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBuildPipeline(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBuildPipelineRequest, GetBuildPipelineResponse> forBuildPipeline(GetBuildPipelineRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BuildPipeline.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBuildPipeline(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBuildPipelineRequest, GetBuildPipelineResponse> forBuildPipeline(BmcGenericWaiter waiter, GetBuildPipelineRequest request, BuildPipeline.LifecycleState ... targetStates) {
        final HashSet<BuildPipeline.LifecycleState> targetStatesSet = new HashSet<BuildPipeline.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetBuildPipelineRequest, GetBuildPipelineResponse>(){

            public GetBuildPipelineResponse apply(GetBuildPipelineRequest request) {
                return DevopsWaiters.this.client.getBuildPipeline(request);
            }
        }, (Predicate)new Predicate<GetBuildPipelineResponse>(){

            public boolean apply(GetBuildPipelineResponse response) {
                return targetStatesSet.contains((Object)response.getBuildPipeline().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BuildPipeline.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetBuildPipelineStageRequest, GetBuildPipelineStageResponse> forBuildPipelineStage(GetBuildPipelineStageRequest request, BuildPipelineStage.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBuildPipelineStage(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBuildPipelineStageRequest, GetBuildPipelineStageResponse> forBuildPipelineStage(GetBuildPipelineStageRequest request, BuildPipelineStage.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBuildPipelineStage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBuildPipelineStageRequest, GetBuildPipelineStageResponse> forBuildPipelineStage(GetBuildPipelineStageRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BuildPipelineStage.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBuildPipelineStage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBuildPipelineStageRequest, GetBuildPipelineStageResponse> forBuildPipelineStage(BmcGenericWaiter waiter, GetBuildPipelineStageRequest request, BuildPipelineStage.LifecycleState ... targetStates) {
        final HashSet<BuildPipelineStage.LifecycleState> targetStatesSet = new HashSet<BuildPipelineStage.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetBuildPipelineStageRequest, GetBuildPipelineStageResponse>(){

            public GetBuildPipelineStageResponse apply(GetBuildPipelineStageRequest request) {
                return DevopsWaiters.this.client.getBuildPipelineStage(request);
            }
        }, (Predicate)new Predicate<GetBuildPipelineStageResponse>(){

            public boolean apply(GetBuildPipelineStageResponse response) {
                return targetStatesSet.contains((Object)response.getBuildPipelineStage().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BuildPipelineStage.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetBuildRunRequest, GetBuildRunResponse> forBuildRun(GetBuildRunRequest request, BuildRun.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBuildRun(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBuildRunRequest, GetBuildRunResponse> forBuildRun(GetBuildRunRequest request, BuildRun.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBuildRun(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBuildRunRequest, GetBuildRunResponse> forBuildRun(GetBuildRunRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BuildRun.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBuildRun(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBuildRunRequest, GetBuildRunResponse> forBuildRun(BmcGenericWaiter waiter, GetBuildRunRequest request, BuildRun.LifecycleState ... targetStates) {
        final HashSet<BuildRun.LifecycleState> targetStatesSet = new HashSet<BuildRun.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetBuildRunRequest, GetBuildRunResponse>(){

            public GetBuildRunResponse apply(GetBuildRunRequest request) {
                return DevopsWaiters.this.client.getBuildRun(request);
            }
        }, (Predicate)new Predicate<GetBuildRunResponse>(){

            public boolean apply(GetBuildRunResponse response) {
                return targetStatesSet.contains((Object)response.getBuildRun().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(GetConnectionRequest request, Connection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConnection(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(GetConnectionRequest request, Connection.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(GetConnectionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Connection.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forConnection(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetConnectionRequest, GetConnectionResponse> forConnection(BmcGenericWaiter waiter, GetConnectionRequest request, Connection.LifecycleState ... targetStates) {
        final HashSet<Connection.LifecycleState> targetStatesSet = new HashSet<Connection.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetConnectionRequest, GetConnectionResponse>(){

            public GetConnectionResponse apply(GetConnectionRequest request) {
                return DevopsWaiters.this.client.getConnection(request);
            }
        }, (Predicate)new Predicate<GetConnectionResponse>(){

            public boolean apply(GetConnectionResponse response) {
                return targetStatesSet.contains((Object)response.getConnection().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetDeployArtifactRequest, GetDeployArtifactResponse> forDeployArtifact(GetDeployArtifactRequest request, DeployArtifact.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeployArtifact(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDeployArtifactRequest, GetDeployArtifactResponse> forDeployArtifact(GetDeployArtifactRequest request, DeployArtifact.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDeployArtifact(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDeployArtifactRequest, GetDeployArtifactResponse> forDeployArtifact(GetDeployArtifactRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DeployArtifact.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDeployArtifact(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDeployArtifactRequest, GetDeployArtifactResponse> forDeployArtifact(BmcGenericWaiter waiter, GetDeployArtifactRequest request, DeployArtifact.LifecycleState ... targetStates) {
        final HashSet<DeployArtifact.LifecycleState> targetStatesSet = new HashSet<DeployArtifact.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDeployArtifactRequest, GetDeployArtifactResponse>(){

            public GetDeployArtifactResponse apply(GetDeployArtifactRequest request) {
                return DevopsWaiters.this.client.getDeployArtifact(request);
            }
        }, (Predicate)new Predicate<GetDeployArtifactResponse>(){

            public boolean apply(GetDeployArtifactResponse response) {
                return targetStatesSet.contains((Object)response.getDeployArtifact().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DeployArtifact.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDeployEnvironmentRequest, GetDeployEnvironmentResponse> forDeployEnvironment(GetDeployEnvironmentRequest request, DeployEnvironment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeployEnvironment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDeployEnvironmentRequest, GetDeployEnvironmentResponse> forDeployEnvironment(GetDeployEnvironmentRequest request, DeployEnvironment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDeployEnvironment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDeployEnvironmentRequest, GetDeployEnvironmentResponse> forDeployEnvironment(GetDeployEnvironmentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DeployEnvironment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDeployEnvironment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDeployEnvironmentRequest, GetDeployEnvironmentResponse> forDeployEnvironment(BmcGenericWaiter waiter, GetDeployEnvironmentRequest request, DeployEnvironment.LifecycleState ... targetStates) {
        final HashSet<DeployEnvironment.LifecycleState> targetStatesSet = new HashSet<DeployEnvironment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDeployEnvironmentRequest, GetDeployEnvironmentResponse>(){

            public GetDeployEnvironmentResponse apply(GetDeployEnvironmentRequest request) {
                return DevopsWaiters.this.client.getDeployEnvironment(request);
            }
        }, (Predicate)new Predicate<GetDeployEnvironmentResponse>(){

            public boolean apply(GetDeployEnvironmentResponse response) {
                return targetStatesSet.contains((Object)response.getDeployEnvironment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DeployEnvironment.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDeployPipelineRequest, GetDeployPipelineResponse> forDeployPipeline(GetDeployPipelineRequest request, DeployPipeline.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeployPipeline(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDeployPipelineRequest, GetDeployPipelineResponse> forDeployPipeline(GetDeployPipelineRequest request, DeployPipeline.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDeployPipeline(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDeployPipelineRequest, GetDeployPipelineResponse> forDeployPipeline(GetDeployPipelineRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DeployPipeline.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDeployPipeline(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDeployPipelineRequest, GetDeployPipelineResponse> forDeployPipeline(BmcGenericWaiter waiter, GetDeployPipelineRequest request, DeployPipeline.LifecycleState ... targetStates) {
        final HashSet<DeployPipeline.LifecycleState> targetStatesSet = new HashSet<DeployPipeline.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDeployPipelineRequest, GetDeployPipelineResponse>(){

            public GetDeployPipelineResponse apply(GetDeployPipelineRequest request) {
                return DevopsWaiters.this.client.getDeployPipeline(request);
            }
        }, (Predicate)new Predicate<GetDeployPipelineResponse>(){

            public boolean apply(GetDeployPipelineResponse response) {
                return targetStatesSet.contains((Object)response.getDeployPipeline().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DeployPipeline.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDeployStageRequest, GetDeployStageResponse> forDeployStage(GetDeployStageRequest request, DeployStage.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeployStage(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDeployStageRequest, GetDeployStageResponse> forDeployStage(GetDeployStageRequest request, DeployStage.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDeployStage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDeployStageRequest, GetDeployStageResponse> forDeployStage(GetDeployStageRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DeployStage.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDeployStage(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDeployStageRequest, GetDeployStageResponse> forDeployStage(BmcGenericWaiter waiter, GetDeployStageRequest request, DeployStage.LifecycleState ... targetStates) {
        final HashSet<DeployStage.LifecycleState> targetStatesSet = new HashSet<DeployStage.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDeployStageRequest, GetDeployStageResponse>(){

            public GetDeployStageResponse apply(GetDeployStageRequest request) {
                return DevopsWaiters.this.client.getDeployStage(request);
            }
        }, (Predicate)new Predicate<GetDeployStageResponse>(){

            public boolean apply(GetDeployStageResponse response) {
                return targetStatesSet.contains((Object)response.getDeployStage().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DeployStage.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(GetDeploymentRequest request, Deployment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeployment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(GetDeploymentRequest request, Deployment.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(GetDeploymentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Deployment.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(BmcGenericWaiter waiter, GetDeploymentRequest request, Deployment.LifecycleState ... targetStates) {
        final HashSet<Deployment.LifecycleState> targetStatesSet = new HashSet<Deployment.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDeploymentRequest, GetDeploymentResponse>(){

            public GetDeploymentResponse apply(GetDeploymentRequest request) {
                return DevopsWaiters.this.client.getDeployment(request);
            }
        }, (Predicate)new Predicate<GetDeploymentResponse>(){

            public boolean apply(GetDeploymentResponse response) {
                return targetStatesSet.contains((Object)response.getDeployment().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, Project.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forProject(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, Project.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forProject(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetProjectRequest, GetProjectResponse> forProject(GetProjectRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Project.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forProject(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetProjectRequest, GetProjectResponse> forProject(BmcGenericWaiter waiter, GetProjectRequest request, Project.LifecycleState ... targetStates) {
        final HashSet<Project.LifecycleState> targetStatesSet = new HashSet<Project.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetProjectRequest, GetProjectResponse>(){

            public GetProjectResponse apply(GetProjectRequest request) {
                return DevopsWaiters.this.client.getProject(request);
            }
        }, (Predicate)new Predicate<GetProjectResponse>(){

            public boolean apply(GetProjectResponse response) {
                return targetStatesSet.contains((Object)response.getProject().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Project.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetRepositoryRequest, GetRepositoryResponse> forRepository(GetRepositoryRequest request, Repository.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forRepository(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetRepositoryRequest, GetRepositoryResponse> forRepository(GetRepositoryRequest request, Repository.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forRepository(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetRepositoryRequest, GetRepositoryResponse> forRepository(GetRepositoryRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Repository.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forRepository(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetRepositoryRequest, GetRepositoryResponse> forRepository(BmcGenericWaiter waiter, GetRepositoryRequest request, Repository.LifecycleState ... targetStates) {
        final HashSet<Repository.LifecycleState> targetStatesSet = new HashSet<Repository.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetRepositoryRequest, GetRepositoryResponse>(){

            public GetRepositoryResponse apply(GetRepositoryRequest request) {
                return DevopsWaiters.this.client.getRepository(request);
            }
        }, (Predicate)new Predicate<GetRepositoryResponse>(){

            public boolean apply(GetRepositoryResponse response) {
                return targetStatesSet.contains((Object)response.getRepository().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Repository.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetTriggerRequest, GetTriggerResponse> forTrigger(GetTriggerRequest request, Trigger.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forTrigger(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetTriggerRequest, GetTriggerResponse> forTrigger(GetTriggerRequest request, Trigger.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forTrigger(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetTriggerRequest, GetTriggerResponse> forTrigger(GetTriggerRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Trigger.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forTrigger(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetTriggerRequest, GetTriggerResponse> forTrigger(BmcGenericWaiter waiter, GetTriggerRequest request, Trigger.LifecycleState ... targetStates) {
        final HashSet<Trigger.LifecycleState> targetStatesSet = new HashSet<Trigger.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetTriggerRequest, GetTriggerResponse>(){

            public GetTriggerResponse apply(GetTriggerRequest request) {
                return DevopsWaiters.this.client.getTrigger(request);
            }
        }, (Predicate)new Predicate<GetTriggerResponse>(){

            public boolean apply(GetTriggerResponse response) {
                return targetStatesSet.contains((Object)response.getTrigger().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DevopsWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public DevopsWaiters(ExecutorService executorService, Devops client) {
        this.executorService = executorService;
        this.client = client;
    }
}

