/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.devops.requests.GetObjectContentRequest;
import com.oracle.bmc.devops.responses.GetObjectContentResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.HttpUtils;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetObjectContentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetObjectContentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetObjectContentRequest interceptRequest(GetObjectContentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetObjectContentRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getSha(), (String)"sha must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20210630").path("repositories").path(HttpUtils.encodePathSegment((String)request.getRepositoryId())).path("objects").path(HttpUtils.encodePathSegment((String)request.getSha())).path("content");
        if (request.getFilePath() != null) {
            target = target.queryParam("filePath", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getFilePath())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, GetObjectContentResponse> fromResponse() {
        Function<Response, GetObjectContentResponse> transformer = new Function<Response, GetObjectContentResponse>(){

            public GetObjectContentResponse apply(Response rawResponse) {
                Optional contentDispositionHeader;
                Optional contentTypeHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.devops.responses.GetObjectContentResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(InputStream.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetObjectContentResponse.Builder builder = GetObjectContentResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.inputStream((InputStream)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((contentTypeHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"Content-Type")).isPresent()) {
                    builder.contentType((String)HeaderUtils.toValue((String)"Content-Type", (String)((String)((List)contentTypeHeader.get()).get(0)), String.class));
                }
                if ((contentDispositionHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"Content-Disposition")).isPresent()) {
                    builder.contentDisposition((String)HeaderUtils.toValue((String)"Content-Disposition", (String)((String)((List)contentDispositionHeader.get()).get(0)), String.class));
                }
                GetObjectContentResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

