/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import javax.ws.rs.client.Invocation;

public class ListCommitsRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private String refName;
    private String excludeRefName;
    private String filePath;
    private Date timestampGreaterThanOrEqualTo;
    private Date timestampLessThanOrEqualTo;
    private String commitMessage;
    private String authorName;
    private Integer limit;
    private String page;
    private String opcRequestId;

    @ConstructorProperties(value={"repositoryId", "refName", "excludeRefName", "filePath", "timestampGreaterThanOrEqualTo", "timestampLessThanOrEqualTo", "commitMessage", "authorName", "limit", "page", "opcRequestId"})
    ListCommitsRequest(String repositoryId, String refName, String excludeRefName, String filePath, Date timestampGreaterThanOrEqualTo, Date timestampLessThanOrEqualTo, String commitMessage, String authorName, Integer limit, String page, String opcRequestId) {
        this.repositoryId = repositoryId;
        this.refName = refName;
        this.excludeRefName = excludeRefName;
        this.filePath = filePath;
        this.timestampGreaterThanOrEqualTo = timestampGreaterThanOrEqualTo;
        this.timestampLessThanOrEqualTo = timestampLessThanOrEqualTo;
        this.commitMessage = commitMessage;
        this.authorName = authorName;
        this.limit = limit;
        this.page = page;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).refName(this.refName).excludeRefName(this.excludeRefName).filePath(this.filePath).timestampGreaterThanOrEqualTo(this.timestampGreaterThanOrEqualTo).timestampLessThanOrEqualTo(this.timestampLessThanOrEqualTo).commitMessage(this.commitMessage).authorName(this.authorName).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "ListCommitsRequest(super=" + super.toString() + ", repositoryId=" + this.getRepositoryId() + ", refName=" + this.getRefName() + ", excludeRefName=" + this.getExcludeRefName() + ", filePath=" + this.getFilePath() + ", timestampGreaterThanOrEqualTo=" + this.getTimestampGreaterThanOrEqualTo() + ", timestampLessThanOrEqualTo=" + this.getTimestampLessThanOrEqualTo() + ", commitMessage=" + this.getCommitMessage() + ", authorName=" + this.getAuthorName() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListCommitsRequest)) {
            return false;
        }
        ListCommitsRequest other = (ListCommitsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$repositoryId = this.getRepositoryId();
        String other$repositoryId = other.getRepositoryId();
        if (this$repositoryId == null ? other$repositoryId != null : !this$repositoryId.equals(other$repositoryId)) {
            return false;
        }
        String this$refName = this.getRefName();
        String other$refName = other.getRefName();
        if (this$refName == null ? other$refName != null : !this$refName.equals(other$refName)) {
            return false;
        }
        String this$excludeRefName = this.getExcludeRefName();
        String other$excludeRefName = other.getExcludeRefName();
        if (this$excludeRefName == null ? other$excludeRefName != null : !this$excludeRefName.equals(other$excludeRefName)) {
            return false;
        }
        String this$filePath = this.getFilePath();
        String other$filePath = other.getFilePath();
        if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
            return false;
        }
        Date this$timestampGreaterThanOrEqualTo = this.getTimestampGreaterThanOrEqualTo();
        Date other$timestampGreaterThanOrEqualTo = other.getTimestampGreaterThanOrEqualTo();
        if (this$timestampGreaterThanOrEqualTo == null ? other$timestampGreaterThanOrEqualTo != null : !((Object)this$timestampGreaterThanOrEqualTo).equals(other$timestampGreaterThanOrEqualTo)) {
            return false;
        }
        Date this$timestampLessThanOrEqualTo = this.getTimestampLessThanOrEqualTo();
        Date other$timestampLessThanOrEqualTo = other.getTimestampLessThanOrEqualTo();
        if (this$timestampLessThanOrEqualTo == null ? other$timestampLessThanOrEqualTo != null : !((Object)this$timestampLessThanOrEqualTo).equals(other$timestampLessThanOrEqualTo)) {
            return false;
        }
        String this$commitMessage = this.getCommitMessage();
        String other$commitMessage = other.getCommitMessage();
        if (this$commitMessage == null ? other$commitMessage != null : !this$commitMessage.equals(other$commitMessage)) {
            return false;
        }
        String this$authorName = this.getAuthorName();
        String other$authorName = other.getAuthorName();
        if (this$authorName == null ? other$authorName != null : !this$authorName.equals(other$authorName)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListCommitsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $repositoryId = this.getRepositoryId();
        result = result * 59 + ($repositoryId == null ? 43 : $repositoryId.hashCode());
        String $refName = this.getRefName();
        result = result * 59 + ($refName == null ? 43 : $refName.hashCode());
        String $excludeRefName = this.getExcludeRefName();
        result = result * 59 + ($excludeRefName == null ? 43 : $excludeRefName.hashCode());
        String $filePath = this.getFilePath();
        result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
        Date $timestampGreaterThanOrEqualTo = this.getTimestampGreaterThanOrEqualTo();
        result = result * 59 + ($timestampGreaterThanOrEqualTo == null ? 43 : ((Object)$timestampGreaterThanOrEqualTo).hashCode());
        Date $timestampLessThanOrEqualTo = this.getTimestampLessThanOrEqualTo();
        result = result * 59 + ($timestampLessThanOrEqualTo == null ? 43 : ((Object)$timestampLessThanOrEqualTo).hashCode());
        String $commitMessage = this.getCommitMessage();
        result = result * 59 + ($commitMessage == null ? 43 : $commitMessage.hashCode());
        String $authorName = this.getAuthorName();
        result = result * 59 + ($authorName == null ? 43 : $authorName.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRefName() {
        return this.refName;
    }

    public String getExcludeRefName() {
        return this.excludeRefName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Date getTimestampGreaterThanOrEqualTo() {
        return this.timestampGreaterThanOrEqualTo;
    }

    public Date getTimestampLessThanOrEqualTo() {
        return this.timestampLessThanOrEqualTo;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListCommitsRequest, Void> {
        private String repositoryId;
        private String refName;
        private String excludeRefName;
        private String filePath;
        private Date timestampGreaterThanOrEqualTo;
        private Date timestampLessThanOrEqualTo;
        private String commitMessage;
        private String authorName;
        private Integer limit;
        private String page;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListCommitsRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.refName(o.getRefName());
            this.excludeRefName(o.getExcludeRefName());
            this.filePath(o.getFilePath());
            this.timestampGreaterThanOrEqualTo(o.getTimestampGreaterThanOrEqualTo());
            this.timestampLessThanOrEqualTo(o.getTimestampLessThanOrEqualTo());
            this.commitMessage(o.getCommitMessage());
            this.authorName(o.getAuthorName());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListCommitsRequest build() {
            ListCommitsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder refName(String refName) {
            this.refName = refName;
            return this;
        }

        public Builder excludeRefName(String excludeRefName) {
            this.excludeRefName = excludeRefName;
            return this;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder timestampGreaterThanOrEqualTo(Date timestampGreaterThanOrEqualTo) {
            this.timestampGreaterThanOrEqualTo = timestampGreaterThanOrEqualTo;
            return this;
        }

        public Builder timestampLessThanOrEqualTo(Date timestampLessThanOrEqualTo) {
            this.timestampLessThanOrEqualTo = timestampLessThanOrEqualTo;
            return this;
        }

        public Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public Builder authorName(String authorName) {
            this.authorName = authorName;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListCommitsRequest buildWithoutInvocationCallback() {
            return new ListCommitsRequest(this.repositoryId, this.refName, this.excludeRefName, this.filePath, this.timestampGreaterThanOrEqualTo, this.timestampLessThanOrEqualTo, this.commitMessage, this.authorName, this.limit, this.page, this.opcRequestId);
        }

        public String toString() {
            return "ListCommitsRequest.Builder(repositoryId=" + this.repositoryId + ", refName=" + this.refName + ", excludeRefName=" + this.excludeRefName + ", filePath=" + this.filePath + ", timestampGreaterThanOrEqualTo=" + this.timestampGreaterThanOrEqualTo + ", timestampLessThanOrEqualTo=" + this.timestampLessThanOrEqualTo + ", commitMessage=" + this.commitMessage + ", authorName=" + this.authorName + ", limit=" + this.limit + ", page=" + this.page + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

