/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.mock.web.MockMultipartHttpServletRequest;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;

public class MockMultipartHttpServletRequestBuilder
extends MockHttpServletRequestBuilder {
    private final List<MockMultipartFile> files = new ArrayList<MockMultipartFile>();

    MockMultipartHttpServletRequestBuilder(String urlTemplate, Object ... uriVariables) {
        super(HttpMethod.POST, urlTemplate, uriVariables);
        super.contentType(MediaType.MULTIPART_FORM_DATA);
    }

    MockMultipartHttpServletRequestBuilder(URI uri) {
        super(HttpMethod.POST, uri);
        super.contentType(MediaType.MULTIPART_FORM_DATA);
    }

    public MockMultipartHttpServletRequestBuilder file(String name, byte[] content) {
        this.files.add(new MockMultipartFile(name, content));
        return this;
    }

    public MockMultipartHttpServletRequestBuilder file(MockMultipartFile file) {
        this.files.add(file);
        return this;
    }

    @Override
    public Object merge(Object parent) {
        if (parent == null) {
            return this;
        }
        if (parent instanceof MockHttpServletRequestBuilder) {
            super.merge(parent);
            if (parent instanceof MockMultipartHttpServletRequestBuilder) {
                MockMultipartHttpServletRequestBuilder parentBuilder = (MockMultipartHttpServletRequestBuilder)parent;
                this.files.addAll(parentBuilder.files);
            }
        } else {
            throw new IllegalArgumentException("Cannot merge with [" + parent.getClass().getName() + "]");
        }
        return this;
    }

    @Override
    protected final MockHttpServletRequest createServletRequest(ServletContext servletContext) {
        MockMultipartHttpServletRequest request = new MockMultipartHttpServletRequest(servletContext);
        for (MockMultipartFile file : this.files) {
            request.addFile(file);
        }
        return request;
    }
}

