/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.fontscolors;

import java.awt.Color;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.editor.settings.storage.NbUtils;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.StorageImpl;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.netbeans.modules.editor.settings.storage.spi.StorageReader;
import org.netbeans.modules.editor.settings.storage.spi.StorageWriter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class ColoringStorage
implements StorageDescription<String, AttributeSet>,
StorageImpl.Operations<String, AttributeSet> {
    private static final Logger LOG = Logger.getLogger(ColoringStorage.class.getName());
    public static final String ID = "FontsColors";
    static final String MIME_TYPE = "text/x-nbeditor-fontcolorsettings";
    private static final String HIGHLIGHTING_FILE_NAME = "editorColoring.xml";
    private static final String E_ROOT = "fontscolors";
    private static final String E_COLORDEF = "colordef";
    private static final String E_FONTCOLOR = "fontcolor";
    private static final String E_FONT = "font";
    private static final String A_NAME = "name";
    private static final String A_COLOR = "color";
    private static final String A_FOREGROUND = "foreColor";
    private static final String A_BACKGROUND = "bgColor";
    private static final String A_STRIKETHROUGH = "strikeThrough";
    private static final String A_WAVEUNDERLINE = "waveUnderlined";
    private static final String A_UNDERLINE = "underline";
    private static final String A_DEFAULT = "default";
    private static final String A_SIZE = "size";
    private static final String A_STYLE = "style";
    private static final String V_BOLD_ITALIC = "bold+italic";
    private static final String V_BOLD = "bold";
    private static final String V_ITALIC = "italic";
    private static final String V_PLAIN = "plain";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor Fonts and Colors settings 1.2//EN";
    private static final String SYSTEM_ID = "https://netbeans.apache.org/dtds/EditorFontsColors-1_2.dtd";
    private static final String FA_TYPE = "nbeditor-settings-ColoringType";
    public static final String FAV_TOKEN = "token";
    public static final String FAV_HIGHLIGHT = "highlight";
    public static final String FAV_ANNOTATION = "annotation";
    private static final Object ATTR_MODULE_SUPPLIED = new Object();
    private final String type;
    private static final Map<Color, String> colorToName = new HashMap<Color, String>();
    private static final Map<String, Color> nameToColor = new HashMap<String, Color>();

    public ColoringStorage(String type) {
        this.type = type;
    }

    public ColoringStorage() {
        this(FAV_TOKEN);
    }

    public String getId() {
        return ID;
    }

    public boolean isUsingProfiles() {
        return true;
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public String getLegacyFileName() {
        return null;
    }

    public StorageReader<String, AttributeSet> createReader(FileObject f, String mimePath) {
        throw new UnsupportedOperationException("Should not be called.");
    }

    public StorageWriter<String, AttributeSet> createWriter(FileObject f, String mimePath) {
        throw new UnsupportedOperationException("Should not be called.");
    }

    public Map<String, AttributeSet> load(MimePath mimePath, String profile, boolean defaults) {
        List<Object[]> filesForLocalization;
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (profile != null) : "The parameter profile must not be null";
        FileObject baseFolder = FileUtil.getConfigFile((String)"Editors");
        HashMap files = new HashMap();
        SettingsType.Locator locator = SettingsType.getLocator((StorageDescription)this);
        locator.scan(baseFolder, mimePath.getPath(), profile, true, true, !defaults, false, files);
        assert (files.size() <= 1) : "Too many results in the scan";
        List<Object[]> profileInfos = (List<Object[]>)files.get(profile);
        if (profileInfos == null) {
            return Collections.emptyMap();
        }
        if (!profile.equals("NetBeans")) {
            HashMap defaultProfileModulesFiles = new HashMap();
            locator.scan(baseFolder, mimePath.getPath(), "NetBeans", true, true, false, false, defaultProfileModulesFiles);
            filesForLocalization = (List)defaultProfileModulesFiles.get("NetBeans");
            if (filesForLocalization == null) {
                filesForLocalization = Collections.emptyList();
            }
        } else {
            filesForLocalization = profileInfos;
        }
        HashMap<String, SimpleAttributeSet> fontsColorsMap = new HashMap<String, SimpleAttributeSet>();
        for (Object[] info : profileInfos) {
            assert (info.length == 5);
            FileObject profileHome = (FileObject)info[0];
            FileObject settingFile = (FileObject)info[1];
            boolean modulesFile = (Boolean)info[2];
            boolean legacyFile = (Boolean)info[4];
            if (!this.type.equals(ColoringStorage.getColoringFileType(settingFile))) continue;
            ColoringsReader reader = new ColoringsReader(settingFile, mimePath.getPath());
            Utils.load((FileObject)settingFile, (StorageReader)reader, (!legacyFile ? 1 : 0) != 0);
            Map<String, SimpleAttributeSet> sets = reader.getAdded();
            for (SimpleAttributeSet as : sets.values()) {
                if (FAV_ANNOTATION.equals(this.type)) {
                    fontsColorsMap.put((String)as.getAttribute(StyleConstants.NameAttribute), as);
                    continue;
                }
                String name = (String)as.getAttribute(StyleConstants.NameAttribute);
                String translatedName = null;
                SimpleAttributeSet previous = (SimpleAttributeSet)fontsColorsMap.get(name);
                if (previous == null) {
                    String displayName = ColoringStorage.findDisplayName(name, settingFile, filesForLocalization);
                    if (displayName == null && !modulesFile) {
                        if (translatedName != null) {
                            displayName = ColoringStorage.findDisplayName(translatedName, settingFile, filesForLocalization);
                        }
                        if (displayName == null) {
                            if (!LOG.isLoggable(Level.FINE)) continue;
                            LOG.fine("Ignoring an extra coloring '" + name + "' that was not defined by modules.");
                            continue;
                        }
                        as.addAttribute(StyleConstants.NameAttribute, translatedName);
                        name = translatedName;
                    }
                    if (displayName == null) {
                        displayName = name;
                    }
                    as.addAttribute(EditorStyleConstants.DisplayName, displayName);
                    as.addAttribute(ATTR_MODULE_SUPPLIED, modulesFile);
                    fontsColorsMap.put(name, as);
                    continue;
                }
                boolean moduleSupplied = (Boolean)previous.getAttribute(ATTR_MODULE_SUPPLIED);
                if (moduleSupplied == modulesFile) {
                    ColoringStorage.mergeAttributeSets(previous, as);
                    continue;
                }
                as.addAttribute(EditorStyleConstants.DisplayName, previous.getAttribute(EditorStyleConstants.DisplayName));
                Object df = previous.getAttribute(EditorStyleConstants.Default);
                if (df != null) {
                    as.addAttribute(EditorStyleConstants.Default, df);
                }
                as.addAttribute(ATTR_MODULE_SUPPLIED, modulesFile);
                fontsColorsMap.put(name, as);
            }
        }
        return NbUtils.immutize(fontsColorsMap, ATTR_MODULE_SUPPLIED);
    }

    public boolean save(MimePath mimePath, String profile, boolean defaults, Map<String, AttributeSet> fontColors, Map<String, AttributeSet> defaultFontColors) throws IOException {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (profile != null) : "The parameter profile must not be null";
        String settingFileName = SettingsType.getLocator((StorageDescription)this).getWritableFileName(mimePath.getPath(), profile, FAV_TOKEN.equals(this.type) ? "-tokenColorings" : (FAV_HIGHLIGHT.equals(this.type) ? "-highlights" : "-annotations"), defaults);
        FileUtil.runAtomicAction(() -> {
            FileObject baseFolder = FileUtil.getConfigFile((String)"Editors");
            FileObject f = FileUtil.createData((FileObject)baseFolder, (String)settingFileName);
            f.setAttribute(FA_TYPE, (Object)this.type);
            HashMap added = new HashMap();
            HashMap removed = new HashMap();
            Utils.diff((Map)defaultFontColors, (Map)fontColors, added, removed);
            ColoringsWriter writer = new ColoringsWriter();
            writer.setAdded(added);
            writer.setRemoved(removed.keySet());
            Utils.save((FileObject)f, (StorageWriter)writer);
        });
        return true;
    }

    public void delete(MimePath mimePath, String profile, boolean defaults) throws IOException {
        assert (mimePath != null) : "The parameter mimePath must not be null";
        assert (profile != null) : "The parameter profile must not be null";
        FileObject baseFolder = FileUtil.getConfigFile((String)"Editors");
        HashMap files = new HashMap();
        SettingsType.getLocator((StorageDescription)this).scan(baseFolder, mimePath.getPath(), profile, true, defaults, !defaults, false, files);
        assert (files.size() <= 1) : "Too many results in the scan";
        List profileInfos = (List)files.get(profile);
        if (profileInfos != null) {
            FileUtil.runAtomicAction(() -> {
                for (Object[] info : profileInfos) {
                    FileObject settingFile = (FileObject)info[1];
                    if (!this.type.equals(ColoringStorage.getColoringFileType(settingFile))) continue;
                    settingFile.delete();
                }
            });
        }
    }

    private static String findDisplayName(String name, FileObject settingFile, List<Object[]> filesForLocalization) {
        String displayName;
        block1: {
            Object[] locFileInfo;
            FileObject locFile;
            displayName = Utils.getLocalizedName((FileObject)settingFile, (String)name, null, (boolean)true);
            if (displayName != null) break block1;
            Iterator<Object[]> iterator = filesForLocalization.iterator();
            while (iterator.hasNext() && (displayName = Utils.getLocalizedName((FileObject)(locFile = (FileObject)(locFileInfo = iterator.next())[1]), (String)name, null, (boolean)true)) == null) {
            }
        }
        return displayName;
    }

    private static void mergeAttributeSets(SimpleAttributeSet original, AttributeSet toMerge) {
        Enumeration<?> names = toMerge.getAttributeNames();
        while (names.hasMoreElements()) {
            Object key = names.nextElement();
            Object value = toMerge.getAttribute(key);
            original.addAttribute(key, value);
        }
    }

    private static String getColoringFileType(FileObject f) {
        Object typeValue = f.getAttribute(FA_TYPE);
        if (typeValue instanceof String) {
            return (String)typeValue;
        }
        if (f.getNameExt().equals(HIGHLIGHTING_FILE_NAME)) {
            return FAV_HIGHLIGHT;
        }
        return FAV_TOKEN;
    }

    private static String colorToString(Color color) {
        if (colorToName.containsKey(color)) {
            return colorToName.get(color);
        }
        return Integer.toHexString(color.getRGB());
    }

    private static Color stringToColor(String color) throws Exception {
        if (nameToColor.containsKey(color)) {
            return nameToColor.get(color);
        }
        try {
            return new Color((int)Long.parseLong(color, 16), color.length() != 6);
        }
        catch (NumberFormatException ex) {
            LOG.log(Level.WARNING, "Can''t parse ''{0}'' to a Color. Using RED as a replacement.", color);
            return Color.red;
        }
    }

    static {
        colorToName.put(Color.black, "black");
        nameToColor.put("black", Color.black);
        colorToName.put(Color.blue, "blue");
        nameToColor.put("blue", Color.blue);
        colorToName.put(Color.cyan, "cyan");
        nameToColor.put("cyan", Color.cyan);
        colorToName.put(Color.darkGray, "darkGray");
        nameToColor.put("darkGray", Color.darkGray);
        colorToName.put(Color.gray, "gray");
        nameToColor.put("gray", Color.gray);
        colorToName.put(Color.green, "green");
        nameToColor.put("green", Color.green);
        colorToName.put(Color.lightGray, "lightGray");
        nameToColor.put("lightGray", Color.lightGray);
        colorToName.put(Color.magenta, "magenta");
        nameToColor.put("magenta", Color.magenta);
        colorToName.put(Color.orange, "orange");
        nameToColor.put("orange", Color.orange);
        colorToName.put(Color.pink, "pink");
        nameToColor.put("pink", Color.pink);
        colorToName.put(Color.red, "red");
        nameToColor.put("red", Color.red);
        colorToName.put(Color.white, "white");
        nameToColor.put("white", Color.white);
        colorToName.put(Color.yellow, "yellow");
        nameToColor.put("yellow", Color.yellow);
    }

    private static final class ColoringsWriter
    extends StorageWriter<String, AttributeSet> {
        public Document getDocument() {
            Document doc = XMLUtil.createDocument((String)ColoringStorage.E_ROOT, null, (String)ColoringStorage.PUBLIC_ID, (String)ColoringStorage.SYSTEM_ID);
            Node root = doc.getElementsByTagName(ColoringStorage.E_ROOT).item(0);
            for (AttributeSet category : this.getAdded().values()) {
                Element fontColor = doc.createElement(ColoringStorage.E_FONTCOLOR);
                root.appendChild(fontColor);
                fontColor.setAttribute(ColoringStorage.A_NAME, (String)category.getAttribute(StyleConstants.NameAttribute));
                if (category.isDefined(StyleConstants.Foreground)) {
                    fontColor.setAttribute(ColoringStorage.A_FOREGROUND, ColoringStorage.colorToString((Color)category.getAttribute(StyleConstants.Foreground)));
                }
                if (category.isDefined(StyleConstants.Background)) {
                    fontColor.setAttribute(ColoringStorage.A_BACKGROUND, ColoringStorage.colorToString((Color)category.getAttribute(StyleConstants.Background)));
                }
                if (category.isDefined(StyleConstants.StrikeThrough)) {
                    fontColor.setAttribute(ColoringStorage.A_STRIKETHROUGH, ColoringStorage.colorToString((Color)category.getAttribute(StyleConstants.StrikeThrough)));
                }
                if (category.isDefined(EditorStyleConstants.WaveUnderlineColor)) {
                    fontColor.setAttribute(ColoringStorage.A_WAVEUNDERLINE, ColoringStorage.colorToString((Color)category.getAttribute(EditorStyleConstants.WaveUnderlineColor)));
                }
                if (category.isDefined(StyleConstants.Underline)) {
                    fontColor.setAttribute(ColoringStorage.A_UNDERLINE, ColoringStorage.colorToString((Color)category.getAttribute(StyleConstants.Underline)));
                }
                if (category.isDefined(EditorStyleConstants.Default)) {
                    fontColor.setAttribute(ColoringStorage.A_DEFAULT, (String)category.getAttribute(EditorStyleConstants.Default));
                }
                if (!category.isDefined(StyleConstants.FontFamily) && !category.isDefined(StyleConstants.FontSize) && !category.isDefined(StyleConstants.Bold) && !category.isDefined(StyleConstants.Italic)) continue;
                Element font = doc.createElement(ColoringStorage.E_FONT);
                fontColor.appendChild(font);
                if (category.isDefined(StyleConstants.FontFamily)) {
                    font.setAttribute(ColoringStorage.A_NAME, (String)category.getAttribute(StyleConstants.FontFamily));
                }
                if (category.isDefined(StyleConstants.FontSize)) {
                    font.setAttribute(ColoringStorage.A_SIZE, ((Integer)category.getAttribute(StyleConstants.FontSize)).toString());
                }
                if (!category.isDefined(StyleConstants.Bold) && !category.isDefined(StyleConstants.Italic)) continue;
                Boolean bold = Boolean.FALSE;
                Boolean italic = Boolean.FALSE;
                if (category.isDefined(StyleConstants.Bold)) {
                    bold = (Boolean)category.getAttribute(StyleConstants.Bold);
                }
                if (category.isDefined(StyleConstants.Italic)) {
                    italic = (Boolean)category.getAttribute(StyleConstants.Italic);
                }
                font.setAttribute(ColoringStorage.A_STYLE, bold.booleanValue() ? (italic.booleanValue() ? ColoringStorage.V_BOLD_ITALIC : ColoringStorage.V_BOLD) : (italic != false ? ColoringStorage.V_ITALIC : ColoringStorage.V_PLAIN));
            }
            return doc;
        }
    }

    private static class ColoringsReader
    extends StorageReader<String, SimpleAttributeSet> {
        private final Map<String, String> colordefs = new HashMap<String, String>();
        private final Map<String, SimpleAttributeSet> colorings = new HashMap<String, SimpleAttributeSet>();
        private SimpleAttributeSet attribs = null;

        public ColoringsReader(FileObject f, String mimePath) {
            super(f, mimePath);
        }

        public Map<String, SimpleAttributeSet> getAdded() {
            return this.colorings;
        }

        public Set<String> getRemoved() {
            return Collections.emptySet();
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            try {
                switch (name) {
                    case "fontscolors": {
                        this.colordefs.clear();
                        break;
                    }
                    case "colordef": {
                        String nameAttr = attributes.getValue(ColoringStorage.A_NAME);
                        String colorAttr = attributes.getValue(ColoringStorage.A_COLOR);
                        String oldRef = this.colordefs.put(nameAttr, colorAttr);
                        if (oldRef == null) break;
                        LOG.log(Level.WARNING, "Color reference: '" + nameAttr + "' previously defined as '" + oldRef + "' is now '" + colorAttr + "'");
                        break;
                    }
                    case "fontcolor": {
                        assert (this.attribs == null);
                        this.attribs = new SimpleAttributeSet();
                        String nameAttributeValue = attributes.getValue(ColoringStorage.A_NAME);
                        this.attribs.addAttribute(StyleConstants.NameAttribute, nameAttributeValue);
                        String value = attributes.getValue(ColoringStorage.A_BACKGROUND);
                        if (value != null) {
                            this.attribs.addAttribute(StyleConstants.Background, this.stringToColor(value));
                        }
                        if ((value = attributes.getValue(ColoringStorage.A_FOREGROUND)) != null) {
                            this.attribs.addAttribute(StyleConstants.Foreground, this.stringToColor(value));
                        }
                        if ((value = attributes.getValue(ColoringStorage.A_UNDERLINE)) != null) {
                            this.attribs.addAttribute(StyleConstants.Underline, this.stringToColor(value));
                        }
                        if ((value = attributes.getValue(ColoringStorage.A_STRIKETHROUGH)) != null) {
                            this.attribs.addAttribute(StyleConstants.StrikeThrough, this.stringToColor(value));
                        }
                        if ((value = attributes.getValue(ColoringStorage.A_WAVEUNDERLINE)) != null) {
                            this.attribs.addAttribute(EditorStyleConstants.WaveUnderlineColor, this.stringToColor(value));
                        }
                        if ((value = attributes.getValue(ColoringStorage.A_DEFAULT)) != null) {
                            this.attribs.addAttribute(EditorStyleConstants.Default, value);
                        }
                        this.colorings.put(nameAttributeValue, this.attribs);
                        break;
                    }
                    case "font": {
                        assert (this.attribs != null);
                        String value = attributes.getValue(ColoringStorage.A_NAME);
                        if (value != null) {
                            this.attribs.addAttribute(StyleConstants.FontFamily, value);
                        }
                        if ((value = attributes.getValue(ColoringStorage.A_SIZE)) != null) {
                            try {
                                this.attribs.addAttribute(StyleConstants.FontSize, Integer.decode(value));
                            }
                            catch (NumberFormatException ex) {
                                LOG.log(Level.WARNING, value + " is not a valid Integer; parsing attribute " + ColoringStorage.A_SIZE + this.getProcessedFile().getPath(), ex);
                            }
                        }
                        if ((value = attributes.getValue(ColoringStorage.A_STYLE)) == null) break;
                        this.attribs.addAttribute(StyleConstants.Bold, value.contains(ColoringStorage.V_BOLD));
                        this.attribs.addAttribute(StyleConstants.Italic, value.contains(ColoringStorage.V_ITALIC));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Can't parse colorings file " + this.getProcessedFile().getPath(), ex);
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (name.equals(ColoringStorage.E_FONTCOLOR)) {
                this.attribs = null;
            }
        }

        Color stringToColor(String name) throws Exception {
            String resolve = this.colordefs.getOrDefault(name, name);
            return ColoringStorage.stringToColor(resolve);
        }
    }
}

