/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.Tag;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListTagsRequest
extends BmcRequest<Void> {
    private String tagNamespaceId;
    private String page;
    private Integer limit;
    private Tag.LifecycleState lifecycleState;

    @ConstructorProperties(value={"tagNamespaceId", "page", "limit", "lifecycleState"})
    ListTagsRequest(String tagNamespaceId, String page, Integer limit, Tag.LifecycleState lifecycleState) {
        this.tagNamespaceId = tagNamespaceId;
        this.page = page;
        this.limit = limit;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().tagNamespaceId(this.tagNamespaceId).page(this.page).limit(this.limit).lifecycleState(this.lifecycleState);
    }

    public String toString() {
        return "ListTagsRequest(super=" + super.toString() + ", tagNamespaceId=" + this.getTagNamespaceId() + ", page=" + this.getPage() + ", limit=" + this.getLimit() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListTagsRequest)) {
            return false;
        }
        ListTagsRequest other = (ListTagsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$tagNamespaceId = this.getTagNamespaceId();
        String other$tagNamespaceId = other.getTagNamespaceId();
        if (this$tagNamespaceId == null ? other$tagNamespaceId != null : !this$tagNamespaceId.equals(other$tagNamespaceId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        Tag.LifecycleState this$lifecycleState = this.getLifecycleState();
        Tag.LifecycleState other$lifecycleState = other.getLifecycleState();
        return !(this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListTagsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $tagNamespaceId = this.getTagNamespaceId();
        result = result * 59 + ($tagNamespaceId == null ? 43 : $tagNamespaceId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        Tag.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        return result;
    }

    public String getTagNamespaceId() {
        return this.tagNamespaceId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Tag.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTagsRequest, Void> {
        private String tagNamespaceId;
        private String page;
        private Integer limit;
        private Tag.LifecycleState lifecycleState;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTagsRequest o) {
            this.tagNamespaceId(o.getTagNamespaceId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTagsRequest build() {
            ListTagsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder tagNamespaceId(String tagNamespaceId) {
            this.tagNamespaceId = tagNamespaceId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder lifecycleState(Tag.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public ListTagsRequest buildWithoutInvocationCallback() {
            return new ListTagsRequest(this.tagNamespaceId, this.page, this.limit, this.lifecycleState);
        }

        public String toString() {
            return "ListTagsRequest.Builder(tagNamespaceId=" + this.tagNamespaceId + ", page=" + this.page + ", limit=" + this.limit + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }
}

