/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import com.oracle.bmc.ConfigFileReader;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.database.DatabaseClient;
import com.oracle.bmc.database.model.CreateAutonomousDatabaseBase;
import com.oracle.bmc.database.model.CreateAutonomousDatabaseDetails;
import com.oracle.bmc.database.model.GenerateAutonomousDatabaseWalletDetails;
import com.oracle.bmc.database.requests.CreateAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.GenerateAutonomousDatabaseWalletRequest;
import com.oracle.bmc.database.responses.GenerateAutonomousDatabaseWalletResponse;
import com.oracle.bmc.identity.IdentityClient;
import com.oracle.bmc.identity.model.Tenancy;
import com.oracle.bmc.identity.requests.GetTenancyRequest;
import com.oracle.bmc.identity.responses.GetTenancyResponse;
import com.oracle.bmc.model.BmcException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.cloud.oracle.Bundle;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.items.TenancyItem;
import org.openide.util.Exceptions;

public final class OCIManager {
    private ConfigFileReader.ConfigFile configFile;
    private ConfigFileAuthenticationDetailsProvider provider;
    private ConfigFileAuthenticationDetailsProvider configProvider;
    private static OCIManager instance;

    private OCIManager() {
        this.init();
    }

    private void init() {
        try {
            this.configFile = ConfigFileReader.parseDefault();
            this.provider = new ConfigFileAuthenticationDetailsProvider(this.configFile);
            this.configProvider = new ConfigFileAuthenticationDetailsProvider(this.configFile);
        }
        catch (Throwable ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static synchronized OCIManager getDefault() {
        if (instance == null) {
            instance = new OCIManager();
        }
        return instance;
    }

    public Optional<TenancyItem> getTenancy() {
        Optional<TenancyItem> optional;
        if (this.provider == null) {
            return Optional.empty();
        }
        IdentityClient identityClient = new IdentityClient((BasicAuthenticationDetailsProvider)this.provider);
        try {
            identityClient.setRegion(this.configProvider.getRegion());
            GetTenancyRequest gtr = GetTenancyRequest.builder().tenancyId(this.provider.getTenantId()).build();
            GetTenancyResponse response = identityClient.getTenancy(gtr);
            Tenancy tenancy = response.getTenancy();
            TenancyItem item = new TenancyItem(OCID.of(tenancy.getId(), "Tenancy"), tenancy.getName());
            item.setDescription(Bundle.LBL_HomeRegion(tenancy.getHomeRegionKey()));
            optional = Optional.of(item);
        }
        catch (Throwable throwable) {
            try {
                try {
                    identityClient.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
                return Optional.empty();
            }
        }
        identityClient.close();
        return optional;
    }

    public ConfigFileAuthenticationDetailsProvider getConfigProvider() {
        return this.configProvider;
    }

    public Optional<String> createAutonomousDatabase(String compartmentId, String dbName, char[] password) {
        DatabaseClient client = new DatabaseClient((BasicAuthenticationDetailsProvider)this.configProvider);
        try {
            Object object;
            CreateAutonomousDatabaseDetails createAutonomousDatabaseBase = CreateAutonomousDatabaseDetails.builder().compartmentId(compartmentId).dbName(dbName).adminPassword(new String(password)).cpuCoreCount(Integer.valueOf(1)).dataStorageSizeInTBs(Integer.valueOf(1)).build();
            CreateAutonomousDatabaseRequest createAutonomousDatabaseRequest = CreateAutonomousDatabaseRequest.builder().createAutonomousDatabaseDetails((CreateAutonomousDatabaseBase)createAutonomousDatabaseBase).build();
            try {
                object = client.createAutonomousDatabase(createAutonomousDatabaseRequest);
            }
            catch (BmcException e) {
                Optional<String> optional = Optional.of(e.getMessage());
                client.close();
                return optional;
            }
            object = Optional.empty();
            return object;
        }
        finally {
            try {
                client.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public Path downloadWallet(OCIItem dbInstance, String password, String parentPath) throws FileNotFoundException, IOException {
        try (DatabaseClient client = new DatabaseClient((BasicAuthenticationDetailsProvider)this.configProvider);){
            ZipEntry entry;
            GenerateAutonomousDatabaseWalletDetails details = GenerateAutonomousDatabaseWalletDetails.builder().password(password).build();
            GenerateAutonomousDatabaseWalletRequest generateAutonomousDatabaseWalletRequest = GenerateAutonomousDatabaseWalletRequest.builder().autonomousDatabaseId(dbInstance.getKey().getValue()).generateAutonomousDatabaseWalletDetails(details).build();
            GenerateAutonomousDatabaseWalletResponse response = client.generateAutonomousDatabaseWallet(generateAutonomousDatabaseWalletRequest);
            Path walletPath = null;
            int i = 1;
            while (Files.exists(walletPath = walletPath == null ? Paths.get(parentPath, dbInstance.getName()) : Paths.get(parentPath, dbInstance.getName() + "_" + i++), new LinkOption[0])) {
            }
            Files.createDirectory(walletPath, new FileAttribute[0]);
            ZipInputStream zin = new ZipInputStream(response.getInputStream());
            while ((entry = zin.getNextEntry()) != null) {
                Path entryPath = walletPath.resolve(entry.getName());
                Files.copy(zin, entryPath, new CopyOption[0]);
            }
            Path path = walletPath;
            return path;
        }
    }
}

