/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog.impl.sun;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.xml.resolver.NbCatalogManager;
import org.apache.xml.resolver.tools.NbCatalogResolver;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptorBase;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.openide.util.NbBundle;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Catalog
implements CatalogReader,
CatalogDescriptorBase,
Serializable,
EntityResolver {
    private static final long serialVersionUID = 123659121L;
    private transient PropertyChangeSupport pchs;
    private transient EntityResolver peer;
    private transient String desc;
    private String location;
    private boolean preference = true;
    private static final String PROP_LOCATION = "cat-loc";
    private static final String PROP_PREF_PUBLIC = "cat-pref";
    private static final String PROP_DESC = "ca-desc";

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setShortDescription(NbBundle.getMessage(Catalog.class, (String)"MSG_prepared", (Object)this.location));
    }

    public synchronized void setLocation(String location) {
        String old = this.location;
        this.location = location;
        this.peer = null;
        this.getPCHS().firePropertyChange(PROP_LOCATION, old, location);
        this.updateDisplayName();
    }

    public String getLocation() {
        return this.location;
    }

    public void setPreferPublic(boolean val) {
        boolean old = this.preference;
        this.preference = val;
        this.getPCHS().firePropertyChange(PROP_LOCATION, old, val);
    }

    public boolean isPreferPublic() {
        return this.preference;
    }

    @Override
    public void addCatalogListener(CatalogListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPCHS().addPropertyChangeListener(l);
    }

    @Override
    public String getDisplayName() {
        String src = this.location;
        if (src == null || "".equals(src.trim())) {
            return NbBundle.getMessage(Catalog.class, (String)"PROP_missing_location");
        }
        return NbBundle.getMessage(Catalog.class, (String)"TITLE_catalog", (Object)this.location);
    }

    public String getName() {
        return this.getClass() + this.location + this.preference;
    }

    public void updateDisplayName() {
        String name = this.getDisplayName();
        this.getPCHS().firePropertyChange("ca-name", null, name);
    }

    public String getIconResource(int type) {
        return null;
    }

    @Override
    public Iterator getPublicIDs() {
        EntityResolver p = this.getPeer();
        if (p instanceof NbCatalogResolver) {
            org.apache.xml.resolver.Catalog cat = ((NbCatalogResolver)p).getCatalog();
            return cat.getPublicIDs();
        }
        return null;
    }

    @Override
    public String getShortDescription() {
        return this.desc;
    }

    public void setShortDescription(String desc) {
        String old = this.desc;
        this.desc = desc;
        this.getPCHS().firePropertyChange(PROP_DESC, old, desc);
    }

    @Override
    public String getSystemID(String publicId) {
        EntityResolver p = this.getPeer();
        if (p instanceof NbCatalogResolver) {
            try {
                return ((NbCatalogResolver)p).getCatalog().resolveSystem(publicId);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public synchronized void refresh() {
        this.peer = this.createPeer(this.location, this.preference);
    }

    @Override
    public void removeCatalogListener(CatalogListener l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPCHS().removePropertyChangeListener(l);
    }

    @Override
    public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
        return this.getPeer().resolveEntity(publicID, systemID);
    }

    private EntityResolver createPeer(String location, boolean pref) {
        try {
            NbCatalogManager manager = new NbCatalogManager(null);
            manager.setUseStaticCatalog(false);
            manager.setPreferPublic(pref);
            NbCatalogResolver catalogResolver = new NbCatalogResolver(manager);
            org.apache.xml.resolver.Catalog cat = catalogResolver.getCatalog();
            cat.parseCatalog(new URL(location));
            this.setShortDescription(NbBundle.getMessage(Catalog.class, (String)"DESC_loaded"));
            return catalogResolver;
        }
        catch (IOException ex) {
            this.setShortDescription(NbBundle.getMessage(Catalog.class, (String)"DESC_error_loading", (Object)ex.getLocalizedMessage()));
            return new EntityResolver(){

                @Override
                public InputSource resolveEntity(String p, String s) {
                    return null;
                }
            };
        }
    }

    private synchronized PropertyChangeSupport getPCHS() {
        if (this.pchs == null) {
            this.pchs = new PropertyChangeSupport(this);
        }
        return this.pchs;
    }

    private synchronized EntityResolver getPeer() {
        if (this.peer == null) {
            this.peer = this.createPeer(this.location, this.preference);
        }
        return this.peer;
    }

    @Override
    public String resolveURI(String name) {
        EntityResolver p = this.getPeer();
        if (p instanceof NbCatalogResolver) {
            try {
                return ((NbCatalogResolver)p).getCatalog().resolveURI(name);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String resolvePublic(String publicId) {
        EntityResolver p = this.getPeer();
        if (p instanceof NbCatalogResolver) {
            try {
                return ((NbCatalogResolver)p).getCatalog().resolvePublic(publicId, null);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

