/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.index;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.javascript2.editor.parser.SanitizingParser;
import org.netbeans.modules.javascript2.model.api.IndexedElement;
import org.netbeans.modules.javascript2.model.api.JsArray;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.JsReference;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.types.api.TypeUsage;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class JsIndexer
extends EmbeddingIndexer {
    private static final Logger LOG = Logger.getLogger(JsIndexer.class.getName());
    private static final ChangeSupport changeSupport = new ChangeSupport(JsIndexer.class);

    protected void index(Indexable indexable, Parser.Result result, Context context) {
        IndexingSupport support;
        LOG.log(Level.FINE, "Indexing: {0}, fullPath: {1}", new Object[]{indexable.getRelativePath(), result.getSnapshot().getSource().getFileObject().getPath()});
        if (!(result instanceof JsParserResult)) {
            return;
        }
        if (!context.checkForEditorModifications()) {
            // empty if block
        }
        JsParserResult parserResult = (JsParserResult)result;
        Model model = Model.getModel((ParserResult)parserResult, (boolean)true);
        try {
            support = IndexingSupport.getInstance((Context)context);
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, null, ioe);
            return;
        }
        support.removeDocuments(indexable);
        JsObject globalObject = model.getGlobalObject();
        for (JsObject object : globalObject.getProperties().values()) {
            if (object.getParent() == null) continue;
            IdentityHashMap<JsObject, Integer> visited = new IdentityHashMap<JsObject, Integer>();
            this.storeObject(object, object.getName(), support, indexable, visited);
        }
        IndexDocument document = support.createDocument(indexable);
        for (JsObject object : globalObject.getProperties().values()) {
            if (object.getParent() == null) continue;
            IdentityHashMap<JsObject, Integer> visited = new IdentityHashMap<JsObject, Integer>();
            this.storeUsages(object, object.getName(), document, visited);
        }
        support.addDocument(document);
    }

    protected static IndexDocument createDocument(JsObject object, String fqn, IndexingSupport support, Indexable indexable) {
        IndexDocument elementDocument = support.createDocument(indexable);
        elementDocument.addPair("bn", object.getName(), true, true);
        elementDocument.addPair("bni", object.getName().toLowerCase(), true, false);
        elementDocument.addPair("fqn", fqn + (char)(object.isAnonymous() ? 65 : (object.getJSKind() == JsElement.Kind.PARAMETER ? 80 : 79)), true, true);
        elementDocument.addPair("offset", Integer.toString(object.getOffset()), true, true);
        elementDocument.addPair("flag", Integer.toString(IndexedElement.Flag.getFlag((JsObject)object)), false, true);
        StringBuilder sb = new StringBuilder();
        for (TypeUsage type : object.getAssignments()) {
            sb.append(type.getType());
            sb.append(":");
            sb.append(type.getOffset());
            sb.append(":");
            sb.append(type.isResolved() ? "1" : "0");
            sb.append("|");
        }
        elementDocument.addPair("assign", sb.toString(), false, true);
        if (object.getJSKind().isFunction()) {
            sb = new StringBuilder();
            for (TypeUsage type : ((JsFunction)object).getReturnTypes()) {
                sb.append(type.getType());
                sb.append(",");
                sb.append(type.getOffset());
                sb.append(",");
                sb.append(type.isResolved() ? "1" : "0");
                sb.append("|");
            }
            elementDocument.addPair("return", sb.toString(), false, true);
            elementDocument.addPair("param", JsIndexer.codeParameters(((JsFunction)object).getParameters()), false, true);
        }
        if (object instanceof JsArray) {
            sb = new StringBuilder();
            for (TypeUsage type : ((JsArray)object).getTypesInArray()) {
                sb.append(type.getType());
                sb.append(",");
                sb.append(type.getOffset());
                sb.append(",");
                sb.append(type.isResolved() ? "1" : "0");
                sb.append("|");
            }
            elementDocument.addPair("array", sb.toString(), false, true);
        }
        return elementDocument;
    }

    protected static IndexDocument createDocumentForReference(JsReference object, String fqn, IndexingSupport support, Indexable indexable) {
        IndexDocument elementDocument = support.createDocument(indexable);
        elementDocument.addPair("bn", object.getName(), true, true);
        elementDocument.addPair("bni", object.getName(), true, false);
        elementDocument.addPair("fqn", fqn + (char)(object.isAnonymous() ? 65 : (object.getJSKind() == JsElement.Kind.PARAMETER ? 80 : 79)), true, true);
        elementDocument.addPair("offset", Integer.toString(object.getOffset()), true, true);
        elementDocument.addPair("flag", Integer.toString(IndexedElement.Flag.getFlag((JsObject)object)), false, true);
        StringBuilder sb = new StringBuilder();
        sb.append(object.getOriginal().getFullyQualifiedName());
        sb.append(":");
        sb.append(object.getOffset());
        sb.append(":");
        sb.append("1");
        elementDocument.addPair("assign", sb.toString(), false, true);
        if (object.getJSKind().isFunction()) {
            sb = new StringBuilder();
            for (TypeUsage type : ((JsFunction)object).getReturnTypes()) {
                sb.append(type.getType());
                sb.append(",");
                sb.append(type.getOffset());
                sb.append(",");
                sb.append(type.isResolved() ? "1" : "0");
                sb.append("|");
            }
            elementDocument.addPair("return", sb.toString(), false, true);
            elementDocument.addPair("param", JsIndexer.codeParameters(((JsFunction)object).getParameters()), false, true);
        }
        if (object instanceof JsArray) {
            sb = new StringBuilder();
            for (TypeUsage type : ((JsArray)object).getTypesInArray()) {
                sb.append(type.getType());
                sb.append(",");
                sb.append(type.getOffset());
                sb.append(",");
                sb.append(type.isResolved() ? "1" : "0");
                sb.append("|");
            }
            elementDocument.addPair("array", sb.toString(), false, true);
        }
        return elementDocument;
    }

    private void storeObject(JsObject object, String fqn, IndexingSupport support, Indexable indexable, IdentityHashMap<JsObject, Integer> visited) {
        if (visited.containsKey(object)) {
            return;
        }
        IdentityHashMap<JsObject, Integer> childVisited = new IdentityHashMap<JsObject, Integer>(visited);
        childVisited.compute(object, (k, v) -> v == null ? 1 : v + 1);
        if (!this.isInvisibleFunction(object) && object != null && object.getName() != null) {
            if (object.isDeclared() || "prototype".equals(object.getName())) {
                IndexDocument document = JsIndexer.createDocument(object, fqn, support, indexable);
                support.addDocument(document);
            }
            if (!(object instanceof JsReference) || !ModelUtils.isDescendant((JsObject)object, (JsObject)((JsReference)object).getOriginal())) {
                for (JsObject property : object.getProperties().values()) {
                    if (!(property instanceof JsReference) || ((JsReference)property).getOriginal().isAnonymous()) {
                        this.storeObject(property, fqn + '.' + property.getName(), support, indexable, childVisited);
                        continue;
                    }
                    IndexDocument document = JsIndexer.createDocumentForReference((JsReference)property, fqn + '.' + property.getName(), support, indexable);
                    support.addDocument(document);
                }
                if (object instanceof JsFunction) {
                    for (JsObject parameter : ((JsFunction)object).getParameters()) {
                        this.storeObject(parameter, fqn + '.' + parameter.getName(), support, indexable, childVisited);
                    }
                }
            }
        }
    }

    private boolean isInvisibleFunction(JsObject object) {
        if (object.getJSKind().isFunction() && (object.isAnonymous() || object.getModifiers().contains(Modifier.PRIVATE))) {
            Collection returnTypes;
            JsObject parent = object.getParent();
            if (parent != null && parent.getJSKind() == JsElement.Kind.FILE) {
                return false;
            }
            if (parent != null && parent instanceof JsFunction) {
                returnTypes = ((JsFunction)parent).getReturnTypes();
                String fqn = object.getFullyQualifiedName();
                for (TypeUsage returnType : returnTypes) {
                    if (!returnType.getType().equals(fqn)) continue;
                    return false;
                }
            }
            if ((returnTypes = ((JsFunction)object).getReturnTypes()).size() == 1 && ((TypeUsage)returnTypes.iterator().next()).getType().equals("undefined")) {
                return true;
            }
        }
        return false;
    }

    private static String codeParameters(Collection<? extends JsObject> params) {
        StringBuilder result = new StringBuilder();
        Iterator<? extends JsObject> it = params.iterator();
        while (it.hasNext()) {
            JsObject parametr = it.next();
            result.append(parametr.getName());
            result.append(":");
            Iterator itType = parametr.getAssignmentForOffset(parametr.getOffset() + 1).iterator();
            while (itType.hasNext()) {
                TypeUsage type = (TypeUsage)itType.next();
                result.append(type.getType());
                if (!itType.hasNext()) continue;
                result.append("|");
            }
            if (!it.hasNext()) continue;
            result.append(',');
        }
        return result.toString();
    }

    private void storeUsages(JsObject object, String name, IndexDocument document, IdentityHashMap<JsObject, Integer> visited) {
        if (visited.containsKey(object)) {
            return;
        }
        IdentityHashMap<JsObject, Integer> childVisited = new IdentityHashMap<JsObject, Integer>(visited);
        childVisited.compute(object, (k, v) -> v == null ? 1 : v + 1);
        StringBuilder sb = new StringBuilder();
        sb.append(object.getName());
        for (JsObject property : object.getProperties().values()) {
            if (!this.storeUsage(property)) continue;
            sb.append(':');
            sb.append(property.getName()).append('#');
            if (property.getJSKind().isFunction()) {
                sb.append('F');
                continue;
            }
            sb.append('P');
        }
        document.addPair("usage", sb.toString(), true, true);
        if (object instanceof JsFunction) {
            for (JsObject parameter : ((JsFunction)object).getParameters()) {
                this.storeUsages(parameter, parameter.getName(), document, childVisited);
            }
        }
        for (JsObject property : object.getProperties().values()) {
            if (!this.storeUsage(property) || property instanceof JsReference && !((JsReference)property).getOriginal().isAnonymous()) continue;
            this.storeUsages(property, property.getName(), document, childVisited);
        }
    }

    private boolean storeUsage(JsObject object) {
        boolean result = true;
        if ("arguments".equals(object.getName()) || object.getJSKind() == JsElement.Kind.ANONYMOUS_OBJECT || object.getModifiers().contains(Modifier.PRIVATE)) {
            result = false;
        }
        return result;
    }

    public static final class PostScanProvider
    implements org.netbeans.modules.javascript2.editor.spi.PostScanProvider {
        @Override
        public void addPostScanTask(Runnable task) {
            Factory.addPostScanTask(task);
        }
    }

    public static final class IndexChangeSupport
    implements org.netbeans.modules.javascript2.model.spi.IndexChangeSupport {
        public void addChangeListener(ChangeListener listener) {
            changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            changeSupport.removeChangeListener(listener);
        }

        public void fireChange() {
            changeSupport.fireChange();
        }
    }

    public static final class Factory
    extends EmbeddingIndexerFactory {
        public static final String NAME = "js";
        public static final int VERSION = 16;
        private static final int PRIORITY = 100;
        private static final ThreadLocal<Collection<Runnable>> postScanTasks = new ThreadLocal();

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(indexable, snapshot)) {
                return new JsIndexer();
            }
            return null;
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 16;
        }

        private boolean isIndexable(Indexable indexable, Snapshot snapshot) {
            if ((long)snapshot.getText().length() > SanitizingParser.MAX_FILE_SIZE_TO_PARSE && !SanitizingParser.PARSE_BIG_FILES) {
                return false;
            }
            return "text/javascript".equals(snapshot.getMimeType());
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : deleted) {
                    is.removeDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }

        public void rootsRemoved(Iterable<? extends URL> removedRoots) {
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : dirty) {
                    is.markDirtyDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }

        public boolean scanStarted(Context context) {
            postScanTasks.set(new LinkedList());
            return super.scanStarted(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scanFinished(Context context) {
            IndexChangeSupport changeSupport;
            if (context.isAllFilesIndexing() && (changeSupport = (IndexChangeSupport)Lookup.getDefault().lookup(IndexChangeSupport.class)) != null) {
                changeSupport.fireChange();
            }
            try {
                for (Runnable task : postScanTasks.get()) {
                    task.run();
                }
            }
            finally {
                postScanTasks.remove();
                super.scanFinished(context);
            }
        }

        public static boolean isScannerThread() {
            return postScanTasks.get() != null;
        }

        public static void addPostScanTask(@NonNull Runnable task) {
            Parameters.notNull((CharSequence)"task", (Object)task);
            Collection<Runnable> tasks = postScanTasks.get();
            if (tasks == null) {
                throw new IllegalStateException("JsIndexer.postScanTask can be called only from scanner thread.");
            }
            tasks.add(task);
        }

        public int getPriority() {
            return 100;
        }
    }
}

